package com.zing.zalo.zbrowser;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.zing.zalo.zbrowser.cache.CacheItem;
import com.zing.zalo.zbrowser.cache.ConfigCache;
import com.zing.zalo.zbrowser.cache.DiskLruCache;
import com.zing.zalo.zbrowser.cache.MemoryLruCache;
import com.zing.zalo.zbrowser.downloader.HttpUrl;
import com.zing.zalo.zbrowser.util.ZBrowserUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.net.MalformedURLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ZBrowser extends ZBrowserCore {

    private MemoryLruCache jumpDataMemCache = null;

    private DiskLruCache jumpDataDiskCache = null;

//    private DeviceInfo currentDeviceInfo;

    /**
     * Must be using constructor {@link ZBrowser(ConfigCache, String, ZBrowserPreload.ZBrowserPreloadCallback )}
     *
     * @param configCache
     * @param diskCacheDirectory
     */
    @Deprecated
    public ZBrowser(@NonNull ConfigCache configCache, @NonNull String diskCacheDirectory, Context context) {
        this(configCache, diskCacheDirectory, null, context); //force null provider
    }


    public ZBrowser(@NonNull ConfigCache configCache, @NonNull String diskCacheDirectory, @NonNull ZBrowserPreload.ZBrowserPreloadCallback zbrowserCallback, Context context) {
        super(configCache, diskCacheDirectory, context);
        this.setZbrowserPreloadCallback(zbrowserCallback);
        if (configCache.jumpMemSize > 0) {
            jumpDataMemCache = new MemoryLruCache(configCache.jumpMemSize, null);
        }

//        if (configCache.jumpDiskSize > 0) {
//            try {
//                jumpDataDiskCache = DiskLruCache.open(getZBrowserJumpDir(context), 1, 1, configCache.jumpDiskSize, null, true);
//            } catch (Exception e) {
//                Log.w(LOG_TAG, "Cannot init jump data disk cache", e);
//            }
//        }

//        currentDeviceInfo = DeviceInfo.getDeviceInfo(zbrowserCallback.getCurrentLanguage(), zbrowserCallback.getCurrentTheme());

//        try {
////            CookieManager cookieManager = null;
//            if (CoreUtility.getAppContext() != null) {
//                CookieSyncManager.createInstance(CoreUtility.getAppContext());
//                cookieManager = CookieManager.getInstance();
//                cookieManager.setAcceptCookie(true);
//            }
//
//            //check jump data in cache and build cookie
////            for (String domain : configCache.preloadDomains) {
////                JSONObject jumpData = getJumpDataJSon(domain);
////                if (jumpData != null) {
////                    buildCookieFromJumpData(jumpData, cookieManager);
////                }
//////                buildCookieDeviceInfo(currentDeviceInfo, domain, cookieManager);
////            }
//
//            if (cookieManager != null) {
//                if (AndroidVersionUtils.isLollipopAndAbove()) {
//                    cookieManager.flush();
//                } else {
//                    CookieSyncManager.getInstance().sync();
//                }
//            }
//        } catch (Exception e) {
//
//        }

    }

    private void removeJumpData(@NonNull String domain) {
        CacheItem cachedItem = null;
        if (jumpDataMemCache != null) {
            cachedItem = jumpDataMemCache.get(domain);
            if(cachedItem != null){
                jumpDataMemCache.remove(domain);
            }
        }

        if (jumpDataDiskCache != null) {
            cachedItem = getFromDiskCache(jumpDataDiskCache, domain);
            if (cachedItem != null && jumpDataMemCache != null) {
                removeFromDiskCache(jumpDataDiskCache, domain);
            }
        }

    }

    @Nullable
    public JSONObject getJumpLinkData(@NonNull String request) throws JSONException {
        if (!getCacheConfig().isNeedToPreload(request)) {
            return null;
        }
        final String urlDomain;
        try {
            urlDomain = HttpUrl.parseUrl(request).domain;
        } catch (MalformedURLException e) {
            Log.e(LOG_TAG, String.format("Invalid url: %s", request), e);
            return null;
        }
        CacheItem jumpData = getJumpData(urlDomain);
        if (jumpData != null) {
            //check jumpData expireTime
            if (jumpData.expireTime < System.currentTimeMillis() / 1000) {
                removeJumpData(urlDomain);
                if (investigateListener != null) {
                    investigateListener.submitLog(String.format("JUMP - DONE: %s", request));
                }
                return null;
            }
            // jump data available
            JSONObject jump = new JSONObject(new String(jumpData.data));
//            WebViewRequest req = new WebViewRequest(request.featureId, checkUrlRedirect(request.url), request.extraInfo, request.srcType, request.srcParam, request.isSupportToCache);
            String resultUrl = ZBrowserUtil.buildUrlWithTrackingParam(checkUrlRedirect(request), request);
            jump.put("url", resultUrl);
            jump.put("inApp", 1);
            jump.put("extOpen", null);

            //clear all cookie before return
            jump.put("cookiesIdLogins", new JSONArray());
            jump.put("cookiesOAuthLogins", new JSONArray());

            //check device info
//            DeviceInfo deviceInfo = DeviceInfo.getDeviceInfo(zbrowserCallback.getCurrentLanguage(), zbrowserCallback.getCurrentTheme());
//            if (!deviceInfo.equals(currentDeviceInfo)) {
//                currentDeviceInfo = deviceInfo;
//                buildCookieDeviceInfo(currentDeviceInfo, urlDomain);
//            }

            if (investigateListener != null) {
                investigateListener.submitLog(String.format("JUMP - DONE: %s", resultUrl));
            }
            return jump;
        }
        if (investigateListener != null) {
            investigateListener.submitLog(String.format("JUMP - FAILED: %s", request));
        }
        return null;
    }

    public void load(final List<String> requests, final DownloadCallback callback, final PreloadParam preloadParam, Context context) {
        if (requests == null || requests.size() <= 0) return;
        if (cacheConfig.downloadOverWifiOnly && !ZBrowserUtil.isConnectedWifi(context)) {
            for (String url : requests) {
                callback.onError(url);
            }
            //only download over wifi
            if (investigateListener != null) {
                investigateListener.submitLog(String.format("PRELOAD - IGNORE (not use wifi)"));
            }
            return;
        }
        final ArrayList<String> listKeyRequest = new ArrayList<>();
//        final Set<String> listUniqueDomain = new HashSet<>();
        //check device info
//        boolean deviceInfoChanged = false;
//        DeviceInfo deviceInfo = DeviceInfo.getDeviceInfo(zbrowserCallback.getCurrentLanguage(), zbrowserCallback.getCurrentTheme());
//        if (!deviceInfo.equals(currentDeviceInfo)) {
//            currentDeviceInfo = deviceInfo;
//            deviceInfoChanged = true;
//        }
        for (String url : requests) {
            if (!getCacheConfig().isNeedToPreload(url)) {
                if (investigateListener != null) {
                    investigateListener.submitLog(String.format("No need to preload: %s", url));
                }
                continue;
            }
//            final String urlDomain;
//            try {
//                urlDomain = HttpUrl.parseUrl(url).domain;
//            } catch (MalformedURLException e) {
//                Log.e(LOG_TAG, String.format("Invalid url: %s", url), e);
//                continue;
//            }
////            if (deviceInfoChanged && !listUniqueDomain.contains(urlDomain)) {
////                buildCookieDeviceInfo(currentDeviceInfo, urlDomain);
////            }

            ZBrowser.super.load(url, callback, preloadParam, context);
        }
    }

    private void jumpPreloadSuccess(final List<String> jumpInputOutputList, JSONObject jsonObject, DownloadCallback callback) throws JSONException {
//        JSONObject data = jsonObject.getJSONObject("data");
//        //update zbrowser config if exist in jump response
//        JSONObject zbrowserConfig = data.optJSONObject("zbrowser_config");
//        if (zbrowserConfig != null) {
//            ConfigCache newConfig = ConfigCache.getConfigFromJson(zbrowserConfig);
//
//            if (ZBrowser.this.setCacheConfig(newConfig)) {
//                zbrowserCallback.updateCacheConfigIntoLocal(zbrowserConfig.toString());
//            }
//        }
//        for (int k = 0; k < jumpInputOutputList.size(); k++) {
//            LinkJumpInput dataRoot = null;
//            try {
//                dataRoot = jumpInputOutputList.get(k);
//
//                JSONObject jsonDataEachUrl = data.optJSONObject(String.valueOf(dataRoot.requestKey));
//
//                final String url = dataRoot.webViewRequest.url;
//                final String urlDomain;
//                try {
//                    urlDomain = HttpUrl.parseUrl(url).domain;
//                } catch (MalformedURLException e) {
//                    Log.e(LOG_TAG, String.format("Invalid url: %s", url), e);
//                    continue;
//                }
//
//                //cache this jump data
//                CacheItem cache = new CacheItem((int) (System.currentTimeMillis() / 1000 + cacheConfig.jumpExpire), "json", jsonDataEachUrl.toString().getBytes(), "");
//                putJumpData(urlDomain, cache);
//
//            } catch (Exception e) {
//                e.printStackTrace();
//                if (callback != null && dataRoot != null) {
//                    callback.onError(dataRoot.webViewRequest.url);
//                }
//            }
//        }
    }

    private JSONObject getJumpDataJSon(@NonNull String domain) {
        CacheItem cachedItem = getJumpData(domain);
        if (cachedItem == null) {
            return null;
        }
        String jsonString = "";
        try {
            jsonString = new String(cachedItem.data);
            JSONObject result = new JSONObject(jsonString);
            return result;
        } catch (Exception e) {
            Log.e(LOG_TAG, String.format("Cannot deserialize json from cached item. Key: %s, Value: %s", domain, jsonString));
            return null;
        }
    }

    private CacheItem getJumpData(@NonNull String domain) {
        CacheItem cachedItem = null;
        if (jumpDataMemCache != null) {
            cachedItem = jumpDataMemCache.get(domain);
        }
        if (cachedItem == null && jumpDataDiskCache != null) {
            cachedItem = getFromDiskCache(jumpDataDiskCache, domain);
            if (cachedItem != null && jumpDataMemCache != null) {
                jumpDataMemCache._put(domain, cachedItem);
            }
        }
        return cachedItem;
    }

    public void putJumpData(String domain, CacheItem data) {
        if (jumpDataMemCache != null) {
            jumpDataMemCache._put(domain, data);
        }
        if (jumpDataDiskCache != null) {
            putToDiskCache(jumpDataDiskCache, domain, data);
        }
    }

//    private void buildCookieFromJumpData(JSONObject jumpData) {
//        try {
//            CookieManager cookieManager = null;
//            if (CoreUtility.getAppContext() != null) {
//                CookieSyncManager.createInstance(CoreUtility.getAppContext());
//                cookieManager = CookieManager.getInstance();
//                cookieManager.setAcceptCookie(true);
//            }
//            buildCookieFromJumpData(jumpData, cookieManager);
//            if (cookieManager != null) {
//                if (AndroidVersionUtils.isLollipopAndAbove()) {
//                    cookieManager.flush();
//                } else {
//                    CookieSyncManager.getInstance().sync();
//                }
//            }
//
//        } catch (Exception e) {
//            if (investigateListener != null) {
//                investigateListener.submitLog(String.format("build cookie from json jump fail: %s", e.getMessage()));
//            }
//        }
//    }

//    private void buildCookieFromJumpData(JSONObject jumpData, CookieManager cookieManager) {
//        Map<String, Map<String, String>> zbrowserCookiesHolder = new HashMap<>();
//
//        JSONArray cookiesIdLogins = jumpData.optJSONArray("cookiesIdLogins");
//        buildCookie(cookiesIdLogins, zbrowserCookiesHolder, cookieManager);
//
//        JSONArray cookiesOAuthLogins = jumpData.optJSONArray("cookiesOAuthLogins");
//        buildCookie(cookiesOAuthLogins, zbrowserCookiesHolder, cookieManager);
//
//        for (Map.Entry<String, Map<String, String>> entry : zbrowserCookiesHolder.entrySet()) {
//            addCookie(entry.getKey(), entry.getValue());
//        }
//    }

    private void buildCookie(JSONArray listJsonCookies, Map<String, Map<String, String>> zbrowserCookieHolder, CookieManager cookieManager) {
        if (listJsonCookies != null) {
            for (int i = 0; i < listJsonCookies.length(); ++i) {
                try {
                    JSONObject jsonCookie = listJsonCookies.getJSONObject(i);
                    String domain = jsonCookie.getString("domain");
                    String name = jsonCookie.getString("name");
                    String value = jsonCookie.getString("value");
                    Map<String, String> cookies = zbrowserCookieHolder.get(domain);
                    if (cookies == null) {
                        cookies = new HashMap<>();
                    }
                    cookies.put(name, value);
                    zbrowserCookieHolder.put(domain, cookies);

                    if (cookieManager != null) {
                        String path = jsonCookie.getString("path");
                        long expires = jsonCookie.getLong("expires");
                        boolean httpOnly = jsonCookie.optBoolean("httpOnly");
                        boolean secure = jsonCookie.optBoolean("secure");
                        String sameSite = jsonCookie.optString("sameSite");

                        Cookie _cookie = new Cookie(name, value, domain, path, secure, httpOnly, expires, null, sameSite);
                        cookieManager.setCookie(_cookie.url, _cookie.toString());
                    }

                } catch (JSONException e) {

                }
            }
        }
    }

//    private void buildCookieDeviceInfo(DeviceInfo deviceInfo, String domain) {
//        try {
//            CookieManager cookieManager = null;
//            if (CoreUtility.getAppContext() != null) {
//                CookieSyncManager.createInstance(CoreUtility.getAppContext());
//                cookieManager = CookieManager.getInstance();
//                cookieManager.setAcceptCookie(true);
//            }
//            buildCookieDeviceInfo(deviceInfo, domain, cookieManager);
//            if (cookieManager != null) {
//                if (AndroidVersionUtils.isLollipopAndAbove()) {
//                    cookieManager.flush();
//                } else {
//                    CookieSyncManager.getInstance().sync();
//                }
//            }
//        } catch (Exception e) {
//            if (investigateListener != null) {
//                investigateListener.submitLog(String.format("build cookie device info fail: %s", e.getMessage()));
//            }
//        }
//    }

//    private void buildCookieDeviceInfo(DeviceInfo deviceInfo, String domain, CookieManager cookieManager) {
//        if (deviceInfo == null) {
//            return;
//        }
//
//        Map<String, String> zbrowserCookies = new HashMap<>();
//
//        List<Cookie> listCookies = new LinkedList<>();
//        listCookies.add(new Cookie("zversion", deviceInfo.version + "", domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//        listCookies.add(new Cookie("ztype", DeviceInfo.DEVICE_TYPE + "", domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//        listCookies.add(new Cookie("zlanguage", deviceInfo.language, domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//        listCookies.add(new Cookie("fid", FeatureId.ID_NORMAL_LINK + "", domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//        listCookies.add(new Cookie("znetwork", deviceInfo.network + "", domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//        listCookies.add(new Cookie("zoperator", deviceInfo.operator + "", domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//        listCookies.add(new Cookie("ztheme", deviceInfo.ztheme, domain, "/", false, false, null, (5 * 60 * 60 * 1000) + "", null));
//
//        for (Cookie cookie : listCookies) {
//            zbrowserCookies.put(cookie.name, cookie.value);
//            if (cookieManager != null) {
//                cookieManager.setCookie(cookie.url, cookie.toString());
//            }
//        }
//        addCookie(domain, zbrowserCookies);
//    }

    public JSONObject handleJsBridge(String param) {
        try {
            JSONObject jsonParam = new JSONObject(param);
//            final int configVersion = jsonParam.optInt("configVersion", -1);

            //check config version and invalidate config
//            if (configVersion > 0) {
//                if (cacheConfig.version != configVersion) {
//                    //get new config
//                    if (zbrowserCallback != null) {
//                        List<WebViewRequest> listRequest = new ArrayList<>();
//                        for (String domain : cacheConfig.preloadDomains) {
//                            WebViewRequest req = new WebViewRequest(FeatureId.ZALO_PAGE, String.format("https://%s/", domain), "", 0, "", true);
//                            listRequest.add(req);
//                        }
//                        if (listRequest.isEmpty()) {
//                            listRequest.add(new WebViewRequest(FeatureId.ZALO_PAGE, String.format("https://%s/", "media.zalo.me"), "", 0, "", true));
//                        }
//                        zbrowserCallback.requestJumpPreload(listRequest, new ZBrowserPreload.ZBrowserPreloadCallback.AsyncCallback<JSONObject>() {
//                            @Override
//                            public void onError(int code, String exception) {
//                                if (investigateListener != null) {
//                                    investigateListener.submitLog(String.format("request jump preload fail. ECode: %d, Msg: %s", code, exception));
//                                }
//                            }
//
//                            @Override
//                            public void onSuccess(List<LinkJumpInput> jumpInputOutputList, JSONObject jsonObject) {
//                                try {
//                                    jumpPreloadSuccess(jumpInputOutputList, jsonObject, null);
//                                    cacheConfig.version = configVersion;
//                                    String cache = zbrowserCallback.getCurrentCacheConfigAtLocal();
//                                    if (cache != null) {
//                                        try {
//                                            JSONObject cacheObj = new JSONObject(cache);
//                                            cacheObj.put("version", configVersion);
//                                            zbrowserCallback.updateCacheConfigIntoLocal(cacheObj.toString());
//                                        } catch (Exception e) {
//
//                                        }
//                                    }
//                                } catch (Exception e) {
//
//                                }
//                            }
//                        });
//                    }
//                }
//            }
//
            JSONObject result = new JSONObject();

            JSONArray actions = jsonParam.optJSONArray("actions");
            if (actions != null) {
                JSONArray actionsResult = new JSONArray();
                for (int i = 0; i < actions.length(); ++i) {
                    JSONObject action = actions.getJSONObject(i);
                    if (action != null) {
                        int actionType = action.optInt("actionType", -1);
                        JSONObject actionResult = new JSONObject();
                        actionResult.put("actionType", actionType);
                        switch (actionType) {
                            case 1: //get stats
                                actionResult.put("error", 0); // success
                                actionResult.put("data", getStatistic().toJSON());
                                break;
                            case 2: // clear cache
                                String url = action.optString("data", "");
                                removeCacheItem(url);
                                actionResult.put("error", 0); // success
                                break;
                            case 3: // check resource
                                String url2 = action.optString("data", "");
                                boolean res = checkCacheItem(url2);
                                actionResult.put("error", 0); // success
                                actionResult.put("data", res);
                                break;
                            default: //invalid type
                                actionResult.put("error", -1); // invalid action type
                                break;
                        }
                        actionsResult.put(actionResult);
                    }
                }
                result.put("data", actionsResult);
            }

            return result;
        } catch (JSONException e) {

        }

        return null;
    }

    public static File getZBrowserJumpDir(Context context) {
        return new File(context.getCacheDir(), "zbrowserjump");
    }

    public static void cleanJumpData(Context context) {
        try {
            DiskLruCache.Util.deleteContents(getZBrowserJumpDir(context));
        } catch (Exception ignored) {
        }
    }

    public void cleanAllDataInCache(Context context) {
        try {
            if (jumpDataMemCache != null) {
                jumpDataMemCache.evictAll();
                jumpDataMemCache = null;
            }
            if (jumpDataDiskCache != null) {
                jumpDataDiskCache.delete();
                jumpDataDiskCache = null;
            }
            cleanJumpData(context);
        } catch (Exception e) {

        }
    }

    private static class DeviceInfo {
        public static final int DEVICE_TYPE = 1;

        public int version;

        public String language;

        public int network;

        public int operator;

        public String ztheme;

        public DeviceInfo(int version, String language, int network, int operator, String ztheme) {
            this.version = version;
            this.language = language;
            this.network = network;
            this.operator = operator;
            this.ztheme = ztheme;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DeviceInfo)) {
                return false;
            }
            DeviceInfo another = (DeviceInfo) obj;
            if (version != another.version) {
                return false;
            }
            if (!String.valueOf(language).equals(another.language)) {
                return false;
            }
            if (network != another.network) {
                return false;
            }
            if (operator != another.operator) {
                return false;
            }

            return true;
        }

//        public static DeviceInfo getDeviceInfo(String language, String theme) {
//            int versionCode = CoreUtility.versionCode;
////            int network = Connectivity.getTypeOfConnectionWithNotAvailableState();
//            int operator = CoreUtils.getMNC();
//
//            return new DeviceInfo(versionCode, language, network, operator, theme);
//        }
    }

    private static class Cookie {

        private String name;
        private String value;
        private String domain;
        private String path;
        private String url;

        private boolean secure;
        private boolean httpOnly;
        private String expires;
        private String maxAge;
        private String sameSite;

        public Cookie(String name, String value, String domain, String path, boolean secure, boolean httpOnly, String expires, String maxAge, String sameSite) {
            this.name = name;
            this.value = value;
            this.domain = domain;
            this.path = path;
            this.secure = secure;
            this.httpOnly = httpOnly;
            this.expires = expires;
            this.maxAge = maxAge;
            this.sameSite = sameSite;
            this.url = (secure ? "https" : "http") + "://" + domain + path;
        }

        public Cookie(String name, String value, String domain, String path, boolean secure, boolean httpOnly, long expires, String maxAge, String sameSite) {
            this(name, value, domain, path, secure, httpOnly, null, maxAge, sameSite);
            if (expires > 0) {
                DateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                this.expires = dateFormat.format(new Date(System.currentTimeMillis() + expires * 1000));
            } else {
                this.expires = "-1";
            }
        }

        @Override
        public String toString() {
            List<String> listCookieParam = new LinkedList<>();
            listCookieParam.add(String.format("%s=%s", name, value));
            listCookieParam.add(String.format("Domain=%s", domain));
            listCookieParam.add(String.format("Path=%s", path));
            if (TextUtils.isEmpty(expires)) {
                listCookieParam.add(String.format("Expires=%s", expires));
            }
            if (TextUtils.isEmpty(maxAge)) {
                listCookieParam.add(String.format("max-age=%s", maxAge));
            }
            if (secure) {
                listCookieParam.add("Secure");
            }
            if (httpOnly) {
                listCookieParam.add("HttpOnly");
            }
            if (!TextUtils.isEmpty(sameSite)) {
                listCookieParam.add(String.format("SameSite=%s", sameSite));
            }
            return TextUtils.join(";", listCookieParam.toArray());
        }
    }

    protected void setCacheConfig(JSONObject zbrowserConfig, Context context) {
        try {
            if(zbrowserCallback != null) {
                zbrowserCallback.updateCacheConfigIntoLocal(zbrowserConfig.toString());
            }
            ConfigCache config = ConfigCache.getConfigFromJson(zbrowserConfig);
            setCacheConfig(config, context);
        } catch (Exception e) {

        }
    }
}
