/*
 * Copyright (c) 2012-2018 by Zalo Group.
 * All Rights Reserved.
 */
package com.zing.zalo.zbrowser.downloader;

import java.io.ByteArrayOutputStream;

/**
 *
 * @author datbt
 */
public class ChunkedParser {
	private final byte[] in;
	
	/** The chunk size */
    private int chunkSize;
    /** The current position within the current chunk */
    private int pos = 0;
    /** True if we are at the beginning of stream */
    private boolean bof = true;
    /** True if we've reached the end of stream */
    private boolean eof = false;

	public ChunkedParser(byte[] in) {
		if (in == null) {
			throw new IllegalArgumentException("Input data should not be null");
		}
		this.in = in;
	}
	
	public byte[] parse() throws Exception {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		StringBuilder chunkLengthStr = new StringBuilder();
		while (pos < in.length) {
			if ((char) in[pos] != HTTP.CR) {
				chunkLengthStr.append((char) in[pos]);
				++pos;
				continue;
			}
			if (pos + 1 >= in.length ||  in[pos + 1] != HTTP.LF) {
				throw new Exception("CRLF expected at the end of chunk header");
			}
			int chunkLength;
			try {
				chunkLength = Integer.parseInt(chunkLengthStr.toString(), 16);
			} catch (NumberFormatException e) {
				throw new Exception("Invalid chunk length: " + chunkLengthStr.toString());
			}
			chunkLengthStr = new StringBuilder();
			pos += 2;
			if (chunkLength > 0) {
				if (pos + chunkLength > in.length) {
					throw new Exception("Invalid chunk data");
				}
				baos.write(in, pos, chunkLength);
				pos += chunkLength;
				if (pos >= in.length || in[pos] != HTTP.CR || in[pos + 1] != HTTP.LF) {
					throw new Exception("CRLF expected at the end of chunk data");
				}
				pos += 2;
			} else if (chunkLength == 0) {
				if (pos + 2 != in.length || in[pos] != HTTP.CR || in[pos + 1] != HTTP.LF) {
					throw new Exception("Invalid stream footer");
				}
				break;
			} else {
				throw new Exception("Negative chunk length: " + chunkLength);
			}
		}
		
		return baos.toByteArray();
	}
}
