/*
 * Copyright (c) 2012-2018 by Zalo Group.
 * All Rights Reserved.
 */
package com.zing.zalo.zbrowser.downloader;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 *
 * @author datbt
 */
public class HttpHeader {

	private final Map<String, String> headers;

	public HttpHeader() {
		this.headers = new ConcurrentHashMap<>();
	}

	public HttpHeader(Map<String, String> headers) {
		this.headers = new ConcurrentHashMap<>();
		setHeaders(headers);
	}

	public final HttpHeader setHeaders(Map<String, String> headers) {
		if (headers != null) {
			for (Map.Entry<String, String> entry : headers.entrySet()) {
				String headerName = entry.getKey();
				String value = entry.getValue();
				setHeader(headerName, value);
			}
		}
		return this;
	}

	public boolean hasHeader(String name) {
		return this.headers.containsKey(name.toLowerCase());
	}

	public HttpHeader setHeader(String name, String value) {
		if (name == null || name.isEmpty() || value == null || value.isEmpty()) {
			return this;
		}
		this.headers.put(name.trim().toLowerCase(), value.trim());
		return this;
	}

	public String getHeader(String name) {
		return headers.get(name.toLowerCase());
	}

	public List<String> getListHeaderNames() {
		List<String> listHeaders = new ArrayList<>();
		for (Map.Entry<String, String> entry : this.headers.entrySet()) {
			String headerName = entry.getKey();
			listHeaders.add(headerName);
		}
		return listHeaders;
	}

	@Override
	public String toString() {
		return dumpHeader(this);
	}

	public static String dumpHeader(HttpHeader responseHeaders) {
		StringBuilder ret = new StringBuilder();
		List<String> listHeaderNames = responseHeaders.getListHeaderNames();
		for (String headerName : listHeaderNames) {
			String value = responseHeaders.getHeader(headerName);
			ret.append(headerName).append(": ").append(value).append("\n");
		}
		return ret.toString();
	}
}
