/*
 * Copyright (c) 2012-2018 by Zalo Group.
 * All Rights Reserved.
 */
package com.zing.zalo.zbrowser.downloader;

import java.nio.channels.SocketChannel;

/**
 *
 * @author datbt
 */
public class ZConnection {

	private static final long MAX_KEEP_ALIVE_TIME_SEC = 30;

	public final String domain;

	public final int port;

	public final SocketChannel socket;

	public final ZSSLConnection sslConnection;

	public final long lastActiveTime;

	public ZConnection(String domain, int port, SocketChannel socket, ZSSLConnection sslConnection) {
		this.domain = domain;
		this.port = port;
		this.socket = socket;
		this.sslConnection = sslConnection;
		if (this.sslConnection != null) {
			this.sslConnection.reuseConnection();
		}
		this.lastActiveTime = System.currentTimeMillis();
	}

	public boolean isExpired() {
		return (System.currentTimeMillis() - lastActiveTime) / 1000 > MAX_KEEP_ALIVE_TIME_SEC;
	}
}
