package com.zing.zalo.zbrowser.cache;

import androidx.collection.LruCache;

import java.util.Map;

public class MemoryLruCache extends LruCache<String, CacheItem> {

    private final Map<Integer, MemoryLruCache> mapKeyToCache;

    public MemoryLruCache(int maxSize, Map<Integer, MemoryLruCache> mapKeyToCache) {
        super(maxSize);
        this.mapKeyToCache = mapKeyToCache;
    }

    @Override
    protected int sizeOf(String key, CacheItem value) {
        return value.data.length;
    }

    @Override
    protected void entryRemoved(boolean evicted, String key, CacheItem oldValue, CacheItem newValue) {
        if (mapKeyToCache != null) {
            mapKeyToCache.remove(key.hashCode());
        }
    }

    public CacheItem _put(String key, CacheItem value) {
        if (mapKeyToCache != null) {
            mapKeyToCache.put(key.hashCode(), this);
        }
        return put(key, value);
    }

    public long getSize() {
        Map<String, CacheItem> snapshot = this.snapshot();
        long size = 0;
        for (Map.Entry<String, CacheItem> entry : snapshot.entrySet()) {
            CacheItem value = entry.getValue();
            if (value != null && value.data != null) {
                size += value.data.length;
            }
        }
        return size;
    }


}