/*
 * Copyright (c) 2012-2018 by Zalo Group.
 * All Rights Reserved.
 */
package com.zing.zalo.zbrowser.downloader;

import java.net.MalformedURLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 *
 * @author datbt
 */
public class HttpUrl {
	
	private static final Pattern HTTP_URL_PATTERN = Pattern.compile("(http[s]?)://([^/\\s:]+)(:(\\d+))?(/[^\\s#]*)?(#[^\\s]*)?");
	
	public static final String SCHEME_HTTP = "http";
	
	public static final String SCHEME_HTTPS = "https";
	
	public static final int PORT_HTTP_DEFAULT = 80;
	
	public static final int PORT_HTTPS_DEFAULT = 443;
	
	public final String fullUrl;
	
	public final String scheme;
	
	public final String domain;
	
	public final int port;
	
	public final String uri;
	
	public final String hash;

	private HttpUrl(String fullUrl, String scheme, String domain, int port, String uri, String hash) {
		this.fullUrl = fullUrl;
		this.scheme = scheme;
		this.domain = domain;
		this.port = port;
		this.uri = uri;
		this.hash = hash;
	}
	
	public static HttpUrl parseUrl(String url) throws MalformedURLException {
		Matcher urlMatcher = HTTP_URL_PATTERN.matcher(url);
		if (!urlMatcher.find()) {
			throw new MalformedURLException("Invalid http url: " + url);
		}
		String scheme = urlMatcher.group(1);
		String domain = urlMatcher.group(2);
		String portStr = urlMatcher.group(4);
		String uri = urlMatcher.group(5);
		String hash = urlMatcher.group(6);
		int port;
		if (portStr == null) {
			port = SCHEME_HTTP.equals(scheme) ? PORT_HTTP_DEFAULT : PORT_HTTPS_DEFAULT;
		} else {
			port = Integer.parseInt(portStr);
		}
		if (uri == null) {
			uri = "/";
		}
		return new HttpUrl(url, scheme, domain, port, uri, hash);
	}
}
