package com.zing.zalo.zbrowser.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import androidx.annotation.NonNull;

import com.zing.zalo.zbrowser.cache.ConfigCache;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ZBrowserUtil {


    public static String buildUrlWithTrackingParam(@NonNull String request, @NonNull String rawUrl, int srcTypeCode) {
        try {
            String url = request;
            Pattern pattern = Pattern.compile("broadcastId=[A-Za-z0-9]+");
            Matcher matcher = pattern.matcher(rawUrl);

            String srcType = "zarsrc=" + (srcTypeCode < 0 ? 1303 : srcTypeCode);
            if (url.contains("utm_source=") && url.contains("utm_medium=") && url.contains("utm_campaign=")) {
                if (url.contains("zarsrc")) {
                    url = url.replaceAll("zarsrc=\\d+", srcType);
                } else {
                    url += "&" + srcType;
                }
                return url;
            }
            if (url.contains("?")) {
                url += "&utm_source=zalo&utm_medium=zalo&utm_campaign=zalo";
            } else {
                url += "?utm_source=zalo&utm_medium=zalo&utm_campaign=zalo";
            }
            if(!url.contains("broadcastId") && matcher.find()){
                url += "&" + matcher.group(0);
            }
            if (url.contains("zarsrc")) {
                url = url.replaceAll("zarsrc=\\d+", srcType);
            } else {
                url += "&" + srcType;
            }
            return url;
        } catch (Exception e) {

        }
        return request;
    }

    public static String removeTrackingParam(String url, ConfigCache configCache) {
        if(configCache != null && configCache.checkWhiteList(url)){
            int paramIndex = url.indexOf('?');
            if(paramIndex > 0){
                url = url.substring(0, paramIndex);
            }
        }else {
            url = url.replaceAll("&?utm_source=[^&]+", "");
            url = url.replaceAll("&?utm_medium=[^&]+", "");
            url = url.replaceAll("&?utm_campaign=[^&]+", "");
            url = url.replaceAll("&?zarsrc=\\d+", "");
            url = url.replaceAll("&?broadcastId=[^&]+", "");
            url = url.replaceAll("&?zl3rd=[^&]+", "");
            url = url.replaceAll("\\?&", "?");
            url = url.replaceAll("\\?$", "");
        }
        return url;
    }

    /**
     * Get the network info
     * @param context
     * @return
     */
    public static NetworkInfo getNetworkInfo(Context context){
        ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        return cm.getActiveNetworkInfo();
    }

    /**
     * Check if there is any connectivity to a Wifi network
     * @param context
     * @return
     */
    public static boolean isConnectedWifi(Context context){
        try {
            NetworkInfo info = getNetworkInfo(context);
            return (info != null && info.isConnected() && info.getType() == ConnectivityManager.TYPE_WIFI);
        } catch (Exception e) {
            return false;
        }
    }
}
