package com.zing.zalo.zbrowser.cache;

import java.nio.ByteBuffer;

public class CacheItem {

    public int expireTime;

    public String mimeType;

    public byte[] data;

    public String etag;

    public CacheItem(int expireTime, String mimeType, byte[] data, String etag) {
        this.expireTime = expireTime;
        this.mimeType = mimeType;
        this.data = data;
        this.etag = etag;
    }

    public ByteBuffer serialize() {
        byte[] mimeTypeRaw = mimeType.getBytes();
        int mimeTypeSize = mimeTypeRaw.length;
        byte[] etagRaw = etag.getBytes();
        int etagSize = etagRaw.length;
        ByteBuffer buffer = ByteBuffer.allocate(/*expire time*/Integer.BYTES + /*mimetype size*/ Integer.BYTES + mimeTypeRaw.length + /*etag size*/ Integer.BYTES + etagRaw.length + data.length);
        buffer.putInt(expireTime);
        buffer.putInt(mimeTypeSize);
        buffer.put(mimeTypeRaw);
        buffer.putInt(etagSize);
        buffer.put(etagRaw);
        buffer.put(data);

        buffer.rewind();

        return buffer;
    }

    public static CacheItem deserialize(ByteBuffer data) {
        try {
            data.rewind();
            int expireTime = data.getInt();
            int mimeTypeSize = data.getInt();
            byte[] mimeTypeRaw = new byte[mimeTypeSize];
            data.get(mimeTypeRaw);
            int etagSize = data.getInt();
            byte[] etagRaw = new byte[etagSize];
            data.get(etagRaw);
            byte[] cachedData = new byte[data.remaining()];
            data.get(cachedData);
            return new CacheItem(expireTime, new String(mimeTypeRaw), cachedData, new String(etagRaw));
        } catch (Exception e) {
            //error while deserialize
            e.printStackTrace();
            return null;
        }
    }
}
