package com.zing.zalo.zalosdk.beaconsdk;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;

import com.zing.zalo.zalosdk.beaconsdk.models.BeaconEvent;
import com.zing.zalo.zalosdk.beaconsdk.models.ZBeacon;
import com.zing.zalo.zalosdk.beaconsdk.util.AndroidVersionUtils;
import com.zing.zalo.zalosdk.beaconsdk.util.LogHelper;
import com.zing.zalo.zalosdk.beaconsdk.util.Util;

import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconConsumer;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.RangeNotifier;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.SDKNotifier;
import org.altbeacon.beacon.service.RangedBeacon;
import org.altbeacon.beacon.service.ScanJobScheduler;
import org.altbeacon.beacon.startup.BootstrapNotifier;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import static com.zing.zalo.zalosdk.beaconsdk.Constant.ERROR_BEACON_LIST_EMPTY;
import static com.zing.zalo.zalosdk.beaconsdk.Constant.ERROR_BEACON_LIST_EMPTY_MSG;
import static com.zing.zalo.zalosdk.beaconsdk.models.ZBeacon.NOT_SET;
import static com.zing.zalo.zalosdk.beaconsdk.util.Util.getKeyBeaconOrRegion;

public class BeaconSDKImp implements IBeaconSDK {

  private static final String TAG = "ZSDKBEACON";

  private static final int MSG_SET_LIST_MONITOR = 1;
  private static final int MSG_SET_LIST_RANGING = 2;
  private static final int MSG_BEACON_SERVICE_CONNECTED = 3;
  private static final int MSG_START_SCAN = 4;
  private static final int MSG_STOP_SCAN = 5;

  private static final int MSG_ADD_MONITOR = 6;
  private static final int MSG_ADD_RANGING = 7;
  private static final int MSG_STOP_MONITOR = 8;
  private static final int MSG_STOP_RANGING = 9;
  private static final int MSG_UPDATE_SCAN_PERIOD = 10;

  private final String SCAN_SOURCE_H5 = "H5";
  private final String SCAN_SOURCE_2055 = "cmd_2055";
  protected static volatile IBeaconSDK sInstance = null;
  /**
   * Private lock object for singleton initialization protecting against denial-of-service attack.
   */
  private static final Object SINGLETON_LOCK = new Object();

  private BeaconManager beaconManager;
  private final Map<String, ZBeacon> monitorMapBeacons;
  private final Map<String, ZBeacon> rangingMapBeacons;
  private final Map<String, ZBeacon> availableMapBeacons;
  private final List<BeaconEvent> queueEvent;

  private ZBeacon noFilterBeacon = new ZBeacon("", "", NOT_SET, NOT_SET);
  private Context context;

  private boolean isScanning = false;
  private boolean isUserWantScanning = false;
  private boolean isRequireFilter = true;
  private boolean isAppForeground = true;

  private IBeaconNotifier notifier;
  private IBeaconNotifier internalNotifier = new IBeaconNotifier() {
    @Override
    public void onBeaconConnected(ZBeacon beacon) {
      if (notifier != null) {
        if (LogHelper.DEBUG) {
          LogHelper.d(TAG, "Connected: " + beacon);
        }
        notifier.onBeaconConnected(beacon);
      }
    }

    @Override
    public void onBeaconDisconnected(ZBeacon beacon) {
      if (notifier != null) {
        if (LogHelper.DEBUG) {
          LogHelper.d(TAG, "Disconnected: " + beacon);
        }
        notifier.onBeaconDisconnected(beacon);
      }
    }

    @Override
    public void onRangeBeacons(List<ZBeacon> foundBeacons) {
      if (notifier != null) {
        notifier.onRangeBeacons(foundBeacons);
      }
    }

    @Override
    public void onBeaconPushEvents(List<ZBeacon> beacons) {
      if (notifier != null) {
        notifier.onBeaconPushEvents(beacons);
      }
    }

    @Override
    public void onError(int code, String msg) {
      if (notifier != null) {
        notifier.onError(code, msg);
      }
    }
  };
  private ServiceHandler handler;
//  private RegionBootstrap regionBootstrap;
//  private boolean serviceConnected = false;
  private BeaconConsumer beaconConsumer;
  private BootstrapNotifier bootstrapNotifier;
  private RangeNotifier rangeNotifier;
  private SDKNotifier sdkNotifier;
//  private boolean isBackgroundMode = false;
  private boolean isForegroundService = false;
  private HandlerThread thread;
  private BluetoothAdapter bluetoothAdapter;

  private ScheduledExecutorService scheduledExeService;
  ScheduledFuture<?> scheduledBeaconCheckTimeOut;
  ScheduledFuture<?> scheduledDelayCheckTimeOut;
  private AtomicBoolean isDelayCheckTimeOutRunning = new AtomicBoolean(false);
  private AtomicBoolean isBeaconCheckTimeOutRunning = new AtomicBoolean(false);

//  private Runnable timerTick;
  private Runnable delayCheckBeaconConnectTimeout;
  private static final int DEFAULT_FOREGROUND_SCAN_PERIOD = 5000;
  private static final int DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD = 10000;
  private static final int DEFAULT_BEACON_TIME_OUT_INTERVAL = 50000;
  private static final int DEFAULT_BEACON_CONNECTED_TIME_OUT = 600000;
  private static final int DEFAULT_DELAY_CHECK_CONNECTED_TIMEOUT = 5000;
  /**
   * the duration in milliseconds of each Bluetooth LE scan cycle to look for beacons.
   */
  private int foregroundScanPeriod = DEFAULT_FOREGROUND_SCAN_PERIOD;

  /**
   * the duration in milliseconds between each Bluetooth LE scan cycle to look for beacons.
   */
  private int foregroundBetweenScanPeriod = DEFAULT_FOREGROUND_BETWEEN_SCAN_PERIOD;

  /**
   * the duration in milliseconds between each Beacon status check to determine enter/exit state.
   */
  private int beaconTimeoutInterval = DEFAULT_BEACON_TIME_OUT_INTERVAL;

  private int beaconConnectedTimeout = DEFAULT_BEACON_CONNECTED_TIME_OUT;

  private int delayCheckConnectedTimeout = DEFAULT_DELAY_CHECK_CONNECTED_TIMEOUT;

  private String scan_from_source = "";
  private SharedPreferences sharedPreferences;


  public static IBeaconSDK getInstance(Context context) {

    IBeaconSDK instance = sInstance;
    if (instance == null) {
      synchronized (SINGLETON_LOCK) {
        instance = sInstance;
        if (instance == null) {
          sInstance = instance = new BeaconSDKImp(context);
        }
      }
    }
    return instance;
  }

  private BeaconSDKImp(Context context) {

    this.context = context.getApplicationContext();
    this.sharedPreferences = context.getSharedPreferences(TAG, Context.MODE_PRIVATE);
    this.beaconManager = BeaconManager.getInstanceForApplication(context);
    this.monitorMapBeacons = new ConcurrentHashMap<>();
    this.rangingMapBeacons = new ConcurrentHashMap<>();
    this.availableMapBeacons = new ConcurrentHashMap<>();
    this.queueEvent = new CopyOnWriteArrayList<>();

    this.beaconConsumer = new InternalBeaconConsumer();
    this.bootstrapNotifier = new InternalBootstrapNotifier();
    this.rangeNotifier = new InternalRangeNotifier();
    this.sdkNotifier = new InternalSDKNotifier();
//    beaconManager.getBeaconParsers().add(new BeaconParser().setBeaconLayout("m:2-3=0215,i:4-19,i:20-21,i:22-23,p:24-24"));
//    beaconManager.setDebug(true);
    LogHelper.DEBUG = false;
    beaconManager.setRegionStatePersistenceEnabled(false);
    synchronized (this) {
      if (thread == null) {
        thread = new HandlerThread("ZBeacon thread");
        thread.start();
      }
    }

    handler = new ServiceHandler(thread.getLooper());

    //Bluetooth
    bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
    IntentFilter filter = new IntentFilter(BluetoothAdapter.ACTION_STATE_CHANGED);
    context.registerReceiver(bluetoothReceiver, filter);

    delayCheckBeaconConnectTimeout = this::clearBeaconsConnectedTimeout;

//    timerTick = () -> {
//      try {
//        if (!isAppForeground) {
//          isBeaconCheckTimeOutRunning.set(false);
//          return;
//        }
//
//        if (isScanning) {
//          List<ZBeacon> results = new ArrayList<>();
//
//          try {
//            long minDuration = Long.MAX_VALUE;
//            for (Map.Entry<String, ZBeacon> stringBeaconEntry : availableMapBeacons.entrySet()) {
//              String key = stringBeaconEntry.getKey();
//              ZBeacon beacon = stringBeaconEntry.getValue();
//              long duration = beacon.getLastSeen() + beaconTimeoutInterval - System.currentTimeMillis();
//              if (duration > 0 && duration < minDuration) {
//                minDuration = duration;
//              }
//              if (System.currentTimeMillis() - beacon.getLastSeen() >= beaconTimeoutInterval) {
//
//                rangingMapBeacons.remove(key);
//                availableMapBeacons.remove(key);
//
//                beacon.setConnected(false);
//                results.add(beacon);
//
//                removeBeaconState(beacon);
//              }
//
//            }
//
//            if (minDuration != Long.MAX_VALUE) {
//              LogHelper.d(TAG, "timerTick schedule next time in:"+minDuration + "ms");
//              scheduledBeaconCheckTimeOut = scheduledExeService
//                  .schedule(timerTick,
//                      minDuration, TimeUnit.MILLISECONDS);
//            } else {
//              isBeaconCheckTimeOutRunning.set(false);
//            }
//
//          } catch (Exception e1) {
//            e1.printStackTrace();
//          }
//
//          if (results.isEmpty()) {
//            LogHelper.d(TAG, "timerTick no timeOut beacons");
//            return;
//          }
//
//          if (scan_from_source.equals(SCAN_SOURCE_H5)) {
//            LogHelper.d(TAG, "timerTick don't callback for H5 source");
//            return;
//          }
//
//          boolean isNetworkConnected = Util.isNetworkAvailable(this.context);
//          if (isNetworkConnected) {
//            submitQueueEvent();
//          }
//
//          for (ZBeacon beacon :
//              results) {
//            BeaconEvent beaconEvent = new BeaconEvent(beacon.getLastSeen(), beacon, 22);
//            LogHelper.d(TAG, "timerTick EXIT_REGION "
//                + beacon.getUUID() + ";" + beacon.getMajor() + ";" + beacon.getMinor());
//            if (isNetworkConnected) {
//              mappingNewBeaconDisconnected(beaconEvent);
//            } else {
//              addEventQueue(beaconEvent);
//            }
//
//          }
//
//        }
//      } catch (Exception e) {
//        e.printStackTrace();
//      }
//
//    };
  }

  private void addEventQueue(BeaconEvent beaconEvent) {
    if (queueEvent.size() > 500) {
      queueEvent.clear();
    }
    if (LogHelper.DEBUG) {
      LogHelper.d(TAG, "Thêm queue event: " + beaconEvent.getBeacon());
    }
    queueEvent.add(beaconEvent);
  }

  private void mappingNewBeaconConnected(BeaconEvent beaconEvent) {
    if (internalNotifier != null) {
      internalNotifier.onBeaconConnected(new ZBeacon(beaconEvent));
    }
  }

  private void mappingNewBeaconDisconnected(BeaconEvent beaconEvent) {
    if (internalNotifier != null) {
      internalNotifier.onBeaconDisconnected(new ZBeacon(beaconEvent));
    }
  }

  private void mappingPushEvents(List<ZBeacon> beaconList) {
    if (internalNotifier != null) {
      internalNotifier.onBeaconPushEvents(beaconList);
    }
  }

  private void submitQueueEvent() {
    if (queueEvent.isEmpty()) {
      return;
    }
    Iterator<BeaconEvent> iterator = queueEvent.iterator();
    List<ZBeacon> zBeacons = new ArrayList<>();
    while (iterator.hasNext()) {
      BeaconEvent beaconEvent = iterator.next();
      zBeacons.add(new ZBeacon(beaconEvent));
    }
    if (!zBeacons.isEmpty()) {
      LogHelper.d(TAG, "submitQueueEvent");
      mappingPushEvents(zBeacons);
    }

    queueEvent.clear();
  }

  private void removeBeaconState(ZBeacon beacon) {
    if (beacon != null) {
      String key = getKeyBeaconOrRegion(beacon);
      sharedPreferences.edit().remove(key).apply();
    }
  }

  private void clearBeaconsConnectedTimeout() {
    try {

      List<String> deleteUUIDS = new ArrayList<>();
      Map<String, ? > allEntries = sharedPreferences.getAll();
      if (LogHelper.DEBUG) {
        LogHelper.d(TAG, "total beacons in cache: " + allEntries.size());
      }
      boolean isNetworkConnected = Util.isNetworkAvailable(this.context);
      for (Map.Entry<String, ?> entry : allEntries.entrySet()) {
        String[] data = entry.getValue().toString().split(";");
        long timeRecord = Long.parseLong(data[0]);
        double distance = data.length > 1 ? Double.parseDouble(data[1]) : 0;

        if (timeRecord + beaconConnectedTimeout < System.currentTimeMillis()) {

          deleteUUIDS.add(entry.getKey());
          String[] identifiers = entry.getKey().split(";");
          ZBeacon zBeacon = new ZBeacon(
              identifiers[0], identifiers[0],
              Integer.parseInt(identifiers[1]), Integer.parseInt(identifiers[2]));
          zBeacon.setLastSeen(timeRecord);
          zBeacon.setDistance(distance);
          if (LogHelper.DEBUG) {
            LogHelper.d(TAG, "beacon timeout: " + zBeacon);
          }
          BeaconEvent beaconEvent = new BeaconEvent(timeRecord, zBeacon, 23);
          if (!isNetworkConnected) {
            addEventQueue(beaconEvent);
          } else {
            submitQueueEvent();
            mappingNewBeaconDisconnected(beaconEvent);
          }

        } else {
          if (LogHelper.DEBUG) {
            LogHelper.d(TAG, "other beacon: " + entry.getKey());
          }
        }
      }

      SharedPreferences.Editor editor = sharedPreferences.edit();
      for (String uuid :
          deleteUUIDS) {

        String key = uuid.toUpperCase();
        rangingMapBeacons.remove(key);
        availableMapBeacons.remove(key);

        editor.remove(uuid);
      }
      editor.apply();

      isDelayCheckTimeOutRunning.set(false);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  public static void clearSessionService(Context ctx) {
    try {
      if (sInstance == null || !sInstance.isScanning()) {
        internalClearService(ctx);
      }
    } catch (Exception e) {

    }
  }

  private static void internalClearService(Context ctx) {
    try {
      LogHelper.w(TAG, "Cancelling scheduled jobs.");
      ScanJobScheduler.getInstance().cancelSchedule(ctx.getApplicationContext());
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  @Override
  public IBeaconSDK setBeaconNotifier(IBeaconNotifier notifier) {
    this.notifier = notifier;
    return this;
  }

  @Override
  public IBeaconSDK setBundleOptions(JSONObject data) {
    if (data == null || data.length() == 0) {
      LogHelper.w(TAG, "setBundleOptions empty data!!");
      return this;
    }

    JSONObject scan_config = data.optJSONObject("scan_config");
    if (scan_config != null) {
      foregroundScanPeriod = scan_config.optInt("scan_time", foregroundScanPeriod);
      foregroundBetweenScanPeriod = scan_config.optInt("time_between_scan", foregroundBetweenScanPeriod);
      beaconTimeoutInterval = scan_config.optInt("beacon_timeout", beaconTimeoutInterval);
      beaconConnectedTimeout = scan_config.optInt("beaconConnectedTimeout", beaconConnectedTimeout);
      delayCheckConnectedTimeout = scan_config.optInt("delayCheckConnectedTimeout", delayCheckConnectedTimeout);
      BeaconManager.setRegionExitPeriod(beaconTimeoutInterval);
    }

    scan_from_source = data.optString("scan_from_source");

    LogHelper.d(TAG, "setBundleOptions ScanPeriod:" + foregroundScanPeriod
        + " BetweenScanPeriod:" +foregroundBetweenScanPeriod
        + " beaconTimeoutInterval:" + beaconTimeoutInterval
        + " beaconConnectedTimeout:" +beaconConnectedTimeout
        + " delayCheckConectedTimeout:" + delayCheckConnectedTimeout
        + " scan_from_source:"+scan_from_source);


    handler.obtainMessage(MSG_UPDATE_SCAN_PERIOD).sendToTarget();
    return this;
  }

  BroadcastReceiver bluetoothReceiver = new BroadcastReceiver() {
    @Override
    public void onReceive(Context context, Intent intent) {
      String action = intent.getAction();

      if (BluetoothAdapter.ACTION_STATE_CHANGED.equals(action)) {
        int state = getStateFromAdapterState(
            intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, BluetoothAdapter.ERROR));

        if (state == Constant.BLUETOOTH_STATE_OFF) {
          LogHelper.d(TAG, "BroadcastReceiver BT OFF");
          internalNotifier.onError(state, Constant.ERROR_BLUETOOTH_OFF_MSG);
          LogHelper.w(TAG, "Bluetooth Off!. Please check error code + message from IBeaconNotifier");

        } else if (state == Constant.BLUETOOTH_STATE_ON) {
          LogHelper.d(TAG, "BroadcastReceiver BT ON , isUserWantScanning(" + isUserWantScanning+ ")");

        }
      }
    }
  };

  private int getStateFromAdapterState(int state) {

    int result = Constant.BLUETOOTH_STATE_OFF;
    switch (state) {
      case BluetoothAdapter.STATE_OFF :
        result = Constant.BLUETOOTH_STATE_OFF;
        break;
      case BluetoothAdapter.STATE_TURNING_OFF :
        result = Constant.BLUETOOTH_STATE_TURNING_OFF;
        break;
      case BluetoothAdapter.STATE_ON :
        result = Constant.BLUETOOTH_STATE_ON;
        break;
      case BluetoothAdapter.STATE_TURNING_ON :
        result = Constant.BLUETOOTH_STATE_TURNING_ON;
        break;
    }
    return result;
  }

  private Region genRegion(ZBeacon beacon) {
    String uuid = beacon.getUUID();
    int major = beacon.getMajor();
    int minor = beacon.getMinor();

    Identifier id1 = TextUtils.isEmpty(uuid) ? null : Identifier.parse(uuid);
    Identifier id2 = major == NOT_SET ? null : Identifier.fromInt(major);
    Identifier id3 = minor == NOT_SET ? null : Identifier.fromInt(minor);
    return new Region(uuid + ";" + major + ";" +minor, id1, id2, id3);
  }

  @Override
  protected void finalize() throws Throwable {
    try {
      if (thread != null) {
        if (AndroidVersionUtils.isJellyBeanMR2AndAbove()) {
          thread.quitSafely();
        } else {
          thread.quit();
        }

        thread = null;
        notifier = null;

        if (context != null) {
          context.unregisterReceiver(bluetoothReceiver);
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      super.finalize();
    }
  }

  @Override
  public void setAppState(boolean foreground) {
    this.isAppForeground = foreground;
    LogHelper.w(TAG, "setAppState " + foreground);
    if (foreground && isScanning) {
      verifyScheduledExeService();
    }
  }

  @Override
  public boolean isScanning() {
    return isScanning;
  }

  List<ZBeacon> currentBeacons;
  @Override
  public void setListBeacons(List<ZBeacon> beacons) {
    if (beacons != null) {
      if (!beacons.isEmpty()) {
        isRequireFilter = true;
        if (!beacons.equals(currentBeacons)) {
          currentBeacons = new ArrayList<>(beacons);

          handler.obtainMessage(MSG_SET_LIST_MONITOR, beacons).sendToTarget();
        } else {
          LogHelper.d(TAG, "setListBeacons equal return");
        }
      }

    } else {
      isRequireFilter = false;
      currentBeacons = null;
      handler.obtainMessage(MSG_SET_LIST_MONITOR, null).sendToTarget();
    }

  }

  @Override
  public void startBeacons() {
    this.isRequireFilter = currentBeacons != null;
    this.isUserWantScanning = true;
    startScan();
  }

  @Override
  public void stopBeacons() {
    this.isUserWantScanning = false;
    stopScan();
  }

  @Override
  public void scanAll() {
    this.isRequireFilter = false;
    this.isUserWantScanning = true;
    startScan();
  }

  @Override
  public List<ZBeacon> getAvailableBeacons() {
    List<ZBeacon> zBeacons = new ArrayList<>();
    try {
      if (!availableMapBeacons.isEmpty()) {

        for (Map.Entry<String, ZBeacon> entry : availableMapBeacons.entrySet()) {
          ZBeacon beacon = entry.getValue();
          if (beacon.getLastSeen() > 0 && System.currentTimeMillis() - beacon.getLastSeen() < beaconTimeoutInterval) {
            if (LogHelper.DEBUG) {
              LogHelper.d(TAG, "available id: " + beacon);
            }
            zBeacons.add(beacon);
          } else {
            if (LogHelper.DEBUG) {
              LogHelper.d(TAG, "miss: " + beacon);
            }

          }
        }

      }
    } catch (Exception e) {
//      e.printStackTrace();
    }
    return zBeacons;
  }

  private int checkBluetooth() {
    int result = 0;
    if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) {
      result = Constant.ERROR_BLUETOOTH_OFF;
      internalNotifier.onError(result, Constant.ERROR_BLUETOOTH_OFF_MSG);
    }

    return result;
  }

  private void startScan() {
    try{
    boolean shouldReturn = false;
    if (checkPermission() != 0) {
      LogHelper.w(TAG, "check Permission FAILED!. Please check error code + message from IBeaconNotifier");
      shouldReturn = true;
    }
    if (checkBluetooth() != 0) {
      LogHelper.w(TAG, "Bluetooth Off!. Please check error code + message from IBeaconNotifier");
      shouldReturn = true;
    }

    if (isScanning) {
      LogHelper.w(TAG, "_startScan Already start !!");
      return;
    }

    isScanning = true;
    if (shouldReturn) {
      isScanning = false;
      notifyBeaconTimeOut();
      return;
    }}catch (Exception e) {}
    handler.obtainMessage(MSG_START_SCAN).sendToTarget();
  }

  private void stopScan() {
    if (!isScanning) {
      return;
    }
    isScanning = false;

    handler.obtainMessage(MSG_STOP_SCAN).sendToTarget();
  }

  private void unbindBeaconInternal() {
    try {
      beaconManager.setSdkNotifier(null);
      beaconManager.removeAllRangeNotifiers();
      beaconManager.removeAllMonitorNotifiers();
      try {
        beaconManager.stopAllRangingBeaconsInRegion();
        beaconManager.stopAllMonitoringBeaconsInRegion();
      } catch (RemoteException e) {
        e.printStackTrace();
      }
        beaconManager.unbind(beaconConsumer);
        LogHelper.d(TAG, "_stopScan beaconManager unbind");

    } catch (Exception e) {

    }
  }

  private int checkPermission() {

    int result = 0;
    String msg = "";
    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
      if (!isPermissionGranted(Manifest.permission.BLUETOOTH_SCAN)) {
        result = Constant.ERROR_BLUETOOTH_SCAN_DENIED;
        msg = Constant.ERROR_BLUETOOTH_SCAN_DENIED_MSG;
      }
    }

    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
      if (!isPermissionGranted(Manifest.permission.ACCESS_COARSE_LOCATION)) {
        result = Constant.ERROR_ACCESS_COARSE_LOCATION_DENIED;
        msg = Constant.ERROR_ACCESS_COARSE_LOCATION_DENIED_MSG;
      }
      if (!isPermissionGranted(Manifest.permission.ACCESS_FINE_LOCATION)) {
        result = Constant.ERROR_ACCESS_FINE_LOCATION_DENIED;
        msg = Constant.ERROR_ACCESS_FINE_LOCATION_DENIED_MSG;
      }
    }

    if (result != 0) {
      internalNotifier.onError(result, msg);
    }

    return result;
  }

  private boolean isPermissionGranted(String permission) {
    return context != null && context.checkCallingOrSelfPermission(permission) == PackageManager.PERMISSION_GRANTED;
  }

  private final class InternalSDKNotifier implements SDKNotifier{
    @Override
    public void onException() {
      try {
        if (LogHelper.DEBUG) {
          LogHelper.w(TAG, "Exc happen");
        }
        stopScan();
      } catch (Exception e) {

      }
    }
  }

  private final class InternalRangeNotifier implements RangeNotifier{

    @Override
    public void didRangeBeaconsInRegion(Collection<Beacon> collection, Region region) {
      try {
      if (collection == null || collection.isEmpty()) {
        LogHelper.d(TAG, "collection empty return!!");
        return;
      }

      List<ZBeacon> beaconList = new ArrayList<>();
      for (Beacon beacon : collection) {
        if (beacon != null) {

          String key = getKeyBeaconOrRegion(beacon);
          ZBeacon o = rangingMapBeacons.get(key);
          if (o == null) {
            o = new ZBeacon(beacon.getId1().toString(),
                beacon.getId1().toString(),
                beacon.getId2() != null ? beacon.getId2().toInt() : 0,
                beacon.getId3() != null ? beacon.getId3().toInt() : 0);
          }
          o.setMajor(beacon.getId2() != null ? beacon.getId2().toInt() : 0);
          o.setMinor(beacon.getId3() != null ? beacon.getId3().toInt() : 0);
          o.setDistance(beacon.getDistance());
          o.setLastSeen(System.currentTimeMillis());
          o.setRssi(beacon.getRssi());
          o.setTxPower(beacon.getTxPower());

          String id = getKeyBeaconOrRegion(o);
          maybeNotifyBeaconConnected(id, o, true);

//          if (LogHelper.DEBUG) {
//            LogHelper.d(TAG, "didRangeBeaconsInRegion beacon: " + o);
//          }

          rangingMapBeacons.put(key, o);
          availableMapBeacons.put(key, o);

          beaconList.add(o);
        } else {
          LogHelper.d(TAG, "didRangeBeaconsInRegion beacon NUll");
        }
      }

      if (!beaconList.isEmpty()  && !scan_from_source.equals(SCAN_SOURCE_H5)) {
        if (Util.isNetworkAvailable(context)) {
          internalNotifier.onRangeBeacons(beaconList);
        }
      }

//      if (!isBeaconCheckTimeOutRunning.get()) {
//        isBeaconCheckTimeOutRunning.set(true);
//        LogHelper.w(TAG, "init timerTick");
//        scheduledBeaconCheckTimeOut = scheduledExeService
//            .schedule(timerTick,
//                beaconTimeoutInterval, TimeUnit.MILLISECONDS);
//      }
    } catch (Exception e) {}
    }
  }

  private void maybeNotifyBeaconConnected(String id, ZBeacon beacon, boolean fromRanging) {
    try{
    String[] data = sharedPreferences.getString(id, "-1;0").split(";");
    long time = Long.parseLong(data[0]);
    double oldDistance = data.length > 1 ? Double.parseDouble(data[1]) : 0;

    ZBeacon oldBeacon;
    double epsilon = 0.000001d;
    if (oldDistance < epsilon) { //== 0
      oldBeacon = beacon;
    } else {
      oldBeacon = new ZBeacon(beacon);
      oldBeacon.setDistance(oldDistance);
    }

    boolean notify = true;
    int state = 0;
    if (time == -1) {
      state = fromRanging ? 12 : 11;
      LogHelper.d(TAG, "new connect event " + state );
    } else if (time + beaconConnectedTimeout > System.currentTimeMillis()){
      notify = false;
//      if (LogHelper.DEBUG) {
//        LogHelper.d(TAG, "enter chua du timeout ko noti");
//      }
    } else {
      state = 13;
      LogHelper.d(TAG, "timeout connect event " + state);
    }

    if (!scan_from_source.equals(SCAN_SOURCE_H5)) {
      String v = beacon.getLastSeen() + ";" + beacon.getDistance();
      if (LogHelper.DEBUG) {
        LogHelper.d(TAG, "id: " +  id + " value:" + v + " rssi:"  + beacon.getRssi() +  " txpower:" + beacon.getTxPower());
      }
      sharedPreferences.edit().putString(id, v).apply();
    } else {
      LogHelper.d(TAG, "ko noti qua H5");
      notify = false;
    }
    boolean isNetworkAvailable = Util.isNetworkAvailable(this.context);
    if (isNetworkAvailable) {
//      if (LogHelper.DEBUG) {
//        LogHelper.d(TAG, "Có network: " + state);
//      }

      submitQueueEvent();
    } else {
//      if (LogHelper.DEBUG) {
//        LogHelper.d(TAG, "Không có network state: " + state);
//      }

      if (state != 0) {
        if (state == 13) {
          addEventQueue(new BeaconEvent(time, oldBeacon, 24));
        }
        addEventQueue(new BeaconEvent(beacon.getLastSeen(), beacon, state));
        notify = false;
      }
    }

    if (notify) {
      beacon.setConnected(true);
      LogHelper.d(TAG, "notify state: " + state);
      final BeaconEvent eventDispatch = new BeaconEvent(beacon.getLastSeen(), beacon, state);
      if (state == 13) {
        mappingNewBeaconDisconnected(new BeaconEvent(time, oldBeacon, 24));

        handler.postDelayed(()
                -> mappingNewBeaconConnected(eventDispatch),
            2000);
      } else {
        mappingNewBeaconConnected(eventDispatch);
      }
    }}catch (Exception e) {}
  }

  private boolean isBeaconConnected(int state) {
    return state > 10 && state < 20;
  }

  private final class InternalBootstrapNotifier implements BootstrapNotifier {

    @Override
    public Context getApplicationContext() {
      return context;
    }

    @Override
    public void didEnterRegion(Region region) {
      try{
      if (region == null) return;

        if (LogHelper.DEBUG) {
          LogHelper.d(TAG, "didEnterRegion " + region);
        }

      String key = getKeyBeaconOrRegion(region);
      ZBeacon beacon = rangingMapBeacons.get(key);
      if (beacon == null) {
        beacon = new ZBeacon(region.getUniqueId(),
            region.getId1() == null ? "null" : region.getId1().toString(),
            region.getId2() == null ? 0: region.getId2().toInt(),
            region.getId3() == null ? 0: region.getId3().toInt());
      }

      String id = getKeyBeaconOrRegion(beacon);
      beacon.setLastSeen(System.currentTimeMillis());
      beacon.setDistance(region.getDistance());
      maybeNotifyBeaconConnected(id, beacon, false);

        if (LogHelper.DEBUG) {
          LogHelper.d(TAG, "put availableMapBeacons " + beacon);
        }
      rangingMapBeacons.put(key, beacon);
      availableMapBeacons.put(key, beacon);

      if (!scan_from_source.equals(SCAN_SOURCE_H5)) {
        if (Util.isNetworkAvailable(context)) {
          List<ZBeacon> beaconList = new ArrayList<>();
          beaconList.add(beacon);
          internalNotifier.onRangeBeacons(beaconList);
        }
      }
//      if (!isBeaconCheckTimeOutRunning.get()) {
//        isBeaconCheckTimeOutRunning.set(true);
//        LogHelper.d(TAG, "init timerTick");
//        scheduledBeaconCheckTimeOut = scheduledExeService
//            .schedule(timerTick,
//                beaconTimeoutInterval, TimeUnit.MILLISECONDS);
//      }
      }catch (Exception e){}
    }

    @Override
    public void didExitRegion(Region region) {
    }

    @Override
    public void didDetermineStateForRegion(int i, Region region) {

    }
  }

  private void notifyBeaconTimeOut() {
    try {
      if (isDelayCheckTimeOutRunning.get()) {
        if (handler != null) {
          handler.removeCallbacks(delayCheckBeaconConnectTimeout);
        }
      }

      availableMapBeacons.clear();

      if (!scan_from_source.equals(SCAN_SOURCE_H5)) {
        isDelayCheckTimeOutRunning.set(true);
        if (handler != null) {
          handler.postDelayed(delayCheckBeaconConnectTimeout, delayCheckConnectedTimeout);
        }
      } else {
        sharedPreferences.edit().clear().apply();
      }
    } catch (Exception e) {

    }
  }

  private void verifyScheduledExeService() {
    try {
    synchronized (this) {
      if (scheduledExeService == null) {
        scheduledExeService = Executors.newSingleThreadScheduledExecutor();
      }
    }

    if (isDelayCheckTimeOutRunning.get()) {
      scheduledDelayCheckTimeOut.cancel(true);
    }

    availableMapBeacons.clear();

    if (!scan_from_source.equals(SCAN_SOURCE_H5)) {
      isDelayCheckTimeOutRunning.set(true);
      scheduledDelayCheckTimeOut = scheduledExeService.schedule(delayCheckBeaconConnectTimeout,
          delayCheckConnectedTimeout, TimeUnit.MILLISECONDS);
    } else {
      sharedPreferences.edit().clear().apply();
    }
    } catch (Exception e) {}
  }

  private final class InternalBeaconConsumer implements BeaconConsumer {

    private Intent serviceIntent;

    /**
     * Method reserved for system use
     */
    @Override
    public void onBeaconServiceConnect() {
      LogHelper.d(TAG, "InternalBeaconConsumer onBeaconServiceConnect");
      handler.obtainMessage(MSG_BEACON_SERVICE_CONNECTED).sendToTarget();
    }

    @Override
    public boolean bindService(Intent intent, ServiceConnection conn, int arg2) {
      if (context == null) return false;

      LogHelper.d(TAG, "InternalBeaconConsumer bindService");
      this.serviceIntent = intent;
      context.startService(intent);
      return context.bindService(intent, conn, arg2);

    }

    @Override
    public Context getApplicationContext() {
      return context;
    }

    @Override
    public void unbindService(ServiceConnection conn) {
      try{
      LogHelper.d(TAG, "InternalBeaconConsumer unbindService");
      context.unbindService(conn);
      context.stopService(serviceIntent);
      }catch (Exception e) {}
    }
  }

  private final class ServiceHandler extends Handler {
    public ServiceHandler(Looper looper) {
      super(looper);
    }


    @Override
    public void handleMessage(Message msg) {
      switch (msg.what) {
        case MSG_SET_LIST_MONITOR:
          _setListMonitorBeacons(msg);
          break;
        case MSG_BEACON_SERVICE_CONNECTED:
          _onServiceConnected();
          break;
        case MSG_START_SCAN:
          _startScan();
          break;
        case MSG_STOP_SCAN:
          _stopScan();
          break;
        case MSG_UPDATE_SCAN_PERIOD:
          _updatePeriod();
          break;
      }
    }

    private void _updatePeriod() {
      try {
        if (isScanning && beaconManager != null) {
          RangedBeacon.setSampleExpirationMilliseconds(beaconTimeoutInterval);
          beaconManager.setForegroundBetweenScanPeriod(foregroundBetweenScanPeriod);
          beaconManager.setForegroundScanPeriod(foregroundScanPeriod);
          beaconManager.updateScanPeriods();
        }

      } catch (Exception e) {
        e.printStackTrace();
      }
    }

    private void _startScan() {
      try {

        if (!beaconManager.isBound(beaconConsumer)) {
          LogHelper.d(TAG, "_startScan normal use sdk consumer");
          beaconManager.bind(beaconConsumer);
        }
        beaconManager.setBackgroundMode(false);
        RangedBeacon.setSampleExpirationMilliseconds(beaconTimeoutInterval);
        beaconManager.setForegroundBetweenScanPeriod(foregroundBetweenScanPeriod);
        beaconManager.setForegroundScanPeriod(foregroundScanPeriod);
        try {
          beaconManager.updateScanPeriods();
        } catch (Exception e) {
          e.printStackTrace();
        }

        beaconManager.addMonitorNotifier(bootstrapNotifier);
        beaconManager.addRangeNotifier(rangeNotifier);
        beaconManager.setSdkNotifier(sdkNotifier);
      } catch (Exception e) {
        stopScan();
      }
    }

    private void _stopScan() {
//      currentBeacons = null;

      internalClearService(context);
      unbindBeaconInternal();

      try {
        if (scheduledBeaconCheckTimeOut != null) {
          scheduledBeaconCheckTimeOut.cancel(true);
        }

        if (scheduledDelayCheckTimeOut != null) {
          scheduledDelayCheckTimeOut.cancel(true);
        }

        if (scheduledExeService != null && !scheduledExeService.isShutdown()) {
          scheduledExeService.shutdown();
          scheduledExeService = null;
        }

        isDelayCheckTimeOutRunning.set(false);
        isBeaconCheckTimeOutRunning.set(false);
      } catch (Exception e) {
        e.printStackTrace();
      }

      LogHelper.d(TAG, "_stopScan stop timer done");
    }

    private void _onServiceConnected() {
      LogHelper.d(TAG, "_onServiceConnected start monitor + ranging beacons");
      try {
        beaconManager.stopAllMonitoringBeaconsInRegion();
        beaconManager.stopAllRangingBeaconsInRegion();

        List<Region> monitorRegions = new ArrayList<>();
        for (Map.Entry<String, ZBeacon> entry : monitorMapBeacons.entrySet()) {
          ZBeacon beacon = entry.getValue();
          Region region = genRegion(beacon);
          if (LogHelper.DEBUG) {
            LogHelper.d(TAG, "monitor: " + beacon);
          }
          monitorRegions.add(region);
        }

        List<Region> rangingRegions = new ArrayList<>();
        for (Map.Entry<String, ZBeacon> entry : rangingMapBeacons.entrySet()) {
          ZBeacon beacon = entry.getValue();
          Region region = genRegion(beacon);
          rangingRegions.add(region);
        }
        if (isScanning) {

          if (!isRequireFilter) {
            LogHelper.d(TAG, "_onServiceConnected ko filter");
            verifyScheduledExeService();
            Region region = genRegion(noFilterBeacon);
            beaconManager.startMonitoringBeaconsInRegion(region);
            beaconManager.startRangingBeaconsInRegion(region);
          } else {
            if (rangingRegions.isEmpty() /*|| monitorRegions.isEmpty()*/) {
              internalNotifier.onError(ERROR_BEACON_LIST_EMPTY, ERROR_BEACON_LIST_EMPTY_MSG);
            } else {
              LogHelper.d(TAG, "_onServiceConnected co filter");
              _internalBeaconStartTracking(monitorRegions, rangingRegions);
            }
          }
        }

      } catch (Exception e) {
//        e.printStackTrace();
      }
    }

    private void _setListMonitorBeacons(Message msg) {
      try {
        monitorMapBeacons.clear();
        rangingMapBeacons.clear();

        List<Region> filterList = new ArrayList<>();
        List<ZBeacon> list = msg.obj == null ? new ArrayList<>() : (ArrayList<ZBeacon>) msg.obj;
        for (ZBeacon beacon : list) {
          String key = getKeyBeaconOrRegion(beacon);
          Region region = genRegion(beacon);
          filterList.add(region);
          if (LogHelper.DEBUG) {
            LogHelper.d(TAG, "_setListMonitorBeacons beacon: " + beacon);
          }
          monitorMapBeacons.put(key, beacon);
          rangingMapBeacons.put(key, beacon);
        }

        try {
          if (isScanning) {
            beaconManager.stopAllMonitoringBeaconsInRegion();
            beaconManager.stopAllRangingBeaconsInRegion();
            if (!filterList.isEmpty()) {
              _internalBeaconStartTracking(filterList, filterList);
            } else {
              LogHelper.d(TAG, "_onServiceConnected ko filter");
              verifyScheduledExeService();
              Region region = genRegion(noFilterBeacon);
              beaconManager.startMonitoringBeaconsInRegion(region);
              beaconManager.startRangingBeaconsInRegion(region);
            }

          }

        } catch (Exception e) {
          internalNotifier.onError(
              Constant.ERROR_UNKNOWN, "set whiteList add: " + e.getMessage());
          e.printStackTrace();
        }

      } catch (Exception e) {
        e.printStackTrace();
      }
    }

    private void _internalBeaconStartTracking(List<Region> monitorRegions, List<Region> rangingRegions) throws RemoteException {
      if (rangingRegions != null && !rangingRegions.isEmpty()) {
        beaconManager.startRangingBeaconsInRegion(rangingRegions);
      }
      if (monitorRegions != null && !monitorRegions.isEmpty()) {
        beaconManager.startMonitoringBeaconsInRegion(monitorRegions);
      }

      verifyScheduledExeService();
    }

  }

}
