package com.zing.zalo.zalosdk.beaconsdk;

import com.zing.zalo.zalosdk.beaconsdk.models.ZBeacon;

import java.util.List;

public interface IBeaconNotifier {

  /**
   * Call when enter beacon region
   * @param beacon
   */
  void onBeaconConnected(ZBeacon beacon);

  /**
   * Call when exit beacon region
   * @param beacon
   */
  void onBeaconDisconnected(ZBeacon beacon);

  /**
   * Called to give an estimate of the mDistance to visible beacons
   * @param foundBeacons a collection of <code>ZBeacon<code> objects that have been seen
   */
  void onRangeBeacons(List<ZBeacon> foundBeacons);

  /**
   * Called when submit multi events at a single time
   * @param beacons a collection of <code>ZBeacon<code> objects that have been seen
   */
  void onBeaconPushEvents(List<ZBeacon> beacons);

  /**
   * Callback permission + bluetooth state
   * @param code Refer in Constant class
   * @param msg Refer in Constant class
   */
  void onError(int code, String msg);
}
