package com.zing.zalo.zalosdk.beaconsdk;

import android.os.Bundle;

import com.zing.zalo.zalosdk.beaconsdk.models.ZBeacon;

import org.json.JSONObject;

import java.util.List;

public interface IBeaconSDK {

//  List<Beacon> getListMonitorBeacons();

//  List<Beacon> getListRangingBeacons();

  /**
   * When app life cycle change, call this method to notify sdk
   * @param foreground
   */
  void setAppState(boolean foreground);

  /**
   * Check beacon service is Running ?
   * @return
   */
  boolean isScanning();

  /**
   * options data pass to SDK. Key get from <code>{@link Constant}</code> (Bundle options)
   * @param data
   * @return
   */
  IBeaconSDK setBundleOptions(JSONObject data);

  /**
   * Listen callback from SDK
   * @param notifier listener events enter/exit/ranging/error
   * @return
   */
  IBeaconSDK setBeaconNotifier(IBeaconNotifier notifier);

  /**
   * Override current ranging beacons. If list beacons null or empty then equivalent to full scan.
   * @param beacons new beacons to update
   */
  void setListBeacons(List<ZBeacon> beacons);

  /**
   * Start beacons scan
   */
  void startBeacons();

  /**
   * Stop beacons scan
   */
  void stopBeacons();

  /**
   * Start beacons scan without filter uuid
   */
  void scanAll();

  List<ZBeacon> getAvailableBeacons();

  //  void stopMonitorBeacons(List<ZBeacon> beacon);

//  void stopRangingBeacon(List<Beacon> beacon);

//  void addMonitorBeacon(List<Beacon> beacon);

//  void addBeacons(List<Beacon> beacons);

//  void setListMonitorBeacons(List<Beacon> monitorBeacons);
}
