package com.zing.zalo.zalosdk.beaconsdk.models;

import androidx.annotation.NonNull;

import java.util.Objects;

public class ZBeacon {

  public final static int NOT_SET = 0;

  /**
   * UUID stands for Universally Unique Identifier.It contains 32 hexadecimal digits, split into 5 groups,
   * separated by hyphens
   */
  private String UUID;

  /**
   * Major and Minor values are numbers assigned to your iBeacons,
   * in order to identify them with greater accuracy than using UUID alone.
   */
  private int major, minor;
  /**
   * A double that is an estimate of how far the Beacon is away in meters.   Note that this number
   * fluctuates quite a bit with RSSI, so despite the name, it is not super accurate.
   */
  private double distance;

  public int getState() {
    return state;
  }


  /**
   * State for beacon. Use for connect/disconnect event
   */
  private int state = 0;

  private boolean isConnected = false;

  public boolean isConnected() {
    return isConnected;
  }

  public ZBeacon setConnected(boolean connected) {
    isConnected = connected;
    return this;
  }

  public long getLastSeen() {
    return lastSeen;
  }

  public void setLastSeen(long lastSeen) {
    this.lastSeen = lastSeen;
  }

  /**
   * The last time beacon's signal was recorded in millisecond.
   */
  private long lastSeen;

  /**
   * The measured signal strength of the Bluetooth packet that led do this Beacon detection.
   */
  protected int mRssi;
  /**
   * The calibrated measured Tx power of the Beacon in RSSI
   * This value is baked into an Beacon when it is manufactured, and
   * it is transmitted with each packet to aid in the mDistance estimate
   */
  protected int mTxPower;

  public int getRssi() {
    return mRssi;
  }

  public ZBeacon setRssi(int mRssi) {
    this.mRssi = mRssi;
    return this;
  }

  public int getTxPower() {
    return mTxPower;
  }

  public void setTxPower(int mTxPower) {
    this.mTxPower = mTxPower;
  }

  public String getBluetoothAddress() {
    return mBluetoothAddress;
  }

  public void setBluetoothAddress(String mBluetoothAddress) {
    this.mBluetoothAddress = mBluetoothAddress;
  }

  /**
   * The Bluetooth mac address
   */
  protected String mBluetoothAddress;

  public String getUUID() {
    return UUID;
  }

  public void setMajor(int major) {
    this.major = major;
  }

  public void setMinor(int minor) {
    this.minor = minor;
  }

  public int getMajor() {
    return major;
  }

  public int getMinor() {
    return minor;
  }

  public double getDistance() {
    return distance;
  }

  public void setDistance(double distance) {
    this.distance = distance;
  }

  public ZBeacon(String UUID) {
    this(UUID, UUID, NOT_SET, NOT_SET);
  }

  public ZBeacon(String name, String UUID) {
    this(name, UUID, NOT_SET, NOT_SET);
  }

  public ZBeacon(BeaconEvent beaconEvent) {
    ZBeacon zBeacon = beaconEvent.getBeacon();
    //TODO remove khi tich hop voi zalo
    this.UUID = zBeacon.getUUID();// zBeacon.getUUID() + ";" + beaconEvent.getTime() +";" + beaconEvent.getState();
    this.major = zBeacon.getMajor();
    this.minor = zBeacon.getMinor();
    this.distance = zBeacon.getDistance();
    this.mRssi = zBeacon.getRssi();
    this.lastSeen = beaconEvent.getTime();
    this.state = beaconEvent.getState();
  }

  public ZBeacon(String name, String UUID, int major, int minor) {

    this.UUID = UUID.toUpperCase();
    this.major = major;
    this.minor = minor;
  }

  public ZBeacon(ZBeacon beacon) {
    this.distance = beacon.distance;
    this.UUID = beacon.UUID;
    this.major = beacon.major;
    this.minor = beacon.minor;
    this.state = beacon.state;
    this.lastSeen = beacon.lastSeen;
    this.mBluetoothAddress = beacon.mBluetoothAddress;
    this.mRssi = beacon.mRssi;
    this.mTxPower = beacon.mTxPower;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    ZBeacon beacon = (ZBeacon) o;

    return Objects.equals(UUID, beacon.UUID);
  }

  @Override
  public int hashCode() {
    return UUID != null ? UUID.hashCode() : 0;
  }

  @NonNull
  @Override
  public String toString() {
    return "[UUID: " + UUID + "(" +major + "," + minor+") state:" + state+ " ]";
  }
}
