package com.zing.zalo.zalosdk.beaconsdk.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

import com.zing.zalo.zalosdk.beaconsdk.models.ZBeacon;

import org.altbeacon.beacon.Region;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Util {

  public static String getKeyBeaconOrRegion(Object o) {
    String id = "";
    int major = 0;
    int minor = 0;
    try {
      if (o instanceof Region) {
        Region ob = (Region) o;
        LogHelper.d("BeaconSDK" , "get Key Region: " + ob.toString());
        id    = ob.getId1() == null ? "":ob.getId1().toString();
        major = ob.getId2() == null ? 0:ob.getId2().toInt();
        minor = ob.getId3() == null ? 0:ob.getId3().toInt();
      } else if (o instanceof org.altbeacon.beacon.Beacon) {
        org.altbeacon.beacon.Beacon ob = (org.altbeacon.beacon.Beacon) o;
        id    = ob.getId1() == null ? "":ob.getId1().toString();
        major = ob.getId2() == null ? 0:ob.getId2().toInt();
        minor = ob.getId3() == null ? 0:ob.getId3().toInt();
      } else if (o instanceof ZBeacon) {
        ZBeacon ob = (ZBeacon) o;
        id = ob.getUUID();
        major = ob.getMajor();
        minor = ob.getMinor();
      }
    } catch (Exception e) {
      e.printStackTrace();
    }

    String result = id + ";" + major + ";" +minor;
    return result.toUpperCase();
  }

  public static boolean isNetworkAvailable(Context context) {
    ConnectivityManager connectivityManager
        = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
    NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
    return activeNetworkInfo != null && activeNetworkInfo.isConnected();
  }

  public static String formatTime(long ts) {
    Date date = new Date(ts);
    DateFormat formatter = new SimpleDateFormat("HH:mm:ss");
    formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    return formatter.format(date);
  }
}
