package com.zing.zalo.devicetrackingsdk.event;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

import com.zing.zalo.devicetrackingsdk.ConstantZingAnalytics;
import com.zing.zalo.zalosdk.core.log.Log;

import java.util.ArrayList;
import java.util.List;

public class EventDataSource {
	// Database fields
	private SQLiteDatabase database;
	private EventSQLiteHelper dbHelper;

	public EventDataSource(Context context) {
		dbHelper = new EventSQLiteHelper(context);
	}

	public void open() throws SQLException {
		database = dbHelper.getWritableDatabase();
	}

	public void close() {
		dbHelper.close();
	}

	public void addAllEvents(List<Event> events) {
		for (Event event : events) {
			addEvent(event);
		}
	}
	
	public void removeAllEvents(List<Event> events) {
		for (Event event : events) {
			deleteEvent(event.getTimestamp());
		}
	}
	
	private boolean addEvent(Event event) {
		try {
			open();
			ContentValues values = new ContentValues();
			values.put(EventSQLiteHelper.COLUMN_TIME, event.getTimestamp());
			values.put(EventSQLiteHelper.COLUMN_ACTION, event.getAction());
			values.put(EventSQLiteHelper.COLUMN_DATA, event.getParams().toString());
			long id = database.insert(EventSQLiteHelper.TABLE_EVENT, null, values);
			if (id != -1)
				return true;
			return false;
		} catch(Exception ex) {
			if (ex.getMessage() == null)
				ex.printStackTrace();
			else
				Log.e(getClass().getSimpleName(), ex.getMessage());
			return false;
		} finally {
			close();
		}
	}

	public void clearAllEvents() {
		try {
			open();
			database.delete(EventSQLiteHelper.TABLE_EVENT, null, null);			
		} catch(Exception ex) {
			if (ex.getMessage() == null)
				ex.printStackTrace();
			else
				Log.e(getClass().getSimpleName(), ex.getMessage());
		} finally {
			close();
		}
	}

	public void deleteEvent(long startTime) {
		try {
			open();
			database.delete(EventSQLiteHelper.TABLE_EVENT,
					EventSQLiteHelper.COLUMN_TIME + "=?",
					new String[] { ""+startTime });		
		} catch(Exception ex) {
			if (ex.getMessage() == null)
				ex.printStackTrace();
			else
				Log.e(getClass().getSimpleName(), ex.getMessage());
		} finally {
			close();
		}
		
	}

	public List<Event> getListEvent() {
		Cursor cursor = null;
		List<Event> sessions = new ArrayList<Event>();
		try {	
			open();
			cursor = database.query(EventSQLiteHelper.TABLE_EVENT, null, null, null,
					null, null, null);

			if (cursor!= null) {
				cursor.moveToFirst();
				while (!cursor.isAfterLast()) {
					Event session = new Event(cursor);
					sessions.add(session);
					cursor.moveToNext();
				}
			}
			return sessions;	
			
		}catch(Exception e) {
			return sessions;
		}
		finally{
			if (cursor != null && !cursor.isClosed()) cursor.close();
			close();
		}
	
	}
	
	public void clearOldEvent(){//over 2days
		long startTime = System.currentTimeMillis();
		try {
			open();
			int numeffect = database.delete(EventSQLiteHelper.TABLE_EVENT,
					EventSQLiteHelper.COLUMN_TIME + "<?",
					new String[] { String.valueOf(System.currentTimeMillis() - ConstantZingAnalytics.DEFAULT_VALID_EVENTS)});
		} catch(Exception ex) {
			if (ex.getMessage() == null)
				ex.printStackTrace();
			else
				Log.e(getClass().getSimpleName(), ex.getMessage());
		} finally {
			close();
		}
	}
}
