package com.zing.zalo.devicetrackingsdk.event;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningAppProcessInfo;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Process;

public class EventSQLiteHelper extends SQLiteOpenHelper {
	public static final String TABLE_EVENT   	  		 = "events";
	public static final String COLUMN_TIME  			 = "time";
	public static final String COLUMN_ACTION  	 		 = "action";
	public static final String COLUMN_DATA  	 		 = "data";
	
	private static final String DATABASE_NAME = "session.db";
	private static final int DATABASE_VERSION = 1;

	// Database creation sql statement
	private static final String DATABASE_CREATE = "create table "
			+ TABLE_EVENT + "(" 
			+ COLUMN_TIME	+ " integer not null, " 
			+ COLUMN_ACTION	+ " text not null, " 
			+ COLUMN_DATA	+ " text not null);";

	public EventSQLiteHelper(Context context) {
		super(context, getCurrentProcessName(context) + "." + DATABASE_NAME, null, DATABASE_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase database) {
		database.execSQL(DATABASE_CREATE);
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		db.execSQL("DROP TABLE IF EXISTS " + TABLE_EVENT);
		onCreate(db);
	}
	
	private static String getCurrentProcessName(Context context) {
		try {
			ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
			int myPid = Process.myPid();
			for (RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
				if(processInfo.pid == myPid) {
					return processInfo.processName;
				}
		    }
			
			return context.getPackageName();
		}
		catch (Exception ex) {
			return "default";
		}
	}
}
