package com.zing.zalo.devicetrackingsdk.model;

/**
 * Created by CPU10329-local on 7/6/2017.
 */
import android.content.Context;

import com.zing.zalo.devicetrackingsdk.event.Event;
import com.zing.zalo.devicetrackingsdk.event.EventDataSource;
import com.zing.zalo.zalosdk.core.helper.Storage;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventStorage extends Storage{

    private List<Event> events = new LinkedList<>();
    private List<Event> pendingWriteEvents;
    private List<Event> pendingDeleteEvents;

    private EventDataSource eventDataSource;

    public EventStorage(Context c){
        super(c);
        pendingWriteEvents = new CopyOnWriteArrayList<Event>();
        pendingDeleteEvents = new CopyOnWriteArrayList<Event>();
        eventDataSource = new EventDataSource(c);
    }


    public void loadEvents() {

        eventDataSource.clearOldEvent();
        events = eventDataSource.getListEvent();
//		for (int i = 0 ; i< events.size(); i++){
//			android.util.Log.i("debuglog", events.get(i).getParams().toString());
//		}
    }
    public List<Event> getEvents() {
        return events;
    }

    public void addEvent(Event e) {
        events.add(e);
        pendingWriteEvents.add(e);
    }

    public void removeEvent(Event e) {
        events.remove(e);
        pendingWriteEvents.remove(e);
        pendingDeleteEvents.add(e);
    }

    public void clearEvents() {
        events.clear();
        pendingWriteEvents.clear();
        pendingDeleteEvents.clear();
        eventDataSource.clearAllEvents();
    }

    public void saveEvents() {
        eventDataSource.removeAllEvents(pendingDeleteEvents);
        eventDataSource.addAllEvents(pendingWriteEvents);
        //Log.v("add %d remove %d events", pendingWriteEvents.size(), pendingDeleteEvents.size());
        pendingWriteEvents.clear();
        pendingDeleteEvents.clear();
    }
}
