package com.zing.zalo.zalosdk.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;

import com.zing.zalo.zalosdk.core.log.Log;


public class ReferrerReceiver extends BroadcastReceiver{

	@Override
	public void onReceive(Context context, Intent intent) {
		
		Bundle extras = intent.getExtras();
        String referrerString = extras.getString("referrer");
        
        if (!TextUtils.isEmpty(referrerString)) {
        	context.getSharedPreferences("zacCookie", 0).edit().putString("referrer", referrerString).apply();
            
            Log.w("ReferrerReceiver", "Referrer is: " + referrerString);
            
        }
        
	}

}
