package com.zing.zalo.devicetrackingsdk.abstracts;

import android.app.Activity;

import com.zing.zalo.devicetrackingsdk.AppUserDataCallback;
import com.zing.zalo.devicetrackingsdk.DeviceTracking.GetInfoListener;
import com.zing.zalo.zalosdk.core.type.EventType;

import java.util.Map;

public interface IDeviceTracking {
	
	/**
	 * Return the device id
	 * Will return null if the device id haven't generated yet, app need to call back in a few sec to get the device id
	 */
	public String getDeviceId();
	
	/**
	 * Return the device id
	 * if the device id haven't generated yet, pass call back to get the device id
	 */
	public void getDeviceId(GetInfoListener getDeviceIdListener);
	/**
	 * Send on_start event 
	 * @param activity
	 */

	public void onResume(Activity activity);
	
	/**
	 * Send on_stop event
	 * @param activity
	 */
	public void onPause(Activity activity);
	
	
	public void sendOpenView(String viewName);
	
	public void addException(String name, String message, String reason, String stacktrace);
	/**
	 * Send on_start event with extra param
	 * @param activity
	 * @param params
	 */
//	public void onResume(Activity activity, Map<String, String> params);
	
	/**
	 * Send on_stop event with extra param
	 * @param action
	 * @param category
	 * @param label
	 * @param value
	 */
//	public void onPause(Activity activity, Map<String, String> params);
	public void addEvent(String action, String category, String label, long value);
	/**
	 * Add event
	 * @param action
	 * @param params
	 */
	public void addEvent(String action, Map<String, String> params);

	/**
	 * Add event
	 * @param eventType
	 * @param params
	 */
	public void addEvent(EventType eventType, Map<String, String> params);

	/**
	 * set the max events to be stored
	 * Default value is 1000
	 * @param num
	 */
	public void setMaxEventsStored(int num);
	
	/**
	 * set the dispatch events to server interval 
	 * Default value is 60*1000, min value is 10*1000 
	 * * Set a negative value to disable store events automatically, app must call storeEvents() explicit
	 * @param ms
	 */
	public void setDispatchEventsInterval(long ms);
	
	/**
	 * set the store events to disk interval
	 * Default value is 30*1000, min value is 10*1000
	 * Set a negative value to disable dispatch events automatically, app must call dispatchEvents() explicit
	 * @param ms
	 */
	public void setStoreEventsInterval(long ms);
	
	/**
	 * Manual send events to server
	 */
	public void dispatchEvents();
	
	/**
	 * Manual write events to disk 
	 */
	public void storeEvents();
}
