package com.zing.zalo.devicetrackingsdk.event;

import android.database.Cursor;

import org.json.JSONException;
import org.json.JSONObject;

public class Event {
	private String action;
	private long timestamp;
	private JSONObject params;
		
	public Event() {
		super();
	}
	public Event(String action, long timestamp, JSONObject params) {
		super();
		this.action = action;
		this.timestamp = timestamp;
		this.params = params;
	}
	public Event (Cursor cursor) {
		this.timestamp = Long.parseLong(cursor.getString(0));
		this.action = cursor.getString(1);
		try {
			this.params = new JSONObject(cursor.getString(2));
		} catch (JSONException e) {
			e.printStackTrace();
		}

	}
	public String getAction() {
		return action;
	}
	public void setAction(String action) {
		this.action = action;
	}
	public long getTimestamp() {
		return timestamp;
	}
	public void setTimestamp(long timestamp) {
		this.timestamp = timestamp;
	}
	public JSONObject getParams() {
		return params;
	}

	public void setParams(JSONObject params) {
		this.params = params;
	}
}
