package com.zing.zalo.zalosdk.service;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;

import com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager;
import com.zing.zalo.zalosdk.core.log.Log;

import java.lang.Thread.UncaughtExceptionHandler;
import java.util.HashMap;
import java.util.Map;

public class CatchExceptionService implements IZaloSDKService {
	public static CatchExceptionService Instance = new CatchExceptionService();
	private UncaughtExceptionHandler systemUncaughtHandler;

	public void start(Application app) {
		Handler handler = new Handler();
		handler.postDelayed(new Runnable() {

			@Override
			public void run() {
				loop();
			}
		}, 1500);
	}

	public void loop() {
		systemUncaughtHandler = Thread.getDefaultUncaughtExceptionHandler();
		UncaughtHandler uncaughtHandler = new UncaughtHandler(new Handler());
		Thread.setDefaultUncaughtExceptionHandler(uncaughtHandler);

		while (true) {
			try {
				Looper.loop();
				Thread.setDefaultUncaughtExceptionHandler(systemUncaughtHandler);
			} catch (BackgroundException e) {
				// logCrash(systemUncaughtHandler, e);
			} catch (Throwable ex) {
				logCrash(Thread.currentThread(), ex);
			}
		}
	}

	@Override
	public void stop() {
	}

	private void logCrash(final Thread thread, final Throwable ex) {

		Handler handler = new Handler(Looper.getMainLooper());
		handler.post(new Runnable() {
			public void run() {
				StackTraceElement[] traceElement = ex.getStackTrace();
				boolean isZaloSDKException = false;
				StringBuilder spStackTrace = new StringBuilder();

				//build stack trace
				for (StackTraceElement stackTraceElement : traceElement) {

					//ignore trace to this class
					if (stackTraceElement.getClassName().contains(CatchExceptionService.class.getSimpleName())) {
						continue;
					}

					//detect if zalo sdk exception?
					if (stackTraceElement.getClassName().contains("com.zing.zalo.zalosdk") || 
						stackTraceElement.getClassName().contains("com.zing.zalo.devicetrackingsdk")) {
						isZaloSDKException = true;
					}

					spStackTrace
						.append(stackTraceElement.getClassName())
						.append(".")
						.append(stackTraceElement.getMethodName())
						.append("():")
						.append(stackTraceElement.getLineNumber())
						.append("\n");

				}

				//build message
				Map<String, String> params = new HashMap<String, String>();
				params.put("name", ex.getClass().getName());
				params.put("message", ex.getMessage());
				if (ex.getCause() != null) {
					params.put("reason", ex.getCause().toString());
				}
				params.put("stack_trace", spStackTrace.toString());
				
				ZingAnalyticsManager.getInstance().addEvent("crash_log", params);//store event before crash app
				systemUncaughtHandler.uncaughtException(thread, ex);
				
				
				Log.e(params.toString());
//				if (!isZaloSDKException) {
//					//if not zalo sdk exceptoin, let's it crash
//					ZingAnalyticsManager.getInstance().forceAddEvent("crash_log", params);//store event before crash app
//					systemUncaughtHandler.uncaughtException(thread, ex);
//				}
//				else {
//					//submit crash log to server
//					ZingAnalyticsManager.getInstance().addEvent("crash_log", params); 
//					//zalo sdk exception, not make it crash, notify other components
//					notifyObserver(ex);
//				}
			}
		});

	}

	/**
	 * This handler catches exceptions in the background threads and propagates
	 * them to the UI thread
	 */
	class UncaughtHandler implements UncaughtExceptionHandler {

		private final Handler mHandler;

		UncaughtHandler(Handler handler) {
			mHandler = handler;
		}

		@Override
		public void uncaughtException(final Thread thread, final Throwable ex) {
			final int tid = android.os.Process.myTid();
			final String threadName = thread.getName();
			mHandler.post(new Runnable() {
				public void run() {

					logCrash(thread, ex);

					throw new BackgroundException(ex, tid, threadName);
				}
			});
		}
	}

	/**
	 * Wrapper class for exceptions caught in the background
	 */
	static class BackgroundException extends RuntimeException {

		/**
		 * 
		 */
		private static final long serialVersionUID = 2069643763787433913L;
		final int tid;
		final String threadName;

		/**
		 * @param e
		 *            original exception
		 * @param tid
		 *            id of the thread where exception occurred
		 * @param threadName
		 *            name of the thread where exception occurred
		 */
		BackgroundException(Throwable e, int tid, String threadName) {
			super(e);
			this.tid = tid;
			this.threadName = threadName;
		}
	}
}
