package com.zing.zalo.zalosdk.service;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;

import com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.type.EventType;
import com.zing.zalo.zalosdk.service.Foreground.AppCycleListener;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class AppLifeCycleMonitorService implements IZaloSDKService {

	public static AppLifeCycleMonitorService Instance = new AppLifeCycleMonitorService();
	private Foreground foreground;

	@Override
	public void start(Application app) {
		foreground = Foreground.get(app);
		foreground.addListener(listener);
	}

	@Override
	public void stop() {
		foreground.removeListener(listener);
		foreground = null;
	}

	private AppCycleListener listener = new AppCycleListener() {
		@Override
		public void onBecameForeground(WeakReference<Activity> activity) {
			try {
				ZingAnalyticsManager.getInstance().addEvent(EventType.OPEN_APP, null);

				//submit deep linking
				Activity act = activity.get();
				if(act != null) {
					Intent intent = act.getIntent();
					Uri data = intent.getData();
					ComponentName callingCmp = act.getCallingActivity();
					Map<String, String> params = new HashMap<String, String>();

					if(intent.hasCategory(Intent.CATEGORY_BROWSABLE) && data != null) {
						//from web view
						params.put("source", "com.google.android.browser");
						params.put("url", data.toString());
					}
					else if(callingCmp != null) {
						params.put("source", callingCmp.getPackageName());
						params.put("url", callingCmp.getClassName());
					}

					if(params.size() > 0) {
						ZingAnalyticsManager.getInstance().addEvent(EventType.DEEP_LINKING, params);
					}
				}

				ZingAnalyticsManager.getInstance().dispatchEvents();
			}catch (Exception e) { Log.e(e); }
		}

		@Override
		public void onBecameBackground(WeakReference<Activity> activity) {}
		@Override
		public void onActivityResume(WeakReference<Activity> activity) {}
	};
}
