package com.zing.zalo.zalosdk.oauth;


public class OauthResponse {
	private int errorCode;
	private String errorMessage;
	private long uId; 
	private String oauthCode;
	private LoginChannel channel;
	private String facebookAccessToken;
	private long facebookExpireTime;
	private String socialId;
	private String refreshToken;
	public String raw;

	private long expireTime;
	private int zcert;
	public boolean isRegister() {
		return isRegister;
	}

	public void setRegister(boolean register) {
		isRegister = register;
	}

	private boolean isRegister;

	public OauthResponse() {
		uId = 0;
		errorCode = 0;
		channel = LoginChannel.ZALO;
	}
	
	public OauthResponse(long uId, String oauthCode, LoginChannel channel) {
		this.uId = uId;
		this.oauthCode = oauthCode;
		this.channel = channel;
	}

	public OauthResponse(long uId, String oauthCode, LoginChannel channel, String facebookAccessToken, long facebookExpireTime) {
		this.uId = uId;
		this.oauthCode = oauthCode;
		this.channel = channel;
		this.facebookAccessToken = facebookAccessToken;
		this.facebookExpireTime =  facebookExpireTime;
	}

	public OauthResponse(String refreshToken, long uId, LoginChannel channel, String facebookAccessToken, long facebookExpireTime) {
		this.uId = uId;
		this.refreshToken = refreshToken;
		this.channel = channel;
		this.facebookAccessToken = facebookAccessToken;
		this.facebookExpireTime =  facebookExpireTime;
	}

	public String getSocialId() {
		return socialId;
	}

	public void setSocialId(String socialId) {
		this.socialId = socialId;
	}
	
	public int getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(int errorCode) {
		this.errorCode = errorCode;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public long getuId() {
		return uId;
	}

	public void setuId(long uId) {
		this.uId = uId;
	}

	public String getOauthCode() {
		return oauthCode;
	}

	public OauthResponse setOauthCode(String oauthCode) {
		this.oauthCode = oauthCode;
		return this;
	}

	public LoginChannel getChannel() {
		return channel;
	}

	public OauthResponse setChannel(LoginChannel channel) {
		this.channel = channel;
		return this;
	}

	public String getFacebookAccessToken() {
		return facebookAccessToken;
	}

	public void setFacebookAccessToken(String facebookAccessToken) {
		this.facebookAccessToken = facebookAccessToken;
	}

	public long getFacebookExpireTime() {
		return facebookExpireTime;
	}

	public void setFacebookExpireTime(long facebookExpireTime) {
		this.facebookExpireTime = facebookExpireTime;
	}

	public String getRefreshToken() {
		return refreshToken;
	}

	public OauthResponse setRefreshToken(String refreshToken) {
		this.refreshToken = refreshToken;
		return this;
	}

	public long getExpireTime() {
		return expireTime;
	}

	public OauthResponse setExpireTime(long expireTime) {
		this.expireTime = expireTime;
		return this;
	}

	public int getZcert() {
		return zcert;
	}

	public OauthResponse setZcert(int zcert) {
		this.zcert = zcert;
		return this;
	}
}
