package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebRegisterFragment;
import com.zing.zalo.zalosdk.payment.direct.PaymentProcessingDialog;

import org.json.JSONException;
import org.json.JSONObject;

public class WebLoginActivity extends FragmentActivity implements ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener, OnClickListener{

    ZaloWebLoginFragment loginFragment;
    ZaloWebRegisterFragment registerFragment;
    FrameLayout frameLayout;
    int frameLayoutId;

    PaymentProcessingDialog progressDialog;
    TextView titleView;
    ImageView backButton;
    boolean registerOnly;

    public static Intent newIntent(Context context, boolean registerOnly) {
        Intent intent = new Intent(context, WebLoginActivity.class);
        intent.putExtra("registerOnly", registerOnly);
        return intent;
    }

    @Override
    //This method is required by ZaloSDK
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ZaloSDK.Instance.onActivityResult(this, requestCode, resultCode, data);
    }

    private void changestatusbarColor(){
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(ContextCompat.getColor(this, R.color.zing_pressed));
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        changestatusbarColor();

        registerOnly = getIntent().getBooleanExtra("registerOnly", false);
        //show web login view
        setContentView(Utils.getResourceId(this, "zalosdk_activity_zalo_web_login", "layout"));
        frameLayoutId = Utils.getResourceId(this, "zalosdk_weblogin_container", "id");
        frameLayout = findViewById(frameLayoutId);

        int id =Utils.getResourceId(this, "zalosdk_txt_title", "id");
        titleView = findViewById(id);

        id = Utils.getResourceId(this, "zalosdk_back_control", "id");
        backButton = findViewById(id);
        backButton.setOnClickListener(this);

        if(savedInstanceState == null) {
            if (registerOnly) {
                registerFragment = ZaloWebRegisterFragment.newIstance();
                FragmentManager fragmentManager = getSupportFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.replace(frameLayoutId, registerFragment, "register-fragment");
                transaction.commit();
            } else {
                showWebLoginFragment();
            }
        }
    }


    @Override
    public void onClick(View v) {
        if(v == backButton) {
            Utils.hideSoftKeyboard(this);
            onBackPressed();
        }

    }

    @Override
    public void onBackPressed() {
        if(backButton != null && backButton.getVisibility() == View.VISIBLE) {
            super.onBackPressed();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    private void showWebLoginFragment() {
        loginFragment = ZaloWebLoginFragment.newIstance();
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.replace(frameLayoutId,  loginFragment, "login-fragment");
        transaction.commitAllowingStateLoss();
    }

    @Override
    public void showLoading() {
        if(progressDialog == null) {
            progressDialog = new PaymentProcessingDialog(this, new PaymentProcessingDialog.OnCloseListener() {
                @Override
                public void onClose() { }
            });
        }

        if(!progressDialog.isShowing()) {
            progressDialog.show();
        }
    }

    @Override
    public void hideLoading() {
        if(progressDialog != null && progressDialog.isShowing()) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }

    @Override
    public void showMessageDialog(String title, String message) {
        showDialog(this, null, title, message, getString(Utils.getResourceId(this, "txt_close", "string")));
    }

    @Override
    public void setTitle(String title) {
        if(titleView != null) titleView.setText(title);
    }

    @Override
    public void showBackButton() {
        if(backButton != null) backButton.setVisibility(View.VISIBLE);

    }

    @Override
    public void hideBackButton() {
        if(backButton != null) backButton.setVisibility(View.INVISIBLE);
    }

    @Override
    public void onLoginCompleted(int error, long uid, String oauth, int zprotect, String name, boolean isRegister) {
        Intent data = new Intent();
        data.putExtra("error", error);
        data.putExtra("uid", uid);
        data.putExtra("code", oauth);
        data.putExtra("isRegister", isRegister);

        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();
        try {
            extraData.put("display_name", name);
            extraData.put("zprotect", zprotect);
            extra.put("data", extraData);
        } catch(JSONException ignored) {
            Log.w("onLoginCompleted", ignored);
        }


        data.putExtra("data", extra.toString());
        setResult(RESULT_OK, data);
        finish();
    }

    @Override
    public void onLoginFailed(int error, String errorMsg, String errorReason, String errorDescription, String fromSource){
        Intent data = new Intent();
        data.putExtra("error", error);

        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();
        try {
            extraData.put("errorMsg", errorMsg);
            extraData.put("error_description", errorDescription);
            extraData.put("error_reason", errorReason);
            extraData.put("from_source", fromSource);

            extra.put("data", extraData);
        } catch(JSONException ignored) {
            Log.e("onLoginFailed", ignored);
        }


        data.putExtra("data", extra.toString());
        setResult(RESULT_OK, data);
        finish();
    }



    public void showDialog(Activity activity, final OnDialogClickListener listener, final String title, final String msg, final String command){
        showConfirmDialog(activity, listener, title, null, msg, null, command);
    }

    public void showConfirmDialog(Activity activity, final OnDialogClickListener listener, final String tile,
                                  final String phoneNumber, final String content, final String leftCommand, final String rightCommand){
        final Dialog layout = new Dialog(activity);
        layout.requestWindowFeature(Window.FEATURE_NO_TITLE);
        layout.setContentView(R.layout.zalo_web_regis_dialog_confirm);

        Window window = layout.getWindow();
        if(window !=  null) {
            window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }

        if (!TextUtils.isEmpty(content)){
            ((TextView)layout.findViewById(R.id.content)).setText(content);
        }
        if (TextUtils.isEmpty(tile)){
            layout.findViewById(Utils.getResourceId(activity, "line", "id")).setVisibility(View.GONE);
            layout.findViewById(Utils.getResourceId(activity, "txt_title", "id")).setVisibility(View.GONE);
        } else {
            ((TextView)layout.findViewById(Utils.getResourceId(activity, "txt_title", "id"))).setText(tile);
        }
        if (TextUtils.isEmpty(phoneNumber)){
            layout.findViewById(R.id.phoneNumber).setVisibility(View.GONE);
        } else {
            layout.findViewById(R.id.phoneNumber).setVisibility(View.VISIBLE);
            ((TextView)layout.findViewById(R.id.phoneNumber)).setText(phoneNumber);
        }
        if (TextUtils.isEmpty(rightCommand)){
            layout.findViewById(R.id.btn_add).setVisibility(View.GONE);
        } else {
            ((TextView)layout.findViewById(R.id.btn_add)).setText(rightCommand);
            layout.findViewById(R.id.btn_add).setVisibility(View.VISIBLE);
            layout.findViewById(R.id.btn_add).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    layout.dismiss();
                    if (listener != null){
                        listener.onClickOk();
                    }
                }
            });
        }
        if (TextUtils.isEmpty(leftCommand)){
            layout.findViewById(R.id.btn_cancel).setVisibility(View.GONE);
        } else {
            ((TextView)layout.findViewById(R.id.btn_cancel)).setText(leftCommand);
            layout.findViewById(R.id.btn_cancel).setVisibility(View.VISIBLE);
            layout.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    layout.dismiss();
                    if (listener != null){
                        listener.onCancel();
                    }
                }
            });
        }
        if ((!TextUtils.isEmpty(leftCommand) && TextUtils.isEmpty(rightCommand))
                || (TextUtils.isEmpty(leftCommand) && !TextUtils.isEmpty(rightCommand))
                ){

            String text = !TextUtils.isEmpty(leftCommand) ? leftCommand : rightCommand;

            layout.findViewById(R.id.btn_cancel).setVisibility(View.GONE);
            layout.findViewById(R.id.btn_add).setVisibility(View.GONE);
            TextView centerButton = layout.findViewById(Utils.getResourceId(activity, "centerbtn", "id"));
            centerButton.setVisibility(View.VISIBLE);
            centerButton.setText(text);
            centerButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    layout.dismiss();
                    if (listener != null){
                        listener.onCancel();
                        listener.onClickOk();
                    }
                }
            });
        }
        layout.show();
    }

    public interface OnDialogClickListener{
        void onCancel();
        void onClickOk();
    }


}
