package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;

import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONException;
import org.json.JSONObject;

public class BrowserLoginActivity extends Activity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (handleBrowserCallback()) {
            finish();
        }
    }

    private boolean handleBrowserCallback() {
        Uri data = getIntent().getData();
        if (data == null || data.getQuery() == null) return false;

        String scheme = data.getScheme();
        if (scheme == null || !scheme.startsWith("zalo-" + AppInfo.getAppId(this))) {
            return false;
        }

        Intent intent = new Intent();

        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();

        String sError = data.getQueryParameter("error");
        if (sError != null && Integer.parseInt(sError) != 0) {

            intent.putExtra("error", Integer.parseInt(data.getQueryParameter("error")));

            try {
                String errorMsg = data.getQueryParameter("errorMsg");
                String errorDescription = data.getQueryParameter("error_description");
                String errorReason = data.getQueryParameter("error_reason");

                extraData.put("errorMsg", errorMsg != null ? errorMsg : "");
                extraData.put("error_description", errorDescription != null ? errorDescription : "");
                extraData.put("error_reason", errorReason != null ? errorReason : "");
                extraData.put("from_source", "browser");
                extra.put("data", extraData);
            } catch (JSONException ignored) {
                Log.e("handleBrowserCallback", ignored);
            }

            intent.putExtra("data", extra.toString());
        } else if (data.getQueryParameter("code") != null) {
            intent.putExtra("uid", Long.parseLong(data.getQueryParameter("uid")));
            intent.putExtra("code", data.getQueryParameter("code"));

            try {
                extraData.put("display_name", data.getQueryParameter("display_name"));
                extraData.put("scope", data.getQueryParameter("scope"));
                extraData.put("socialId", data.getQueryParameter("socialId"));
                extraData.put("dob", data.getQueryParameter("dob"));
                extraData.put("gender", data.getQueryParameter("gender"));
                extraData.put("from_source", "browser");
                extra.put("data", extraData);
            } catch (JSONException ignored) {
                Log.e("handleBrowserCallback", ignored);
            }

            intent.putExtra("data", extra.toString());
        }

        ZaloSDK.Instance.onActivityResult(this, com.zing.zalo.zalosdk.common.Constant.ZALO_AUTHENTICATE_REQUEST_CODE, 0, intent);
        return true;
    }
}
