package com.zing.zalo.zalosdk.oauth;


import android.content.Context;
import android.content.res.Resources;

import com.zing.zalo.zalosdk.R;

public class ZaloOAuthResultCode {

    public static final int RESULTCODE_REGIS_IDENTIFY_CARD_NUMBER_SUCCESS = 8000;
    public static final int RESULTCODE_REGIS_CERTIFICATE_GUEST_SUCCESS = 8001;

    public static final int RESULTCODE_NO_ERROR = 0;
    public static final int RESULTCODE_PERMISSION_DENIED = -201;
    public static final int RESULTCODE_USER_BACK = -1111;
    public static final int RESULTCODE_USER_REJECT = -1114;
    public static final int RESULTCODE_ZALO_UNKNOWN_ERROR = -1112;
    public static final int RESULTCODE_ZALO_WEB_VIEW_LOGIN_NOT_ALLOWED = -1118;
    public static final int RESULTCODE_UNEXPECTED_ERROR = -1000;
    public static final int RESULTCODE_INVALID_APP_ID = -1001;
    public static final int RESULTCODE_INVALID_PARAM = -1002;
    public static final int RESULTCODE_INVALID_SECRET_KEY = -1003;
    public static final int RESULTCODE_INVALID_OAUTH_CODE = -1004;
    public static final int RESULTCODE_ACCESS_DENIED = -1005;
    public static final int RESULTCODE_INVALID_SESSION = -1006;
    public static final int RESULTCODE_CREATE_OAUTH_FAILED = -1007;
    public static final int RESULTCODE_CREATE_ACCESS_TOKEN_FAILED = -1008;
    public static final int RESULTCODE_USER_CONSENT_FAILED = -1009;
    public static final int RESULTCODE_APPLICATION_IS_NOT_APPROVED = -1014;
    public static final int RESULTCODE_ZALO_OAUTH_INVALID = -1019;
    public static final int RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR = -1020;
    public static final int RESULTCODE_ZALO_WEBVIEW_NO_NETWORK = -1021;
    public static final int RESULTCODE_ZALO_SDK_NO_INTERNET_ACCESS = -1022;
    public static final int RESULTCODE_CANT_LOGIN_ZINGME = -1023;
    public static final int RESULTCODE_ZALO_APPLICATION_NOT_INSTALLED = -1024;
    public static final int RESULTCODE_ZALO_OUT_OF_DATE = -1025;

    public static final int RESULTCODE_CANT_LOGIN_FACEBOOK = -1105;
    public static final int RESULTCODE_CANT_LOGIN_GOOGLE = -1205;


    public static int findById(int rawCode) {
        switch (rawCode) {
            case 0:
                return RESULTCODE_NO_ERROR;
            case 1:
                return RESULTCODE_ZALO_UNKNOWN_ERROR;
            case 2:
                return RESULTCODE_USER_BACK;
            case 3:
                return RESULTCODE_USER_REJECT;
            case -201:
                return RESULTCODE_PERMISSION_DENIED;
            case -1000:
                return RESULTCODE_UNEXPECTED_ERROR;
            case -1001:
                return RESULTCODE_INVALID_APP_ID;
            case -1002:
                return RESULTCODE_INVALID_PARAM;
            case -1003:
                return RESULTCODE_INVALID_SECRET_KEY;
            case -1004:
                return RESULTCODE_INVALID_OAUTH_CODE;
            case -1005:
                return RESULTCODE_ACCESS_DENIED;
            case -1006:
                return RESULTCODE_INVALID_SESSION;
            case -1007:
                return RESULTCODE_CREATE_OAUTH_FAILED;
            case -1008:
                return RESULTCODE_CREATE_ACCESS_TOKEN_FAILED;
            case -1009:
                return RESULTCODE_USER_CONSENT_FAILED;
            case -1014:
                return RESULTCODE_APPLICATION_IS_NOT_APPROVED;
            case -1019:
                return RESULTCODE_ZALO_OAUTH_INVALID;
            case -1023:
                return RESULTCODE_CANT_LOGIN_ZINGME;
            case -1105:
                return RESULTCODE_CANT_LOGIN_FACEBOOK;
            default:
                return rawCode;
        }
    }

    public static String findErrorMessageByID(Context context, int rawCode) {
        String msg = "Không thể đăng nhập Zalo.";
        int errorCode = findById(rawCode);
        switch (errorCode) {
            case RESULTCODE_ZALO_UNKNOWN_ERROR:
                msg = "Lỗi không xác định";
                break;
            case RESULTCODE_USER_BACK:
            case RESULTCODE_ACCESS_DENIED:
            case RESULTCODE_USER_REJECT:
                msg = "";
                break;
            case RESULTCODE_ZALO_WEBVIEW_NO_NETWORK:
            case RESULTCODE_ZALO_SDK_NO_INTERNET_ACCESS:
                msg = context.getString(R.string.no_network);
                break;
            case RESULTCODE_ZALO_APPLICATION_NOT_INSTALLED:
                msg = context.getString(R.string.zalo_app_not_installed);
                break;
            case RESULTCODE_ZALO_OUT_OF_DATE:
                msg = context.getString(R.string.zalo_app_out_of_date);
                break;
            default:
                msg = "Không thể đăng nhập Zalo.";
        }
        return msg;
    }
}


//
//public static final ErrorObject ERROR_DEFAULT = new ErrorObject("Error occured", -1000, "There was an unknown error", "");
//public static final ErrorObject CLIENT_ID_INVALID = new ErrorObject(INVALID_PARAMETER, -1001, INVALID_PARAMETER, "");
//public static final ErrorObject REDIRECT_URI_INVALID = new ErrorObject(INVALID_PARAMETER, -1002, INVALID_PARAMETER, "");
//public static final ErrorObject CLIENT_SECRET_INVALID = new ErrorObject(INVALID_PARAMETER, -1003, INVALID_PARAMETER, "");
//public static final ErrorObject AUTHORIZED_CODE_INVALID = new ErrorObject(INVALID_PARAMETER, -1004, INVALID_PARAMETER, "");
//public static final ErrorObject USER_DENIED = new ErrorObject("access_denied", -1005, "permission_error", "");
//public static final ErrorObject SESSION_INVALID = new ErrorObject(INVALID_SESSION, -1006, INVALID_SESSION, "");
//public static final ErrorObject CANNOT_CREATE_CODE = new ErrorObject("Authorization failed", -1007, "Could not create Authorized code.", "");
//public static final ErrorObject CANNOT_GET_PROFILE = new ErrorObject("Get profile user failed", -1008, "Could not create Authorized code because cant get profile.", "");
//public static final ErrorObject OAUTH_FAILED = new ErrorObject("Authorization failed", -1009, "Had an error when requesting authorized code", "");
//public static final ErrorObject REQUEST_INVALID = new ErrorObject(INVALID_PARAMETER, -1010, INVALID_PARAMETER, "");
//public static final ErrorObject CANCEL_LOGIN = new ErrorObject("Cancel login", -1011, "User has been canceled the process", "");
//public static final ErrorObject IOS_BUNDLE_ID_INVALID = new ErrorObject(INVALID_PARAMETER, -1012, INVALID_PARAMETER, "");
//public static final ErrorObject ANDROID_PACKAGE_INVALID = new ErrorObject(INVALID_PARAMETER, -1013, INVALID_PARAMETER, "");
//public static final ErrorObject APPLICATION_NOT_APPROVED = new ErrorObject("The application is not approved", -1014, "Your application might be not approve or disable by admin", "");
//public static final ErrorObject USER_NOT_IN_WHITE_LIST = new ErrorObject(INVALID_PERMISSION, -1015, INVALID_PERMISSION, "");
//public static final ErrorObject WPHONE_GUID_INVALID = new ErrorObject(INVALID_PARAMETER, -1016, INVALID_PARAMETER, "");
//public static final ErrorObject REQUIRED_PARAMS_INVALID = new ErrorObject(INVALID_PARAMETER, -1017, INVALID_PARAMETER, "");
//public static final ErrorObject AUTHORIZED_APP_FAILED = new ErrorObject(INVALID_PERMISSION, -1018, INVALID_PERMISSION, "");
//public static final ErrorObject NOT_MATCH_USER = new ErrorObject(INVALID_PERMISSION, -1019, INVALID_PERMISSION, "");
//public static final ErrorObject UPDATE_PERMISSION_FAIL = new ErrorObject(INVALID_PERMISSION, -1020, INVALID_PERMISSION, "");
//public static final ErrorObject CANNOT_GET_OPENPROFILE = new ErrorObject(INVALID_PERMISSION, -1021, INVALID_PERMISSION, "");
//public static final ErrorObject CANNOT_CREATE_OPENPROFILE = new ErrorObject(INVALID_PERMISSION, -1022, INVALID_PERMISSION, "");
//public static final ErrorObject LOGIN_ZINGME_FAIL = new ErrorObject(INVALID_PARAMETER, -1023, INVALID_PARAMETER, "");
//public static final ErrorObject REQ_CERT_GUEST_FAIL = new ErrorObject("Certificate guest account failed", -1024, "Lỗi trong quá trình bảo vệ tài khoản. Vui lòng thử lại sau.", "");
//public static final ErrorObject RECOVER_GUEST_FAIL = new ErrorObject("Certificate guest account failed", -1025, "Thông tin email hoặc mật khẩu không đúng.", "");
//public static final ErrorObject REQ_FORGOT_PASSWD_GUEST_FAIL = new ErrorObject("Forgot passwd guest account failed", -1026, "Lỗi trong quá trình yêu cầu thay đổi mật khẩu. Vui lòng thử lại sau.", "");
//public static final ErrorObject USER_NOT_LOGIN = new ErrorObject(INVALID_SESSION, -1027, INVALID_SESSION, "");
//public static final ErrorObject USER_NOT_CONSENT = new ErrorObject(INVALID_PERMISSION, -1028, INVALID_PERMISSION, "");
//public static final ErrorObject IS_DEVELOP = new ErrorObject("App is develop", -1029, "App đang develop", "");
//public static final ErrorObject APP_NOT_LINKED_OA = new ErrorObject(INVALID_PERMISSION, -1030, INVALID_PERMISSION, "");
//public static final ErrorObject CANT_SEND_EMAIL = new ErrorObject("Cant send email", -1031, "Lỗi trong quá trình bảo vệ tài khoản. Vui lòng thử lại sau.", "");
//public static final ErrorObject AUTHORIZED_CODE_EXPIRED = new ErrorObject(INVALID_PARAMETER, -1032, INVALID_PARAMETER, "");
//public static final ErrorObject USER_NOT_OWN_OA = new ErrorObject(INVALID_PERMISSION, -1033, INVALID_PERMISSION, "");
//public static final ErrorObject ZID_TOKEN_INVALID = new ErrorObject(INVALID_PARAMETER, -1034, INVALID_PARAMETER, "");
//public static final ErrorObject CANNOT_CREATE_ACCESS_TOKEN = new ErrorObject(ERROR_OCCUR, -1035, ERROR_OCCUR, "");
//public static final ErrorObject REQUIRED_CODE_CHALLENGE = new ErrorObject(INVALID_PARAMETER, -1036, INVALID_PARAMETER, "");
//public static final ErrorObject REQUIRED_CODE_VERIFIER = new ErrorObject(INVALID_PARAMETER, -1037, INVALID_PARAMETER, "");
//public static final ErrorObject REQUIRED_OAUTH_CODE = new ErrorObject(INVALID_PARAMETER, -1038, INVALID_PARAMETER, "");
//public static final ErrorObject CODE_VERIFIER_INVALID = new ErrorObject(INVALID_PARAMETER, -1039, INVALID_PARAMETER, "");