package com.zing.zalo.zalosdk.oauth;

import android.app.Application;
import android.content.Context;

import com.zing.zalo.devicetrackingsdk.AppTracker;
import com.zing.zalo.devicetrackingsdk.BaseAppInfoStorage;
import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.zalosdk.ZaloSDKCore;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;


/**
 * SDK main application
 * This class must be declared in AndroidManifest
 * <application
 *       android:name="com.zing.zalo.zalosdk.oauth.ZaloSDKApplication"
 *       ...
 * If you have an Application class, make it inherit from this class
 */
public class ZaloSDKApplication extends Application {
	protected static String appID;
	protected static String facebookAppID = "";
	private static AppTracker.Listener atListener;

	@Override
	public void onCreate() {
		super.onCreate();
		init(this);
	}
	
	/**
	 * Use this method to wrap another application if your app can't set this application in App manifest 
	 * You must call this method in the onCreate method of your Application
	 * @param app
	 */
	public static void wrap(Application app) {
		init(app);
	}
	
	@SuppressWarnings("deprecation")
	private static void init(final Application app) {
		//load configuration in app manifest
		appID = AppInfo.getAppId(app);
		facebookAppID = AppInfo.getFacebookAppId(app);

		ZaloSDKCore.init(app);
		initServices(app);

		//init tracking sdk
		Utils.initZingAnalytics(app, appID);

		//init oauth
		ZaloSDK.Instance.initialize(app);
	}

	private static void initServices(final Context ctx) {
		final BaseAppInfoStorage storage = new BaseAppInfoStorage(ctx);
		final DeviceTracking dt = DeviceTracking.getInstance();
		dt.initDeviceTracking(ctx, storage, appID);
		dt.getDeviceId(new DeviceTracking.GetInfoListener() {
			@Override
			public void onGetDeviceIdComplete(String deviceId) {
//				SettingsManager.getInstance().init(ctx, deviceId);  already init in ZaloSDKCore
				AppTracker at = new AppTracker(ctx, storage, appID, dt);
				at.setListener(atListener);
				atListener = null;
			}
		});
	}

	public static void setAppTrackerListener(AppTracker.Listener listener) {
		atListener = listener;
	}

}

