package com.zing.zalo.zalosdk.oauth;

/**
 * Store all messages used in the SDK. You can subclass this to customize the messages. 
 */
public class LocalizedString {
	protected String loadingMessage;
	/**
	 * Default text is "Đang tải..."
	 * @return
	 */
	public String getLoadingMessage() {
		return loadingMessage;
	}
	
	protected String noNetworkMessage;
	/**
	 * Default text is "Mạng không ổn định, vui lòng thử lại sau"
	 * @return
	 */
	public String getNoNetworkMessage() {
		return noNetworkMessage;
	}
	
	protected String zaloOauthOfDateMessage;
	/**
	 * Default text is "Bản Zalo hiện tại không tương thích!"
	 * @return
	 */
	public String getZaloOauthOfDateMessage() {
		return zaloOauthOfDateMessage;
	}
	
	protected String zaloNotInstalledMessage;
	/**
	 * Default text is "Bạn chưa cài Zalo!"
	 * @return
	 */
	public String getZaloNotInstalledMessage() {
		return zaloNotInstalledMessage;
	}
	
	
	protected String updateMessage;
	/**
	 * Default text is "Cập nhật"
	 * @return
	 */
	public String getUpdateMessage() {
		return updateMessage;
	}
	
	protected String installMessage;
	/**
	 * Default text is "Cài đặt"
	 * @return
	 */
	public String getInstallMessage() {
		return installMessage;
	}
	
	protected String cancelMessage;
	/**
	 * Default text is "Bỏ qua"
	 * @return
	 */
	public String getCancelMessage() {
		return cancelMessage;
	}

	protected String errorWebViewMessage = "";

	public String getErrorWebViewMessage(){
		return errorWebViewMessage;
	}

	public LocalizedString() {
		setDefault();
		customizeString();
	}
	
	/**
	 * Override this methd if you want to customize the message
	 */
	protected void customizeString() {
	}

	private void setDefault() {
		loadingMessage = "Đang tải...";
		noNetworkMessage = "Mạng không ổn định, vui lòng thử lại sau";
		zaloOauthOfDateMessage = "Bản Zalo hiện tại không tương thích!";
		zaloNotInstalledMessage = "Bạn chưa cài Zalo!";
		updateMessage = "Cập nhật";
		cancelMessage = "Bỏ qua";
		installMessage = "Cài đặt";
		errorWebViewMessage = "Lỗi WebView. Vui lòng cài đặt Zalo để đăng nhập.";
	}
}
