package com.zing.zalo.zalosdk.oauth.register;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.Fragment;
import android.view.MotionEvent;
import android.view.View;

import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.WebLoginActivity.OnDialogClickListener;

import org.json.JSONObject;

public class ZaloWebLoginBaseFragment extends Fragment {
    protected ZaloWebLoginBaseFragmentListener listener;

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            listener = (ZaloWebLoginBaseFragmentListener) context;
        } catch (ClassCastException ex) {
            Log.e(context.getClass().getSimpleName() + " must implement " + ZaloWebLoginBaseFragmentListener.class.getSimpleName());
        }
    }

    public void setTouchHide(View view, String idView) {
        int id = Utils.getResourceId(getActivity(), idView, "id");
        if (id > 0) {
            view.findViewById(id).setOnTouchListener(new View.OnTouchListener() {

                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    Utils.hideSoftKeyboard(getActivity());
                    return false;
                }
            });
        }
    }

    @Override
    public void onDetach() {
        super.onDetach();
        listener = null;
    }

    public interface ZaloWebLoginBaseFragmentListener {
        void showLoading();

        void hideLoading();

        void showMessageDialog(String title, String message);

        void showDialog(Activity activity, final OnDialogClickListener listener, final String title, final String msg, final String command);

        void showConfirmDialog(Activity activity, final OnDialogClickListener listener, final String tile,
                               final String phoneNumber, final String content, final String leftCommand, final String rightCommand);

        void showBackButton();

        void hideBackButton();

        void setTitle(String title);

        void onLoginCompleted(int error, long uid, String oauth, int zprotect, String name, boolean isRegister);

        void onLoginFailed(int error, String errorMsg, String errorReason, String errorDescription, String fromSource);
    }

    protected void showLoading() {
        if (listener != null) listener.showLoading();
    }

    protected void hideLoading() {
        if (listener != null) listener.hideLoading();
    }

    protected void showMessageDialog(String title, String message) {
        if (listener != null) listener.showMessageDialog(title, message);
    }

    protected void showBackButton() {
        if (listener != null) listener.showBackButton();
    }

    protected void hideBackButton() {
        if (listener != null) listener.hideBackButton();
    }

    protected void setTitle(String title) {
        if (listener != null) listener.setTitle(title);
    }

    protected void onLoginCompleted(int error, long uid, String oauth, int zprotect, String name, boolean isRegister) {
        if (listener != null)
            listener.onLoginCompleted(error, uid, oauth, zprotect, name, isRegister);
    }

    protected void onLoginFailed(int error, String errorMsg, String errorReason, String errorDescription, String fromSource) {
        if (listener != null)
            listener.onLoginFailed(error, errorMsg, errorReason, errorDescription, fromSource);
    }


}
