package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.CookieManager;

import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.ZTaskExecutor;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;
import com.zing.zalo.zalosdk.service.client.ZaloService;

import org.json.JSONObject;
import org.w3c.dom.Text;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;

import static com.zing.zalo.zalosdk.Constant.IS_DEV;

public class Authenticator {

    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;

    static boolean isGetZaloOAuth = false;
    private boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    private boolean zaloPluginLogin = false;
    public String nameActivtyCheckAuthen = "";

    public BroadcastReceiver receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (Constant.AUTHORIZATION_LOGIN_SUCCESSFUL_ACTION.equals(intent
                    .getAction())) {
                bIsZaloLoginSuccessful = intent.getBooleanExtra(
                        Constant.EXTRA_AUTHORIZATION_LOGIN_SUCCESSFUL, false);
            }
        }
    };

    private OauthStorage mStorage;
    private LocalizedString mLocalizedString;

    protected Context mContext;

    Authenticator(Context ctx, OauthStorage storage, LocalizedString localizedString) {
        mContext = ctx;
        mStorage = storage;
        mLocalizedString = localizedString;
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        if (wListener != null && wListener.get() != null) {
            return wListener.get();
        }

        return new OAuthCompleteListener();
    }

    public void setOAuthCompleteListener(OAuthCompleteListener listener) {
        wListener = new WeakReference<>(listener);
    }

    protected OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        if (wLoginFormListener != null && wLoginFormListener.get() != null) {
            return wLoginFormListener.get();
        }

        return new OAuthCompleteListener();
    }

    protected void setLoginFormOAuthCompleteListener(OAuthCompleteListener listener) {
        wLoginFormListener = new WeakReference<>(listener);
    }

    void authenticate(final Activity activity, final LoginVia loginVia, boolean zaloPluginLogin, OAuthCompleteListener listener) {
        if (listener == null)
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        this.zaloPluginLogin = zaloPluginLogin;
        sendOAuthRequest(activity, loginVia);
    }

    void registerZalo(final Activity activity, OAuthCompleteListener listener) {
        if (listener == null)
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        Intent intent = WebLoginActivity.newIntent(activity, true);
        activity.startActivityForResult(intent, Constant.ZALO_AUTHENTICATE_REQUEST_CODE);
    }

    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        boolean isZaloInstalled = AppInfo.isPackageExists(activity, Constant.ZALO_PACKAGE_NAME);

        switch (loginVia) {
            case APP:
                if (isZaloInstalled) {
                    loginViaApp(activity);
                } else {
                    getOAuthCompleteListener().onZaloNotInstalled(activity);
                }

                break;
            case WEB:
                loginViaWeb(activity);
                break;
            case APP_OR_WEB:
                if (isZaloInstalled) {
                    if (SettingsManager.getInstance().isUseWebViewUnLoginZalo(mContext)) {
                        loginViaAppOrWebIfNotLogin(activity);
                    } else {
                        loginViaApp(activity);
                    }
                } else {
                    loginViaWeb(activity);
                }
                break;
        }
    }

    private void loginViaAppOrWebIfNotLogin(final Activity activity) {
        getZaloLoginStatus(new GetZaloLoginStatus() {
            @Override
            public void onGetZaloLoginStatusCompleted(int status) {
                if (status == 1) {
                    loginViaApp(activity);
                } else {
                    loginViaWeb(activity);
                }
            }
        });
    }

    private void loginViaApp(Activity activity) {
        try {
            try {
                activity.unregisterReceiver(receiver);
            } catch (Exception e) {
                Log.v(e.toString());
            }
            IntentFilter intentFilter = new IntentFilter(Constant.AUTHORIZATION_LOGIN_SUCCESSFUL_ACTION);
            activity.registerReceiver(receiver, intentFilter);

            Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
            i.putExtra(Intent.EXTRA_UID, AppInfo.getAppIdLong(mContext));
            activity.startActivityForResult(i, Constant.ZALO_AUTHENTICATE_REQUEST_CODE);

        } catch (ActivityNotFoundException ex) {
            bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        } catch (SecurityException ex) {
            bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        }
    }

    private void loginViaWeb(Activity activity) {
        Boolean canUseBrowserLogin = Utilities.canUseBrowserLogin(activity);
        if (!Utilities.isOnline(activity)) {
//            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_NO_NETWORK, mLocalizedString.getNoNetworkMessage());

            int e = ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_NO_NETWORK;
            String errorMessage = ZaloOAuthResultCode.findErrorMessageByID(activity, e);
            String fromSource = canUseBrowserLogin? "browser" : "web_view";
            ErrorResponse errorResponse = new ErrorResponse(e,errorMessage,"","", fromSource);

            getOAuthCompleteListener().onAuthenError(e, errorMessage);
            getOAuthCompleteListener().onAuthenError(e,errorMessage,errorResponse);
            return;
        }

        if (Utilities.canUseBrowserLogin(activity)) {
            loginViaBrowser(activity);
        }
        else {
            loginViaWebView(activity);
        }
    }

    private void loginViaBrowser(Activity activity) {
        StringBuilder url = new StringBuilder();
        url.append(ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, "/v3/auth?app_id="));
        try {
            url.append(ZaloSDK.Instance.getAppID())
                    .append("&sign_key=").append(URLEncoder.encode(AppInfo.getApplicationHashKey(activity), "UTF-8"))
                    .append("&pkg_name=").append(URLEncoder.encode(AppInfo.getPackageName(activity), "UTF-8"))
                    .append("&orientation=").append(activity.getResources().getConfiguration().orientation)
                    .append("&ts=").append(System.currentTimeMillis())
                    .append("&lang=").append(com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(activity))
                    .append("&ref=zsdk");
        } catch (UnsupportedEncodingException e) {
            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR, e.getMessage());
            return;
        }

        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setData(Uri.parse(url.toString()));
        activity.startActivity(intent);
    }

    //if not check, crash on some device
    private boolean checkCookieManagerSupport() {
        try {
            //check error ABI null in webview
            CookieManager.getInstance();
            return true;
        } catch (Exception ex) {
            return false;
        }
    }

    private void loginViaWebView(Activity activity) {
        if (!checkCookieManagerSupport()) {
            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR, "Webview does not support login!");
            return;
        }

        Intent intent = WebLoginActivity.newIntent(activity, false);
        activity.startActivityForResult(intent, Constant.ZALO_AUTHENTICATE_REQUEST_CODE);
    }

    protected void unauthenticate() {
        try {
            long uid = ZaloSDK.Instance.getZaloId();
            mContext.getSharedPreferences("zacPref", 0).edit()
                    .remove("MAX_PAGING" + uid)
                    .remove("GIFTCODE_EXPIRED_TIME" + uid)
                    .remove("CACHE_CODE_LIST" + uid)
                    .remove("CURRENT_PAGE" + uid)
                    .apply();

            mStorage.setAccessToken("");
            mStorage.setAccessTokenNewAPI("");
            mStorage.setOAuthCode("", "");
            mStorage.setZaloId(0);
            mStorage.setZaloDisplayName("");
            mStorage.setZaloPluginOAuthCode("");
            mStorage.setSocialId("");
        } catch (Exception ex) {
        }
    }

    boolean isAuthenticate(String code, ValidateOAuthCodeCallback callback) {
        if (code == null || code.length() == 0) {
            if (callback != null) {
                callback.onValidateComplete(false,
                        ZaloOAuthResultCode.RESULTCODE_ZALO_OAUTH_INVALID, -1,
                        null);
            }
            return false;
        }
        if (callback != null) {
            ValidateOAuthCodeTask task = new ValidateOAuthCodeTask(code, callback);
            task.execute();
        }
        return true;
    }

    protected boolean onActivityResult(Activity activity, int requestCode,
                                       int resultCode, Intent data) {
        if (requestCode == Constant.ZALO_AUTHENTICATE_REQUEST_CODE) {
            receiveOAuthData(activity, data);
            return true;
        } else if (requestCode == Constant.REQUEST_PERMISSION_REQUEST_CODE) {
            receivePermissionData(activity, data);
            return true;
        }
        return false;
    }

    void receiveOAuthData(Activity activity, Intent data) {
        isGetZaloOAuth = false;
        try {
            activity.unregisterReceiver(receiver);
        } catch (Exception ignored) {
        }

        if (bIsZaloOutOfDate) {
            return;
        }

        mStorage.setAccessToken("");
        mStorage.setAccessTokenNewAPI("");


        if (data == null) {
            int e = ZaloOAuthResultCode.RESULTCODE_USER_BACK;
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(mContext,e);
            ErrorResponse erResponse = new ErrorResponse(e, errorMsg, "", "", "web_login");

            getOAuthCompleteListener().onAuthenError(e, errorMsg);
            getOAuthCompleteListener().onAuthenError(e, errorMsg, erResponse);

            return;
        }

        int error = data.getIntExtra("error", Constant.RESULT_CODE_SUCCESSFUL);
        if (error == 203) {
            getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_ZALO_WEB_VIEW_LOGIN_NOT_ALLOWED, "Không thể đăng nhập Zalo.");
        } else if (error == Constant.RESULT_CODE_SUCCESSFUL) {
            long id = data.getLongExtra("uid", 0);
            String oauth = data.getStringExtra("code");
            boolean isRegister = data.getBooleanExtra("isRegister", false);
            if (zaloPluginLogin) {
                mStorage.setZaloPluginOAuthCode(oauth);
                mStorage.setZaloPluginUserId(id);
            }

            if ((zaloPluginLogin && TextUtils.isEmpty(mStorage.getOAuthCode())) || !zaloPluginLogin) {
                mStorage.setOAuthCode(LoginChannel.ZALO.toString(), oauth);
                mStorage.setZaloId(id);
                try {
                    String jsData = data.getStringExtra("data");
                    JSONObject exData = new JSONObject(jsData)
                            .getJSONObject("data");
                    String displayname = exData.getString("display_name");
                    int zprotect = exData.optInt("zprotect");

                    mStorage.setIsProtected(zprotect);
                    mStorage.setZaloDisplayName(displayname);

                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            OauthResponse resp = new OauthResponse(id, oauth, LoginChannel.ZALO);
            resp.setRegister(isRegister);
            getOAuthCompleteListener().onGetOAuthComplete(resp);
        } else if (error == Constant.RESULT_CODE_ZALO_NOT_LOGIN) {
            if (bIsZaloLoginSuccessful) {
                // User just logged in Zalo, try to authenticate again
                authenticate(activity, LoginVia.APP, zaloPluginLogin, getOAuthCompleteListener());
            } else {
                //user cancel
                getOAuthCompleteListener().onAuthenError(ZaloOAuthResultCode.RESULTCODE_USER_BACK, "");
            }
        } else if (error == Constant.RESULTCODE_USER_REJECT || error == Constant.RESULT_CODE_USER_BACK) {
            int e = ZaloOAuthResultCode.findById(error);
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(mContext, error);
            ErrorResponse erResponse = new ErrorResponse(e, errorMsg, "", "", "app");

            getOAuthCompleteListener().onAuthenError(e, errorMsg);
            getOAuthCompleteListener().onAuthenError(e, errorMsg, erResponse);
        } else {
            // error happened
            int e = ZaloOAuthResultCode.findById(error);
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(mContext, e);
//            String errorMsg = "Không thể đăng nhập Zalo.";

            try {
                String jsData = data.getStringExtra("data");

                if (!TextUtils.isEmpty(jsData)) {
                    JSONObject exData = new JSONObject(jsData);
                    JSONObject extraData = new JSONObject(exData.getString("data"));

                    String msg = extraData.getString("errorMsg");
                    if (!TextUtils.isEmpty(msg)) errorMsg = msg;

                    String errorDescription = extraData.getString("error_description");
                    String errorReason = extraData.getString("error_reason");
                    String fromSource = extraData.getString("from_source");

                    ErrorResponse erResponse = new ErrorResponse(e, errorMsg, errorReason, errorDescription, fromSource);

                    getOAuthCompleteListener().onAuthenError(e, errorMsg, erResponse);
                }
            } catch (Exception ex) {
                errorMsg = ex.toString();
                Log.v(errorMsg);
            }
            getOAuthCompleteListener().onAuthenError(e, errorMsg);
        }
    }

    private boolean checkZaloVersionSupport(Context ctx, int versionCode) {

        try {
            PackageInfo manager = ctx.getPackageManager().getPackageInfo(
                    "com.zing.zalo", 0);
            if (manager.versionCode < versionCode) {
                isGetZaloOAuth = false;
                bIsZaloOutOfDate = true;
                getOAuthCompleteListener().onZaloOutOfDate(ctx);
                return false;
            }
        } catch (NameNotFoundException e) {
            // Handle exception
            isGetZaloOAuth = false;
            bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(ctx);
            return false;
        }

        return true;
    }

    void requestPermissions(Activity activity, Enum<Permissions> permission,
                            OAuthCompleteListener listener) {

        // Check Zalo version
        if (!checkZaloVersionSupport(activity, 90)) {
            return;
        }

        if (listener == null)
            throw new IllegalArgumentException(
                    "OAuthCompleteListener must be set.");
        setOAuthCompleteListener(listener);
        Context ctx = activity.getApplicationContext();
        Intent i = new Intent(
                "com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
        i.putExtra("app_id", ZaloSDK.Instance.getAppID() + "");
        i.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
        i.putExtra("pkg_name", AppInfo.getPackageName(ctx));
        i.putExtra("sign_key", AppInfo.getApplicationHashKey(ctx));
        i.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
        i.putExtra("permission", permission.toString());
        activity.startActivityForResult(i,
                Constant.REQUEST_PERMISSION_REQUEST_CODE);
    }

    void receivePermissionData(Activity activity, Intent data) {

        if (data != null) {
            int error = data.getIntExtra("error", Constant.RESULT_CODE_SUCCESSFUL);
            int e = ZaloOAuthResultCode.findById(error);
            getOAuthCompleteListener().onGetPermissionData(e);
        } else {
            // user press back
            getOAuthCompleteListener().onGetPermissionData(ZaloOAuthResultCode.RESULTCODE_USER_BACK);
        }
    }

    void getZaloLoginStatus(final GetZaloLoginStatus callback) {
        if (callback == null) return;
        ZTaskExecutor.queueRunnable(new Runnable() {
            @Override
            public void run() {
                ZaloService service = new ZaloService();
                Handler handler = new Handler(Looper.getMainLooper());
                try {
                    final int status = service.getUserLoggedStatus(mContext);
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            callback.onGetZaloLoginStatusCompleted(status);
                        }
                    });

                } catch (Exception e) {
                    Log.e(e);
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            callback.onGetZaloLoginStatusCompleted(-1);
                        }
                    });
                }
            }
        });
    }

    private class ValidateOAuthCodeTask extends AsyncTask<Void, Void, String> {
        ValidateOAuthCodeCallback callback;
        String code;

        ValidateOAuthCodeTask(String code, ValidateOAuthCodeCallback callback) {
            if (callback == null)
                throw new IllegalArgumentException("callback can't be null");
            this.callback = callback;
            this.code = code;
        }

        @Override
        protected String doInBackground(Void... arg0) {
            HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, "/v2/mobile/validate_oauth_code"));

            request.addParams(Constant.PARAM_APP_ID,
                    String.valueOf(ZaloSDKApplication.appID));
            request.addParams(Constant.PARAM_OAUTH_CODE, code);
            request.addParams("version", ZaloSDK.Instance.getVersion());
            request.addParams("frm", "sdk");
            return request.getText();
        }

        @Override
        protected void onPostExecute(String result) {
            super.onPostExecute(result);
            try {
                JSONObject object = new JSONObject(result);
                int errorCode = object.getInt("error");

                if (errorCode == 0) {
                    JSONObject data = object.getJSONObject("data");
                    long id = data.getLong("uid");

                    if (id == mStorage.getZaloId()) {
                        int zcert = data.optInt("zcert");
                        int zprotect = data.optInt("zprotect");

                        mStorage.setIsGuestCertificated(zcert);
                        mStorage.setIsProtected(zprotect);
                    }

                    callback.onValidateComplete(true, 0, id, code);
                } else {
                    callback.onValidateComplete(false, errorCode, -1, null);
                }

            } catch (Exception ex) {
                callback.onValidateComplete(false,
                        ZaloOAuthResultCode.RESULTCODE_UNEXPECTED_ERROR, -1,
                        null);
            }

        }
    }

    public OauthStorage getStorage() {
        return mStorage;
    }

    public void resetListener() {
        wListener = null;
    }
}
