package com.zing.zalo.zalosdk.oauth;

import android.content.Context;
import android.os.AsyncTask;

import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;

import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.net.URLEncoder;

/**
 * Interface for query Zalo's Open API
 */
class ZaloAPIService {
	private OauthStorage mStorage = null;
	private String mNewUrl = "https://graph.zaloapp.com/v2.0/me";
//	private String mUrl = "http://openapi.zaloapp.com/query";
	public static final String UTF8 = "UTF-8";

	private static final String AUTH_MOBILE_ACCESS_TOKEN_PATH = "/v3/mobile/access_token";
	private static final String GRAPH_OA_MESSAGE_PATH = "/v2.0/oa/message";
	private static final String GRAPH_APP_REQUESTS_PATH = "/v2.0/apprequests";
	private static final String GRAPH_ME_FEED_PATH = "/v2.0/me/feed";
	private static final String GRAPH_ME_MESSAGE_PATH = "/v2.0/me/message";
	private static final String GRAPH_ME_FRIENDS_PATH = "/v2.0/me/friends";
	private static final String GRAPH_ME_INVITABLE_FRIENDS_PATH = "/v2.0/me/invitable_friends";
	private static final String GRAPH_V2_ME_PATH = "/v2.0/me";



	ZaloAPIService(OauthStorage storage) {
		this.mStorage = storage;
	}

    private JSONObject getAccessToken(Context ctx) {
        JSONObject accessToken = null;
        try {
            accessToken = new JSONObject(mStorage.getAccessTokenNewAPI());
            if (accessToken.getLong("expires_in") < System.currentTimeMillis()) {
                accessToken = null;
            }
        } catch (Exception ex) {
        }
        try {
            if (accessToken == null) {
//                HttpClientRequest request = new HttpClientRequest(Type.POST, Constant.IS_DEV ? "https://dev.oauth.zaloapp.com/v3/mobile/access_token":"https://oauth.zaloapp.com/v3/mobile/access_token");
				HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_ACCESS_TOKEN_PATH));
                request.addParams("code", ZaloSDK.Instance.getOAuthCode());
                request.addParams("pkg_name", AppInfo.getPackageName(ctx));
                request.addParams("sign_key", AppInfo.getApplicationHashKey(ctx));
                request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
                request.addParams("version", ZaloSDK.Instance.getVersion());
				request.addParams("zdevice", ZaloSDK.Instance.getBaseAppInfo().prepareDeviceIdData().toString());
				request.addParams("ztracking", ZaloSDK.Instance.getBaseAppInfo().prepareTrackingData().toString());
				request.addHeader("gid", ZaloSDK.Instance.getDeviceId());
                accessToken = request.getJSON();
                if (accessToken != null) {
                    if (accessToken.optInt("error", -1) >= 0) {
                        accessToken = accessToken.optJSONObject("data");
                        accessToken.put("error", 0);
                        if (accessToken != null) {
                            long time = System.currentTimeMillis() + 1800000;//accessToken.optInt("expires_in", 0)*1000 + System.currentTimeMillis() - 60000;
                            accessToken.put("expires_in", time);
                            mStorage.setAccessTokenNewAPI(accessToken.toString());
                        }
                    }
                }
            }
        } catch (JSONException e) {
        }
        return accessToken;
    }

	private String buildFieldsParam(String[] fields){
		if (fields != null && fields.length > 0){
			StringBuffer param = new StringBuffer();
			for (int i = 0; i<fields.length-1; i++){
				param.append(fields[i]).append(",");
			}
			param.append(fields[fields.length-1]);
			return param.toString();
		}
		return "";
	}

	void getProfile(Context ctx, ZaloOpenAPICallback callback, String[] fields) {
//		HttpClientRequest request = new HttpClientRequest(Type.GET, mNewUrl);
		HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_V2_ME_PATH));
		request.addParams("fields", buildFieldsParam(fields));
		new NewUserTask(ctx, new WeakReference<ZaloOpenAPICallback>(callback)).execute(request);
	}
	
	void getFriendListUsedApp(Context ctx, int position, int count, ZaloOpenAPICallback callback, String [] fields) {
//		HttpClientRequest request = new HttpClientRequest(Type.GET, mNewUrl+"/friends");
		HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_FRIENDS_PATH));
		request.addParams("fields", buildFieldsParam(fields));
		request.addParams("offset", position + "");
		request.addParams("limit", count + "");
		new NewUserTask(ctx, new WeakReference<ZaloOpenAPICallback>(callback) ).execute(request);
	}

	void getFriendListInvitable(Context ctx, int position, int count, ZaloOpenAPICallback callback, String [] fields) {
//		HttpClientRequest request = new HttpClientRequest(Type.GET, mNewUrl+"/invitable_friends");
		HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH,GRAPH_ME_INVITABLE_FRIENDS_PATH ));
		request.addParams("fields", buildFieldsParam(fields));
		request.addParams("offset", position + "");
		request.addParams("limit", count + "");
		new NewUserTask(ctx, new WeakReference<ZaloOpenAPICallback>(callback)).execute(request);
	}

	/**
	 * http://developers.zaloapp.com/docs/api/open-api/tai-lieu/moi-su-dung-ung-dung-post-41
	 * @param ctx Context
	 * @param friendId ex: {"friend-id1", "friend-id2", "friend-id3"}
	 * @param message String
	 * @param callback ZaloOpenAPICallback
	 */
	public void inviteFriendUseApp(Context ctx, String[] friendId, String message, ZaloOpenAPICallback callback){
//		HttpClientRequest request = new HttpClientRequest(Type.POST, "https://graph.zaloapp.com/v2.0/apprequests");
		HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_APP_REQUESTS_PATH));
		request.addParams("to", buildFieldsParam(friendId));
		request.addParams("message", message);
		new NewUserTask(ctx, new WeakReference<ZaloOpenAPICallback>(callback)).execute(request);
	}

	/**
	 * Send message to friend
	 * http://developers.zaloapp.com/docs/api/open-api/tai-lieu/goi-tin-nhan-toi-ban-be-post-1183
	 * @param context Context
	 * @param friendId Friend ID
	 * @param msg String content message
	 * @param link Link
	 * @param callback ZaloOpenAPICallback
	 */
	public void sendMsgToFriend(Context context, String friendId, String msg, String link, ZaloOpenAPICallback callback){
//		HttpClientRequest request = new HttpClientRequest(Type.POST, "https://graph.zaloapp.com/v2.0/me/message");
		HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_MESSAGE_PATH));
		request.addParams("to", friendId);
		request.addParams("message", msg);
		request.addParams("link", link);
		new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(callback)).execute(request);
	}

	/**
	 * Gởi tin nhắn đến người dùng của bạn qua Official Account được liên kết với ứng dụng. Các tin nhắn phải được gửi theo các mẫu đã được định nghĩa trước. Ứng dụng bên thứ 3 cần liên hệ oa@zaloapp.com  để tạo các mẫu này.
	 * http://developers.zaloapp.com/docs/api/open-api/tai-lieu/goi-tin-nhan-tu-official-account-post-1174
	 * @param context Context
	 * @param templateid Id của mẫu cần gử
	 * @param templatedata Chứa các giá trị sẽ được thay vào mẫu để tạo thành một tin nhắn dạng text. Ví dụ: {“DAY”:”20″,”TIME_24HR”:”17h”}
	 * @param callback ZaloOpenAPICallback
	 */
	public void broadcastViaOfficalAccount(Context context, String templateid, String templatedata, ZaloOpenAPICallback callback){
//		HttpClientRequest request = new HttpClientRequest(Type.POST, "https://graph.zaloapp.com/v2.0/oa/message");
		HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_OA_MESSAGE_PATH));
		request.addParams("templateid", templateid);
		request.addParams("templatedata", templatedata);
		new NewUserTask(context, new WeakReference<ZaloOpenAPICallback>(callback)).execute(request);
	}

	//--new API
	private class NewUserTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {

		Context ctx;
		WeakReference<ZaloOpenAPICallback> mOpenAPICallackAsyn;

		NewUserTask(Context ctx, WeakReference<ZaloOpenAPICallback> _mOpenAPICallackAsyn) {
			this.ctx = ctx;
			mOpenAPICallackAsyn = _mOpenAPICallackAsyn;
		}

		@Override
		protected void onPreExecute() {
			super.onPreExecute();
		}

		@Override
		protected JSONObject doInBackground(HttpClientRequest... requests) {
			HttpClientRequest request = requests[0];

			if (ZaloSDK.Instance.getOAuthCode() == null || ZaloSDK.Instance.getOAuthCode().equals("")) {
				try {
					return new JSONObject("{\"error\":"+ ZaloOAuthResultCode.RESULTCODE_INVALID_OAUTH_CODE+"}");
				} catch (JSONException e) {
					e.printStackTrace();
					return null;
				}
			}

			JSONObject accessToken = getAccessToken(ctx);
			if (accessToken == null) {
				try {
					return new JSONObject("{\"error\":"+ ZaloOAuthResultCode.RESULTCODE_CREATE_ACCESS_TOKEN_FAILED+"}");
				} catch (JSONException e) {
					e.printStackTrace();
					return null;
				}
			} else {
				if (accessToken.has("access_token")) {
					request.addParams("access_token", accessToken.optString("access_token"));
					return request.getJSON();
				} else {
					return accessToken;
				}
			}
		}

		@Override
		protected void onPostExecute(JSONObject object) {
			try {
				if (object != null) {
					if (mOpenAPICallackAsyn != null && mOpenAPICallackAsyn.get() != null)
						mOpenAPICallackAsyn.get().onResult(object);
				} else {
					if (mOpenAPICallackAsyn != null && mOpenAPICallackAsyn.get() != null)
						mOpenAPICallackAsyn.get().onResult(new JSONObject("{\"error\":" + ZaloOAuthResultCode.RESULTCODE_ZALO_UNKNOWN_ERROR + "}"));
				}
			} catch (Exception ex) {
			}
		}
	}
}
