package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.DimenRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import com.zing.zalo.zalosdk.oauth.model.LoginResponse;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class ZaloWebRegisterFragment extends ZaloWebLoginBaseFragment {
	private static final String WEB_REGISTER_PATH = "/v3/auth?app_id=";
	public static final boolean USE_V3 = true;
	private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");

	WebView webView;
	ProgressBar progressBar;
	CookieManager cookieManager;
	CookieSyncManager cookieSyncManager;

	public static ZaloWebRegisterFragment newIstance() {
		ZaloWebRegisterFragment fragment = new ZaloWebRegisterFragment();
		Bundle args = new Bundle();
		fragment.setArguments(args);
		return fragment;
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		cookieSyncManager = CookieSyncManager.createInstance(getActivity());
		cookieManager = CookieManager.getInstance();
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
							 Bundle savedInstanceState) {

		int layoutId = Utils.getResourceId(getContext(), "zalosdk_fragment_zalo_web_login", "layout");
		View view = inflater.inflate(layoutId, container, false);
		setupWebView(view);

		int id = Utils.getResourceId(getContext(), "zalosdk_progress", "id");
		progressBar = view.findViewById(id);
		progressBar.setVisibility(View.GONE);//SOFT_INPUT_ADJUST_PAN

        if(getActivity() != null) {
            if (USE_V3) {
                getActivity().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE |
                        WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
            } else {
                getActivity().getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN |
                        WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
            }
        }

		return view;
	}

	private void setupCookie() {
		if (Build.VERSION.SDK_INT >= 21) {
			cookieManager.setAcceptThirdPartyCookies(webView, true);
		}else {
			cookieManager.setAcceptCookie(true);
		}

		String[] domains = new String[] { "id.zaloapp.com", "id.zalo.me"};
		boolean found = false;
		for(String domain : domains) {
			String cookies = cookieManager.getCookie(domain);
			if(cookies == null || cookies.length() == 0) continue;

			Matcher matcher = WZUIN.matcher(cookies);
			if(matcher.find()) {
				found = true;
				String wzuin = matcher.group(1);
				cookieManager.removeAllCookie();
				cookieManager.setCookie(domain, wzuin);
				Log.i("debuglog", "found set cookie: " + wzuin);
				break;
			}
		}

		if(!found) {
			cookieManager.removeAllCookie();
		}

		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
			cookieManager.flush();
		} else {
			cookieSyncManager.sync();
		}
	}

	private void setupWebView(View parentView) {
		Context context = getContext();
		int id = Utils.getResourceId(context, "zalosdk_login_webview", "id");
		webView = parentView.findViewById(id);

//		setupCookie();
		String callbackUrl = "http://" + AppInfo.getPackageName(context);

		webView.getSettings().setJavaScriptEnabled(true);
		webView.getSettings().setDomStorageEnabled(true);
		webView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
		webView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
		webView.getSettings().setAllowContentAccess(true);

		LoginEventDispacher webClient = new LoginEventDispacher(new WeakReference<>(this), callbackUrl);
		webView.setWebViewClient(webClient);

		try {
			String currentUserAgent = webView.getSettings().getUserAgentString();
			if (currentUserAgent != null && !TextUtils.isEmpty(currentUserAgent)) {
				currentUserAgent += "ZaloSDK";
			} else {
				currentUserAgent = "ZaloSDK";
			}
			webView.getSettings().setUserAgentString(currentUserAgent);
		}catch (Exception ex){
			Log.w(ex.toString());
		}

		if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
			// chromium, enable hardware acceleration
			webView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
		} else {
			// older android version, disable hardware acceleration
			webView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
		}

		String sUrl = generateLoginUrl(context);
		webView.loadUrl(sUrl);
	}

	private String generateLoginUrl(Context ctx) {
		StringBuilder url = new StringBuilder();
		url.append(ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, WEB_REGISTER_PATH));
		try {
			url.append(ZaloSDK.Instance.getAppID());
			url.append("&sign_key=");
			url.append(URLEncoder.encode(
					AppInfo.getApplicationHashKey(ctx), "UTF-8"));
			url.append("&pkg_name=");
			url.append(URLEncoder.encode(
					AppInfo.getPackageName(ctx), "UTF-8"));
			url.append("&orientation=");
			url.append(ctx.getResources().getConfiguration().orientation);
			url.append("&zregister=true");
			url.append("&ts=" + System.currentTimeMillis());
			url.append("&lang=" + com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(ctx));
			url.append("#register");
		} catch (UnsupportedEncodingException e) {
			Log.w(e.getMessage());
		}
		return url.toString();
	}

	@Override
	public void onResume() {
		super.onResume();
		setTitle(getString(Utils.getResourceId(getActivity(), "txt_regis_acc", "string")));
		showBackButton();
	}

	@Override
	protected void onLoginCompleted(LoginResponse response) {
		super.onLoginCompleted(response);
		if (Build.VERSION.SDK_INT >= 21) {
			cookieManager.removeSessionCookies(null);
		}else {
			cookieManager.removeSessionCookie();
		}
	}

	private static class LoginEventDispacher extends WebViewClient {

		private String callbackUrl;
		private WeakReference<ZaloWebRegisterFragment> that;

		public LoginEventDispacher(
				WeakReference<ZaloWebRegisterFragment> that,
				String callbackUrl) {
			this.that = that;
			this.callbackUrl = callbackUrl;
		}

		@Override
		public void onPageFinished(final WebView view, String url) {
			super.onPageFinished(view, url);
			if(that.get() != null) that.get().progressBar.setVisibility(View.GONE);
		}

		@Override
		public void onPageStarted(WebView view, String url, Bitmap favicon) {
			if(that.get() != null) that.get().progressBar.setVisibility(View.VISIBLE);
			if(!(Build.VERSION.SDK_INT < Build.VERSION_CODES.HONEYCOMB && url.indexOf(callbackUrl) == 0)) {
				super.onPageStarted(view, url, favicon);
				return;
			}

			processCallbackUrl(url);
		}

//		@Override
//		public void onReceivedError(WebView view, int errorCode,
//									String description, String failingUrl) {
//			super.onReceivedError(view, errorCode, description, failingUrl);
//
//			if(that.get() != null) {
//				that.get().progressBar.setVisibility(View.GONE);
//				int e = errorCode == -2? ZaloOAuthResultCode.RESULTCODE_ZALO_WEBVIEW_NO_NETWORK: errorCode;
//				that.get().onLoginFailed(e, "", "", "", "web_view");
//			}
//		}

		/** @see {https://developer.android.com/reference/android/webkit/WebViewClient} */
		@Override
		public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
			super.onReceivedError(view, request, error);
			if(that.get() != null) {
				that.get().progressBar.setVisibility(View.GONE);
				int e = -1;
				if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
					e = error.getErrorCode() == -2? ZaloOAuthResultCode.ERR_NO_NETWORK: error.getErrorCode();
				}
				LoginResponse response = new LoginResponse();
				response
						.setError(e)
						.setErrorMsg("")
						.setErrorReason("")
						.setErrorDescription("")
						.setFromSource("web_view");
				that.get().onLoginFailed(response);
			}
		}

		@Override
		public boolean shouldOverrideUrlLoading(WebView view, String url) {
			if(processCallbackUrl(url)) return true;
			return super.shouldOverrideUrlLoading(view, url);
		}

		private boolean processCallbackUrl(String url) {
			if(url.indexOf(callbackUrl) != 0) return false;

			Uri uri = Uri.parse(url);
			int error = Constant.RESULT_CODE_SUCCESSFUL;
			long uid = 0;
			String code = "";
			String name = "";
			int zprotect = 0;
			try {
				if (uri.getQueryParameter("error") != null) {
					error = Integer.parseInt(uri.getQueryParameter("error"));
				} else {
					uid = Long.parseLong(uri.getQueryParameter("uid"));
					code = uri.getQueryParameter("code");
					name = uri.getQueryParameter("display_name");
					String tmp = uri.getQueryParameter("zprotect");
					if(tmp != null) zprotect =  Integer.parseInt(tmp);
				}
			} catch (Exception e) {
				Log.e(e);
			}

			if(that.get() != null) {
				LoginResponse response = new LoginResponse();
				response
						.setError(error)
						.setUid(uid)
						.setOauth(code)
						.setZprotect(zprotect)
						.setName(name)
						.setRegister(false);
				that.get().onLoginCompleted(response);
			}
			return true;
		}
	}
}
