package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONException;
import org.json.JSONObject;

public class BrowserLoginActivity extends Activity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if (handleBrowserCallback()) {
            finish();
        }
    }

    private boolean handleBrowserCallback() {
        Uri data = getIntent().getData();
        if (data == null || data.getQuery() == null) return false;

        String scheme = data.getScheme();
        if (scheme == null || !scheme.startsWith("zalo-" + AppInfo.getAppId(this))) {
            return false;
        }

        Intent intent = new Intent();

        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();

        String sError = data.getQueryParameter("error");
        String code = data.getQueryParameter("code");
        int errorCode = 0;
        try {
            errorCode = Integer.parseInt(sError);
        } catch (Exception ignored) {
        }
        if (sError != null &&  errorCode != 0) {

            intent.putExtra("error", errorCode);

            try {
                String errorMsg = data.getQueryParameter("errorMsg");
                String errorDescription = data.getQueryParameter("error_description");
                String errorReason = data.getQueryParameter("error_reason");

                extraData.put("errorMsg", errorMsg != null ? errorMsg : "");
                extraData.put("error_description", errorDescription != null ? errorDescription : "");
                extraData.put("error_reason", errorReason != null ? errorReason : "");
                extraData.put("from_source", "browser");
                extra.put("data", extraData);
            } catch (JSONException ignored) {
                Log.e("handleBrowserCallback", ignored);
            }

            intent.putExtra("data", extra.toString());
        } else if (code != null) {
            String ext_info = data.getQueryParameter("ext_info");
            String viewer = null;
            String uid = data.getQueryParameter("uid");
            String state = data.getQueryParameter("state");
            JSONObject jsonObject = null;
            if (!TextUtils.isEmpty(ext_info)) {
                try {
                    jsonObject = new JSONObject(ext_info);
                    viewer = jsonObject.getString("viewer");

                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            intent.putExtra("code", code);
            if (!TextUtils.isEmpty(uid)) {
                intent.putExtra("uid", Long.parseLong(uid));
            }
//            if (!TextUtils.isEmpty(viewer)) {
//                intent.putExtra("viewer", viewer);
//            }
//            if (!TextUtils.isEmpty(state)) {
//                intent.putExtra("state", state);
//            }
            try {
                if (!TextUtils.isEmpty(viewer)) {
                    extraData.put("viewer", viewer);
                }
                if (!TextUtils.isEmpty(state)) {
                    extraData.put("state", state);
                }
                extraData.put("display_name", data.getQueryParameter("display_name"));
                extraData.put("scope", data.getQueryParameter("scope"));
                extraData.put("socialId", data.getQueryParameter("socialId"));
                extraData.put("dob", data.getQueryParameter("dob"));
                extraData.put("gender", data.getQueryParameter("gender"));
                extraData.put("from_source", "browser");
                if (jsonObject != null) {
                    extraData.put("ext_info", jsonObject);
                }
                extra.put("data", extraData);

            } catch (JSONException ignored) {
                Log.e("handleBrowserCallback", ignored);
            }

            intent.putExtra("data", extra.toString());
        }

        ZaloSDK.Instance.onActivityResult(this,
            Constant.ZALO_AUTHENTICATE_REQUEST_CODE, 0, intent);
        return true;
    }
}
