package com.zing.zalo.zalosdk.service.client;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;

import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONObject;

import java.util.concurrent.atomic.AtomicInteger;

public class ZaloService {
    public int getUserLoggedStatus(Context context) throws InterruptedException {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalThreadStateException("'isUserLogged' can't run in UI-thread");
        }
        PlatformServiceClient client = new PlatformServiceClient(context, NativeProtocol.CMD_GET_LOGIN_STATUS);
        final AtomicInteger waitingResult = new AtomicInteger(-1);
        client.setCompletedListener(new PlatformServiceClient.CompletedListener() {
            public void completed(Bundle result) {
                if (result != null) {
                    try {
                        if (result.getInt(NativeProtocol.KEY_RESULT_ERROR_CODE) == 0) {
                            JSONObject data = new JSONObject(result.getString(NativeProtocol.KEY_RESULT_DATA));
                            if (data.has("isUserLogged")) {
                                waitingResult.set(data.getBoolean("isUserLogged") ? 1 : 0);
                            }
                        }
                    } catch (Exception e) {
                        Log.e(e);
                    }
                }
                synchronized (waitingResult) {
                    waitingResult.notifyAll();
                }
            }
        });
        if (!client.start()) {
            return -1;
        }
        synchronized (waitingResult) {
            waitingResult.wait(5000);
        }
        return waitingResult.get();
    }
}

