package com.zing.zalo.zalosdk.oauth;

/**
 * Permissions for access user's information 
 */
public enum Permissions {
	/**
	 * Permission to access user's profile
	 */
	ZOP_GetProfile 		("ZOP_GetProfile"),
	/**
	 * Permission to access user's friend list
	 */
	ZOP_GetFriendsList 	("ZOP_GetFriendsList"),
	/**
	 * Permission to push feed on user's wall
	 */
	ZOP_PushFeed 		("ZOP_PushFeed"),
	/**
	 * Permission to send message to user
	 */
	ZOP_SendMessage 	("ZOP_SendMessage");
	
    private final String text;
    private Permissions(final String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        return text;
    }
    
}