package com.zing.zalo.zalosdk.oauth;

import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_UNKNOWN_ERROR;

import android.content.Context;
import android.os.AsyncTask;

import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.type.EventType;
import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public abstract class AuthenExtTask extends AsyncTask<Void, Void, JSONObject> {
  protected Context context;
  private JSONObject appExtInfo;
  private EventType eventType;
  protected AuthenExtTask(Context context, JSONObject appExtInfo, EventType eventType) {
    this.context = context;
    this.appExtInfo = appExtInfo;
    this.eventType = eventType;
  }

  protected abstract String requestUrl();

  protected abstract void customizeParam(HttpClientRequest request);
  protected abstract void customizeEventLog(Map<String, String> params);

  protected HttpClientRequest.Type requestType() {
    return HttpClientRequest.Type.POST;
  }

  protected HttpClientRequest genRequest() {
    HttpClientRequest request = new HttpClientRequest(requestType(), requestUrl());
    request.addParams(Constant.PARAM_APP_ID, String.valueOf(ZaloSDKApplication.appID));
    request.addParams("sign_key", AppInfo.getApplicationHashKey(context));
    request.addParams("pkg_name", AppInfo.getPackageName(context));

    try {
      request.addParams("ext_info", com.zing.zalo.zalosdk.payment.direct.Utils.getExtInfo(appExtInfo, false));
    } catch (UnsupportedEncodingException e) {
      e.printStackTrace();
    } catch (JSONException e) {
      e.printStackTrace();
    }
    return request;
  }
  @Override
  protected JSONObject doInBackground(Void... params) {
    HttpClientRequest request = genRequest();
    customizeParam(request);
    Log.i("debuglog", "link: " + requestUrl());
    try {
      Log.i("debuglog", getClass().getSimpleName() + ": " + request.getJSONString());
    } catch (JSONException e) {
      e.printStackTrace();
    }
    return request.getJSON();
  }

  @Override
  protected void onPostExecute(JSONObject object) {

    Log.i("debuglog" , getClass().getSimpleName()+"--onPostResult-----: " + object);
    try {
      ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onFinishLoading();
    }catch (Exception ignored) {
    }

    int result = 1;
    try {
      int errorCode = object.getInt("error");
      String errorMsg = object.getString("errorMsg") + " " + getClass().getSimpleName();
      if (errorCode == Constant.RESULT_CODE_SUCCESSFUL) {
        ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onRequestAccountProtect(errorCode,errorMsg);
      }else {
        result = 0;
        ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(new ErrorResponse(errorCode, errorMsg));
      }
    }catch (Exception ex) {
      ex.printStackTrace();
      result = 0;
      ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
          new ErrorResponse(ERR_UNKNOWN_ERROR,
              ZaloOAuthResultCode.findErrorMessageByID(context, ERR_UNKNOWN_ERROR)));
    }
    submitEventLog(result);
  }

  protected void submitEventLog(int result) {
    try {
      if (eventType != null) {
        Map<String, String> params = new HashMap<>();
        params.put("result", result+"");
        customizeEventLog(params);
        Utils.addEventZingAnalytics(eventType, params);
      }

    } catch (Exception e) {
    }
  }
}
