package com.zing.zalo.zalosdk.oauth;

import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_INVALID_STATE;
import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_UNKNOWN_ERROR;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.webkit.CookieManager;

import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.ZTaskExecutor;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.core.type.EventType;
import com.zing.zalo.zalosdk.core.type.FromSourceType;
import com.zing.zalo.zalosdk.core.type.PlatformType;
import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;
import com.zing.zalo.zalosdk.payment.direct.Utils;
import com.zing.zalo.zalosdk.service.client.ZaloService;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class Authenticator {

    private WeakReference<OAuthCompleteListener> wListener;
    private WeakReference<OAuthCompleteListener> wLoginFormListener;

    static boolean isGetZaloOAuth = false;
    private boolean bIsZaloLoginSuccessful = false;
    private boolean bIsZaloOutOfDate = false;
    private boolean zaloPluginLogin = false;

    private String codeChallenge;
    private JSONObject appExtInfo;
    public String nameActivtyCheckAuthen = "";

    public BroadcastReceiver receiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            if (Constant.AUTHORIZATION_LOGIN_SUCCESSFUL_ACTION.equals(intent
                    .getAction())) {
                bIsZaloLoginSuccessful = intent.getBooleanExtra(
                        Constant.EXTRA_AUTHORIZATION_LOGIN_SUCCESSFUL, false);
            }
        }
    };

    private OauthStorage mStorage;
    private LocalizedString mLocalizedString;

    protected Context mContext;
    private String state;
    Authenticator(Context ctx, OauthStorage storage, LocalizedString localizedString) {
        mContext = ctx;
        mStorage = storage;
        mLocalizedString = localizedString;
        state = System.currentTimeMillis() + "";
    }

    public OAuthCompleteListener getOAuthCompleteListener() {
        if (wListener != null && wListener.get() != null) {
            return wListener.get();
        }

        return new OAuthCompleteListener();
    }

    public void setOAuthCompleteListener(OAuthCompleteListener listener) {
        wListener = new WeakReference<>(listener);
    }

    protected OAuthCompleteListener getLoginFormOAuthCompleteListener() {
        if (wLoginFormListener != null && wLoginFormListener.get() != null) {
            return wLoginFormListener.get();
        }

        return new OAuthCompleteListener();
    }

    protected void setLoginFormOAuthCompleteListener(OAuthCompleteListener listener) {
        wLoginFormListener = new WeakReference<>(listener);
    }

    void authenticate(final Activity activity, final LoginVia loginVia, String codeChallenge,
                      boolean zaloPluginLogin, JSONObject extInfo, OAuthCompleteListener listener) {
        if (listener == null)
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        this.zaloPluginLogin = zaloPluginLogin;
        this.codeChallenge = codeChallenge;
        this.appExtInfo = extInfo;
        sendOAuthRequest(activity, loginVia);
    }

    void authenticate(final Activity activity, final LoginVia loginVia, String codeChallenge,
                      boolean zaloPluginLogin, OAuthCompleteListener listener) {
        authenticate(activity, loginVia, codeChallenge, zaloPluginLogin, null, listener);
    }

    void registerZalo(final Activity activity, OAuthCompleteListener listener) {
        if (listener == null)
            throw new IllegalArgumentException("OAuthCompleteListener must be set.");
        nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        setOAuthCompleteListener(listener);
        Intent intent;
        try {
            state = System.currentTimeMillis() + "";
            intent = WebLoginActivity.newIntent(activity, true, codeChallenge, Utils.getExtInfo(appExtInfo), state);
            activity.startActivityForResult(intent, Constant.ZALO_AUTHENTICATE_REQUEST_CODE);
        } catch (Exception ex) {
            String errorMessage = ex.getMessage();
            ErrorResponse errorResponse = new ErrorResponse(ERR_UNKNOWN_ERROR,errorMessage,"","", "");
            getOAuthCompleteListener().onAuthenError(errorResponse);
        }
    }

    private void sendOAuthRequest(Activity activity, LoginVia loginVia) {
        boolean isZaloInstalled = AppInfo.isPackageExists(activity, Constant.ZALO_PACKAGE_NAME);

        switch (loginVia) {
            case APP:
                if (isZaloInstalled) {
                    loginViaApp(activity);
                } else {
                    getOAuthCompleteListener().onZaloNotInstalled(activity);
                }

                break;
            case WEB:
                loginViaWeb(activity);
                break;
            case APP_OR_WEB:
                if (isZaloInstalled) {
                    if (SettingsManager.getInstance().isUseWebViewUnLoginZalo(mContext)) {
                        loginViaAppOrWebIfNotLogin(activity);
                    } else {
                        loginViaApp(activity);
                    }
                } else {
                    loginViaWeb(activity);
                }
                break;
//            case IN_APP_WEB:
//                try {
//                    loginViaWebView(activity);
//                } catch (UnsupportedEncodingException | JSONException e1) {
//                }
//                break;
        }
    }

    private void loginViaAppOrWebIfNotLogin(final Activity activity) {
        getZaloLoginStatus(new GetZaloLoginStatus() {
            @Override
            public void onGetZaloLoginStatusCompleted(int status) {
                if (status == 1) {
                    loginViaApp(activity);
                } else {
                    loginViaWeb(activity);
                }
            }
        });
    }

    private void loginViaApp(Activity activity) {
        try {
            try {
                activity.unregisterReceiver(receiver);
            } catch (Exception e) {
                Log.v(e.toString());
            }
            IntentFilter intentFilter = new IntentFilter(Constant.AUTHORIZATION_LOGIN_SUCCESSFUL_ACTION);
            activity.registerReceiver(receiver, intentFilter);

            state = System.currentTimeMillis() + "";
            Intent i = new Intent("com.zing.zalo.intent.action.THIRD_PARTY_APP_AUTHORIZATION");
            i.putExtra(Intent.EXTRA_UID, AppInfo.getAppIdLong(mContext));
            i.putExtra("app_id", AppInfo.getAppIdLong(mContext));
            i.putExtra("code_challenge", codeChallenge);
            i.putExtra("state", state);
            i.putExtra("ext_info",
                ZaloSDK.Instance.getBaseAppInfo().prepareExtraInfo(FromSourceType.ZALO_APP.getCode()).toString());

            activity.startActivityForResult(i, Constant.ZALO_AUTHENTICATE_REQUEST_CODE);

        } catch (ActivityNotFoundException ex) {
            bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        } catch (SecurityException ex) {
            bIsZaloOutOfDate = true;
            getOAuthCompleteListener().onZaloOutOfDate(activity);
        }
    }

    private void loginViaWeb(Activity activity) {
        boolean canUseBrowserLogin = Utilities.canUseBrowserLogin(activity);
        int e = 0;
        String errorMessage = "";
        if (!Utilities.isOnline(activity)) {
            e = ZaloOAuthResultCode.ERR_NO_NETWORK;
        } else {
            try {
                if (canUseBrowserLogin) {
                    loginViaBrowser(activity);
                }
                else {
                    loginViaWebView(activity);
                }
            } catch (UnsupportedEncodingException | JSONException e1) {
                e = ZaloOAuthResultCode.ERR_ZALO_WEBVIEW_COOKIE_ERROR;
                errorMessage = e1.getMessage();
            }
        }

        if (e != 0) {
            errorMessage = TextUtils.isEmpty(errorMessage) ? ZaloOAuthResultCode.findErrorMessageByID(activity, e) : errorMessage;
            String fromSource = canUseBrowserLogin? "browser" : "web_view";
            ErrorResponse errorResponse = new ErrorResponse(e,errorMessage,"","", fromSource);

            getOAuthCompleteListener().onAuthenError(errorResponse);
        }
    }

    private void loginViaBrowser(Activity activity) throws JSONException, UnsupportedEncodingException {
        state = System.currentTimeMillis() + "";
        StringBuilder url = new StringBuilder();
        url.append(ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, "/v4/permission?app_id="));
        url.append(ZaloSDK.Instance.getAppID())
            .append("&sign_key=").append(URLEncoder.encode(AppInfo.getApplicationHashKey(activity), "UTF-8"))
            .append("&pkg_name=").append(URLEncoder.encode(AppInfo.getPackageName(activity), "UTF-8"))
            .append("&os=").append(PlatformType.ANDROID.getCode())
            .append("&state=").append(state)
            .append("&lang=").append(Utils.getLanguage(activity))
            .append("&ref=zsdk")
            .append("&ext_info=").append(Utils.getExtInfo(appExtInfo))
            .append("&code_challenge=").append(codeChallenge);

        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.setData(Uri.parse(url.toString()));
        activity.startActivity(intent);
    }

    //if not check, crash on some device
    private boolean checkCookieManagerSupport() {
        try {
            //check error ABI null in webview
            CookieManager.getInstance();
            return true;
        } catch (Exception ex) {
            return false;
        }
    }

    private void loginViaWebView(Activity activity) throws UnsupportedEncodingException, JSONException {
        if (!checkCookieManagerSupport()) {
            getOAuthCompleteListener().onAuthenError(
                new ErrorResponse(ZaloOAuthResultCode.ERR_ZALO_WEBVIEW_COOKIE_ERROR, "Webview does not support login!")
                );
            return;
        }

        state = System.currentTimeMillis() + "";
        Intent intent = WebLoginActivity.newIntent(activity, false, codeChallenge, Utils.getExtInfo(appExtInfo), state);
        activity.startActivityForResult(intent, Constant.ZALO_AUTHENTICATE_REQUEST_CODE);
    }

    protected void unauthenticate() {
        try {
//            long uid = ZaloSDK.Instance.getZaloId();
//            mContext.getSharedPreferences("zacPref", 0).edit()
//                    .remove("MAX_PAGING" + uid)
//                    .remove("GIFTCODE_EXPIRED_TIME" + uid)
//                    .remove("CACHE_CODE_LIST" + uid)
//                    .remove("CURRENT_PAGE" + uid)
//                    .apply();

//            mStorage.setZaloId(0);
            mStorage.setLoginChannel("");
            mStorage.setZaloDisplayName("");
            mStorage.setSocialId("");
        } catch (Exception ex) {
        }
    }

    boolean isAuthenticate(String refreshToken, ValidateCallback callback) {
        if (refreshToken == null || refreshToken.length() == 0) {
            if (callback != null) {
                callback.onValidateComplete(false,
                    ZaloOAuthResultCode.ERR_INVALID_REFRESH_TOKEN, new OauthResponse().setRefreshToken(refreshToken));
            }
            return false;
        }
        if (callback != null) {
            ValidateRefreshTokenTask task = new ValidateRefreshTokenTask(mContext, refreshToken, callback);
            task.execute();
        }
        return true;
    }

    private void submitEventLoginFail(String type) {
        Map<String, String> params = new HashMap<>();
        params.put("result", "0");
        params.put("type", type);
        com.zing.zalo.zalosdk.core.helper.Utils.addEventZingAnalytics(EventType.AUTHEN, params);
    }

    private void submitEventLoginSuccess(String type) {
        Map<String, String> params = new HashMap<>();
        params.put("result", "1");
        params.put("type", type);
        com.zing.zalo.zalosdk.core.helper.Utils.addEventZingAnalytics(EventType.AUTHEN, params);
    }

    protected boolean onActivityResult(Activity activity, int requestCode,
                                       int resultCode, Intent data) {
        if (requestCode == Constant.ZALO_AUTHENTICATE_REQUEST_CODE) {
            receiveOAuthDataV4(activity, data);
            return true;
        }
//        else if (requestCode == Constant.REQUEST_PERMISSION_REQUEST_CODE) {
//            receivePermissionData(activity, data);
//            return true;
//        }
        return false;
    }

    void receiveOAuthDataV4(Activity activity, Intent data) {
        isGetZaloOAuth = false;
        try {
            activity.unregisterReceiver(receiver);
        } catch (Exception ignored) {
        }

        String type = "1";

        if (bIsZaloOutOfDate) {
            submitEventLoginFail(type);
            return;
        }

        if (data == null) {
            int e = ZaloOAuthResultCode.ERR_USER_BACK;
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(mContext,e);
            ErrorResponse erResponse = new ErrorResponse(e, errorMsg, "", "", "web_login");
            getOAuthCompleteListener().onAuthenError(erResponse);
            submitEventLoginFail(type);
            return;
        }

        int error = data.getIntExtra("error", Constant.RESULT_CODE_SUCCESSFUL);
        if (error == 203) {
            getOAuthCompleteListener().onAuthenError(
                new ErrorResponse(ZaloOAuthResultCode.ERR_WEB_VIEW_LOGIN_NOT_ALLOWED,
                "Không thể đăng nhập Zalo."));
            submitEventLoginFail("2");
        } else if (error == Constant.RESULT_CODE_SUCCESSFUL) {
            long id = data.getLongExtra("uid", 0);
            String oauth = data.getStringExtra("code");
            boolean isRegister = data.getBooleanExtra("isRegister", false);
            String viewer = "";
            String stateReturn = "";
            boolean isV4 = false;
            String rawData = data.getStringExtra("data");
            boolean isWebview = data.getBooleanExtra("isWebview", false);
            try {
                JSONObject jsonObject = new JSONObject(rawData);
                JSONObject dat = jsonObject.getJSONObject("data");
                JSONObject info = dat.optJSONObject("ext_info");
                if (info != null) {
                    isV4 = true;
                }

                if (isV4) {
                    viewer = info.optString("viewer");
                    stateReturn = dat.optString("state", "");
                } else {
                    viewer = dat.optString("viewer");
                    stateReturn = dat.optString("state", null);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }

            if (!validateState(isV4, stateReturn)) {
                Log.e("State invalid");
                getOAuthCompleteListener().onAuthenError(new ErrorResponse(ERR_INVALID_STATE,
                    "Không thể đăng nhập Zalo."));
                submitEventLoginFail(isWebview ? "2" : "1");
                return;
            }
//            if (zaloPluginLogin) {
//                mStorage.setZaloPluginOAuthCode(oauth);
//                mStorage.setZaloPluginUserId(id);
//            }

            if (!zaloPluginLogin ) {
                mStorage.setViewer(viewer);
                mStorage.setLoginChannel(LoginChannel.ZALO.toString());
//                mStorage.setOAuthCode(LoginChannel.ZALO.toString(), oauth);
//                mStorage.setZaloId(id);
                try {
                    String jsData = data.getStringExtra("data");
                    JSONObject exData = new JSONObject(jsData)
                        .getJSONObject("data");
                    String displayname = exData.optString("display_name", "");
                    int zprotect = exData.optInt("zprotect");

                    mStorage.setIsProtected(zprotect);
                    mStorage.setZaloDisplayName(displayname);

                } catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            OauthResponse resp = new OauthResponse(id, oauth, LoginChannel.ZALO);
            resp.raw = rawData;
            resp.setRegister(isRegister);
            getOAuthCompleteListener().onGetOAuthComplete(resp);
            submitEventLoginSuccess(isWebview ? "2" : "1");
        } else if (error == Constant.RESULT_CODE_ZALO_NOT_LOGIN) {
            if (bIsZaloLoginSuccessful) {
                // User just logged in Zalo, try to authenticate again
                authenticate(activity, LoginVia.APP, codeChallenge, zaloPluginLogin, getOAuthCompleteListener());
            } else {
                //user cancel
                getOAuthCompleteListener().onAuthenError(new ErrorResponse(ZaloOAuthResultCode.ERR_USER_BACK, ""));
                submitEventLoginFail("1");
            }
        } else if (error == Constant.RESULTCODE_USER_REJECT || error == Constant.RESULT_CODE_USER_BACK) {
            int e = ZaloOAuthResultCode.findById(error);
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(mContext, error);
            ErrorResponse erResponse = new ErrorResponse(e, errorMsg, "", "", "app");

            getOAuthCompleteListener().onAuthenError(erResponse);
        } else {
            // error happened
            int e = ZaloOAuthResultCode.findById(error);
            String errorMsg = ZaloOAuthResultCode.findErrorMessageByID(mContext, e);
//            String errorMsg = "Không thể đăng nhập Zalo.";

            try {
                String jsData = data.getStringExtra("data");

                if (!TextUtils.isEmpty(jsData)) {
                    JSONObject exData = new JSONObject(jsData);
                    JSONObject extraData = new JSONObject(exData.optString("data"));

                    String msg = extraData.optString("errorMsg");
                    if (!TextUtils.isEmpty(msg)) errorMsg = errorMsg + " " + msg;

                    String errorDescription = extraData.optString("error_description");
                    String errorReason = extraData.optString("error_reason");
                    String fromSource = extraData.optString("from_source");

                    ErrorResponse erResponse = new ErrorResponse(e, errorMsg, errorReason, errorDescription, fromSource);

                    getOAuthCompleteListener().onAuthenError(erResponse);
                }
            } catch (Exception ex) {
                errorMsg = errorMsg + " " + ex.toString();
                Log.v(errorMsg);
            }
            getOAuthCompleteListener().onAuthenError(new ErrorResponse(e, errorMsg));
            boolean isWebview = data.getBooleanExtra("isWebview", false);
            submitEventLoginFail(isWebview ? "2" : "1");
        }
    }

    private boolean validateState(boolean isV4, String state) {
        if (isV4) {
            return this.state != null && this.state.equals(state);
        } else {
            return "".equals(state);
        }
    }

//    private boolean checkZaloVersionSupport(Context ctx, int versionCode) {
//
//        try {
//            PackageInfo manager = ctx.getPackageManager().getPackageInfo(
//                    "com.zing.zalo", 0);
//            if (manager.versionCode < versionCode) {
//                isGetZaloOAuth = false;
//                bIsZaloOutOfDate = true;
//                getOAuthCompleteListener().onZaloOutOfDate(ctx);
//                return false;
//            }
//        } catch (NameNotFoundException e) {
//            // Handle exception
//            isGetZaloOAuth = false;
//            bIsZaloOutOfDate = true;
//            getOAuthCompleteListener().onZaloOutOfDate(ctx);
//            return false;
//        }
//
//        return true;
//    }

//    void requestPermissions(Activity activity, Enum<Permissions> permission,
//                            OAuthCompleteListener listener) {
//
//
//        // Check Zalo version
//        if (!checkZaloVersionSupport(activity, 90)) {
//            return;
//        }
//
//        if (listener == null)
//            throw new IllegalArgumentException(
//                    "OAuthCompleteListener must be set.");
//        setOAuthCompleteListener(listener);
//        Context ctx = activity.getApplicationContext();
//        Intent i = new Intent(
//                "com.zing.zalo.intent.action.THIRD_PARTY_REQ_PERM");
//        i.putExtra("app_id", ZaloSDK.Instance.getAppID() + "");
////        i.putExtra("oauth", ZaloSDK.Instance.getOAuthCode());
//        i.putExtra("pkg_name", AppInfo.getPackageName(ctx));
//        i.putExtra("sign_key", AppInfo.getApplicationHashKey(ctx));
//        i.putExtra("sdk_version", ZaloSDK.Instance.getVersion());
//        i.putExtra("permission", permission.toString());
//        activity.startActivityForResult(i,
//                Constant.REQUEST_PERMISSION_REQUEST_CODE);
//    }

//    void receivePermissionData(Activity activity, Intent data) {
//
//        if (data != null) {
//            int error = data.getIntExtra("error", Constant.RESULT_CODE_SUCCESSFUL);
//            int e = ZaloOAuthResultCode.findById(error);
//            getOAuthCompleteListener().onGetPermissionData(e);
//        } else {
//            // user press back
//            getOAuthCompleteListener().onGetPermissionData(ZaloOAuthResultCode.RESULTCODE_USER_BACK);
//        }
//    }

    void getZaloLoginStatus(final GetZaloLoginStatus callback) {
        if (callback == null) return;
        ZTaskExecutor.queueRunnable(new Runnable() {
            @Override
            public void run() {
                ZaloService service = new ZaloService();
                Handler handler = new Handler(Looper.getMainLooper());
                try {
                    final int status = service.getUserLoggedStatus(mContext);
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            callback.onGetZaloLoginStatusCompleted(status);
                        }
                    });

                } catch (Exception e) {
                    Log.e(e);
                    handler.post(new Runnable() {
                        @Override
                        public void run() {
                            callback.onGetZaloLoginStatusCompleted(-1);
                        }
                    });
                }
            }
        });
    }

    private class ValidateRefreshTokenTask extends AuthenExtTask {
        private final String AUTH_VALIDATE_REFRESHTOKEN_PATH = "/v4/mobile/validate_refresh_token";
        private ValidateCallback callback;
        private String refreshToken;
        protected ValidateRefreshTokenTask(Context context, String refreshToken, ValidateCallback callback) {
            super(context, appExtInfo, null);
            this.refreshToken = refreshToken;
            this.callback = callback;
            if (callback == null)
                throw new IllegalArgumentException("callback can't be null");
        }

        @Override
        protected String requestUrl() {
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_VALIDATE_REFRESHTOKEN_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("refresh_token", refreshToken);
        }

        @Override
        protected void customizeEventLog(Map<String, String> params) {

        }

        @Override
        protected void onPostExecute(JSONObject object) {
            OauthResponse oauthResponse = new OauthResponse();
            oauthResponse.setRefreshToken(refreshToken);
            try {
                int errorCode = object.getInt("error");

                if (errorCode == 0) {

                    JSONObject data = object.getJSONObject("data");
                    oauthResponse.setuId(data.optLong("userId"));
                    oauthResponse.setExpireTime(data.optLong("expires_in"));
                    int zcert = data.optInt("zcert");
                    int zprotect = data.optInt("zprotect");

                    oauthResponse.setZcert(zcert);
//                    if (id == mStorage.getZaloId()) {
//                        int zcert = data.optInt("zcert");
//                        int zprotect = data.optInt("zprotect");
//
////                        mStorage.setIsGuestCertificated(zcert);
////                        mStorage.setIsProtected(zprotect);
//                    }


                    callback.onValidateComplete(true, 0, oauthResponse);
                } else {
                    callback.onValidateComplete(false, errorCode, oauthResponse);
                }

            } catch (Exception ex) {
                callback.onValidateComplete(false, ERR_UNKNOWN_ERROR, oauthResponse);
            }
        }
    }

    public OauthStorage getStorage() {
        return mStorage;
    }

    public void resetListener() {
        wListener = null;
    }
}
