package com.zing.zalo.zalosdk.oauth;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;

import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import android.text.TextUtils;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;

import com.zing.zalo.zalosdk.R;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.oauth.model.LoginResponse;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginBaseFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebLoginFragment;
import com.zing.zalo.zalosdk.oauth.register.ZaloWebRegisterFragment;
import com.zing.zalo.zalosdk.payment.direct.PaymentProcessingDialog;

import org.json.JSONException;
import org.json.JSONObject;

public class WebLoginActivity extends FragmentActivity implements ZaloWebLoginBaseFragment.ZaloWebLoginBaseFragmentListener, OnClickListener{

    ZaloWebLoginFragment loginFragment;
    ZaloWebRegisterFragment registerFragment;
    FrameLayout frameLayout;
    int frameLayoutId;

    PaymentProcessingDialog progressDialog;
    TextView titleView;
    ImageView backButton;
    boolean registerOnly;
    String codeChallenge;
    String state;
    String appExtInfo;
    public static Intent newIntent(Context context,
                                   boolean registerOnly, String codeChallenge,
                                   String appExtInfo, String state) {
        Intent intent = new Intent(context, WebLoginActivity.class);
        intent.putExtra("registerOnly", registerOnly);
        intent.putExtra("codeChallenge", codeChallenge);
        intent.putExtra("appExtInfo", appExtInfo);
        intent.putExtra("state", state);
        return intent;
    }

    @Override
    //This method is required by ZaloSDK
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        ZaloSDK.Instance.onActivityResult(this, requestCode, resultCode, data);
    }

    private void changestatusbarColor(){
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(ContextCompat.getColor(this, R.color.zing_pressed));
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        changestatusbarColor();
        registerOnly = getIntent().getBooleanExtra("registerOnly", false);
        codeChallenge = getIntent().getStringExtra("codeChallenge");
        state = getIntent().getStringExtra("state");
        appExtInfo = getIntent().getStringExtra("appExtInfo");
        //show web login view
        setContentView(Utils.getResourceId(this, "zalosdk_activity_zalo_web_login", "layout"));
        frameLayoutId = Utils.getResourceId(this, "zalosdk_weblogin_container", "id");
        frameLayout = findViewById(frameLayoutId);

        int id =Utils.getResourceId(this, "zalosdk_txt_title", "id");
        titleView = findViewById(id);

        id = Utils.getResourceId(this, "zalosdk_back_control", "id");
        backButton = findViewById(id);
        backButton.setOnClickListener(this);

        if(savedInstanceState == null) {
            if (registerOnly) {
                registerFragment = ZaloWebRegisterFragment.newIstance();
                FragmentManager fragmentManager = getSupportFragmentManager();
                FragmentTransaction transaction = fragmentManager.beginTransaction();
                transaction.replace(frameLayoutId, registerFragment, "register-fragment");
                transaction.commit();
            } else {
                showWebLoginFragment();
            }
        }
    }


    @Override
    public void onClick(View v) {
        if(v == backButton) {
            Utils.hideSoftKeyboard(this);
            onBackPressed();
        }

    }

    @Override
    public void onBackPressed() {
        if(backButton != null && backButton.getVisibility() == View.VISIBLE) {
            super.onBackPressed();
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    private void showWebLoginFragment() {
        loginFragment = ZaloWebLoginFragment.newInstance(codeChallenge, state, appExtInfo);
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.replace(frameLayoutId,  loginFragment, "login-fragment");
        transaction.commitAllowingStateLoss();
    }

    @Override
    public void showLoading() {
        if(progressDialog == null) {
            progressDialog = new PaymentProcessingDialog(this, new PaymentProcessingDialog.OnCloseListener() {
                @Override
                public void onClose() { }
            });
        }

        if(!progressDialog.isShowing()) {
            progressDialog.show();
        }
    }

    @Override
    public void hideLoading() {
        if(progressDialog != null && progressDialog.isShowing()) {
            progressDialog.dismiss();
            progressDialog = null;
        }
    }

    @Override
    public void showMessageDialog(String title, String message) {
        showDialog(this, null, title, message, getString(Utils.getResourceId(this, "txt_close", "string")));
    }

    @Override
    public void setTitle(String title) {
        if(titleView != null) titleView.setText(title);
    }

    @Override
    public void showBackButton() {
        if(backButton != null) backButton.setVisibility(View.VISIBLE);

    }

    @Override
    public void hideBackButton() {
        if(backButton != null) backButton.setVisibility(View.INVISIBLE);
    }

    @Override
    public void onLoginCompleted(LoginResponse response) {
        Intent data = new Intent();
        data.putExtra("error", response.getError());
        data.putExtra("uid", response.getUid());
        data.putExtra("code", response.getOauth());
        data.putExtra("isRegister", response.isRegister());
//        data.putExtra("viewer", response.getViewer());
//        data.putExtra("state", response.getState());
        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();
        try {
            if (!TextUtils.isEmpty(response.getExtInfo())) {
                extraData.put("ext_info", new JSONObject(response.getExtInfo()));
            }
        } catch(JSONException ignored) {

        }
        try {
            extraData.put("viewer", response.getViewer());
            extraData.put("state", response.getState());
            extraData.put("display_name", response.getName());
            extraData.put("zprotect", response.getZprotect());

            extra.put("data", extraData);
        } catch(JSONException ignored) {
            Log.w("onLoginCompleted", ignored);
        }


        data.putExtra("data", extra.toString());
        data.putExtra("isWebview", true);
        setResult(RESULT_OK, data);
        finish();
    }

    @Override
    public void onLoginFailed(LoginResponse response){
        Intent data = new Intent();
        data.putExtra("error", response.getError());

        JSONObject extra = new JSONObject();
        JSONObject extraData = new JSONObject();
        try {
            extraData.put("errorMsg", response.getErrorMsg());
            extraData.put("error_description", response.getErrorDescription());
            extraData.put("error_reason", response.getErrorReason());
            extraData.put("from_source", response.getFromSource());

            extra.put("data", extraData);
        } catch(JSONException ignored) {
            Log.e("onLoginFailed", ignored);
        }


        data.putExtra("data", extra.toString());
        setResult(RESULT_OK, data);
        finish();
    }



    public void showDialog(Activity activity, final OnDialogClickListener listener, final String title, final String msg, final String command){
        showConfirmDialog(activity, listener, title, null, msg, null, command);
    }

    public void showConfirmDialog(Activity activity, final OnDialogClickListener listener, final String tile,
                                  final String phoneNumber, final String content, final String leftCommand, final String rightCommand){
        final Dialog layout = new Dialog(activity);
        layout.requestWindowFeature(Window.FEATURE_NO_TITLE);
        layout.setContentView(R.layout.zalo_web_regis_dialog_confirm);

        Window window = layout.getWindow();
        if(window !=  null) {
            window.setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
        }

        if (!TextUtils.isEmpty(content)){
            ((TextView)layout.findViewById(R.id.content)).setText(content);
        }
        if (TextUtils.isEmpty(tile)){
            layout.findViewById(Utils.getResourceId(activity, "line", "id")).setVisibility(View.GONE);
            layout.findViewById(Utils.getResourceId(activity, "txt_title", "id")).setVisibility(View.GONE);
        } else {
            ((TextView)layout.findViewById(Utils.getResourceId(activity, "txt_title", "id"))).setText(tile);
        }
        if (TextUtils.isEmpty(phoneNumber)){
            layout.findViewById(R.id.phoneNumber).setVisibility(View.GONE);
        } else {
            layout.findViewById(R.id.phoneNumber).setVisibility(View.VISIBLE);
            ((TextView)layout.findViewById(R.id.phoneNumber)).setText(phoneNumber);
        }
        if (TextUtils.isEmpty(rightCommand)){
            layout.findViewById(R.id.btn_add).setVisibility(View.GONE);
        } else {
            ((TextView)layout.findViewById(R.id.btn_add)).setText(rightCommand);
            layout.findViewById(R.id.btn_add).setVisibility(View.VISIBLE);
            layout.findViewById(R.id.btn_add).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    layout.dismiss();
                    if (listener != null){
                        listener.onClickOk();
                    }
                }
            });
        }
        if (TextUtils.isEmpty(leftCommand)){
            layout.findViewById(R.id.btn_cancel).setVisibility(View.GONE);
        } else {
            ((TextView)layout.findViewById(R.id.btn_cancel)).setText(leftCommand);
            layout.findViewById(R.id.btn_cancel).setVisibility(View.VISIBLE);
            layout.findViewById(R.id.btn_cancel).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    layout.dismiss();
                    if (listener != null){
                        listener.onCancel();
                    }
                }
            });
        }
        if ((!TextUtils.isEmpty(leftCommand) && TextUtils.isEmpty(rightCommand))
                || (TextUtils.isEmpty(leftCommand) && !TextUtils.isEmpty(rightCommand))
                ){

            String text = !TextUtils.isEmpty(leftCommand) ? leftCommand : rightCommand;

            layout.findViewById(R.id.btn_cancel).setVisibility(View.GONE);
            layout.findViewById(R.id.btn_add).setVisibility(View.GONE);
            TextView centerButton = layout.findViewById(Utils.getResourceId(activity, "centerbtn", "id"));
            centerButton.setVisibility(View.VISIBLE);
            centerButton.setText(text);
            centerButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    layout.dismiss();
                    if (listener != null){
                        listener.onCancel();
                        listener.onClickOk();
                    }
                }
            });
        }
        layout.show();
    }

    public interface OnDialogClickListener{
        void onCancel();
        void onClickOk();
    }


}
