package com.zing.zalo.zalosdk.oauth;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;

import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest.Type;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.core.type.EventType;
import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;

import org.json.JSONException;
import org.json.JSONObject;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

/**
 * Interface for query Zalo's Open API
 */
class ZaloAPIService {
	private OauthStorage mStorage = null;
	private String mNewUrl = "https://graph.zaloapp.com/v2.0/me";
//	private String mUrl = "http://openapi.zaloapp.com/query";
	public static final String UTF8 = "UTF-8";

	private static final String AUTH_MOBILE_ACCESS_TOKEN_PATH = "/v3/mobile/access_token";
	private static final String GRAPH_OA_MESSAGE_PATH = "/v2.0/oa/message";
	private static final String GRAPH_APP_REQUESTS_PATH = "/v2.0/apprequests";
	private static final String GRAPH_ME_FEED_PATH = "/v2.0/me/feed";
	private static final String GRAPH_ME_MESSAGE_PATH = "/v2.0/me/message";
	private static final String GRAPH_ME_FRIENDS_PATH = "/v2.0/me/friends";
	private static final String GRAPH_ME_INVITABLE_FRIENDS_PATH = "/v2.0/me/invitable_friends";
	private static final String GRAPH_V2_ME_PATH = "/v2.0/me";

	private static final String AUTH_MOBILE_ACCESS_TOKEN_PATH_V4 = "/v4/access_token";

	ZaloAPIService(OauthStorage storage) {
		this.mStorage = storage;
	}

	private String buildFieldsParam(String[] fields){
		if (fields != null && fields.length > 0){
			StringBuffer param = new StringBuffer();
			for (int i = 0; i<fields.length-1; i++){
				param.append(fields[i]).append(",");
			}
			param.append(fields[fields.length-1]);
			return param.toString();
		}
		return "";
	}

	void getProfile(Context ctx, String access_token, ZaloOpenAPICallback callback, String[] fields) {
		validateField(access_token, "access_token must be set.");
		HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_V2_ME_PATH));
		request.addParams("fields", buildFieldsParam(fields));
		request.addHeader("access_token", access_token);
		new RequestAPITask(ctx, callback, EventType.GET_PROFILE).execute(request);
	}
	
	void getFriendListUsedApp(Context ctx, String access_token, int position, int count, ZaloOpenAPICallback callback, String [] fields) {
		validateField(access_token, "access_token must be set.");
		HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_FRIENDS_PATH));
		request.addParams("fields", buildFieldsParam(fields));
		request.addParams("offset", position + "");
		request.addParams("limit", count + "");
		request.addHeader("access_token", access_token);
		new RequestAPITask(ctx, callback, EventType.GET_FRIEND).execute(request);
	}

	void getFriendListInvitable(Context ctx, String access_token, int position, int count, ZaloOpenAPICallback callback, String [] fields) {
		validateField(access_token, "access_token must be set.");
		HttpClientRequest request = new HttpClientRequest(Type.GET, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH,GRAPH_ME_INVITABLE_FRIENDS_PATH ));
		request.addParams("fields", buildFieldsParam(fields));
		request.addParams("offset", position + "");
		request.addParams("limit", count + "");
		request.addHeader("access_token", access_token);
		new RequestAPITask(ctx, callback, EventType.GET_INVITABLE_FRIEND).execute(request);
	}

	/**
	 * https://developers.zalo.me/docs/api/open-api/tai-lieu/moi-su-dung-ung-dung-post-41
	 * @param ctx Context
	 * @param friendId ex: {"friend-id1", "friend-id2", "friend-id3"}
	 * @param message String
	 * @param callback ZaloOpenAPICallback
	 */
	public void inviteFriendUseApp(Context ctx, String access_token, String[] friendId, String message, ZaloOpenAPICallback callback){
		validateField(access_token, "access_token must be set.");
		HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_APP_REQUESTS_PATH));
		request.addParams("to", buildFieldsParam(friendId));
		request.addParams("message", message);
		request.addHeader("access_token", access_token);
		new RequestAPITask(ctx, callback, EventType.SEND_APP_REQUEST).execute(request);
	}

	/**
	 * Send message to friend
	 * https://developers.zalo.me/docs/api/open-api/tai-lieu/goi-tin-nhan-toi-ban-be-post-1183
	 * @param context Context
	 * @param friendId Friend ID
	 * @param msg String content message
	 * @param link Link
	 * @param callback ZaloOpenAPICallback
	 */
	public void sendMsgToFriend(Context context, String access_token, String friendId, String msg, String link, ZaloOpenAPICallback callback){
		validateField(access_token, "access_token must be set.");
		HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_ME_MESSAGE_PATH));
		request.addParams("to", friendId);
		request.addParams("message", msg);
		request.addParams("link", link);
		request.addHeader("access_token", access_token);
		new RequestAPITask(context, callback, EventType.SEND_MSG).execute(request);
	}

	/**
	 * Gởi tin nhắn đến người dùng của bạn qua Official Account được liên kết với ứng dụng. Các tin nhắn phải được gửi theo các mẫu đã được định nghĩa trước. Ứng dụng bên thứ 3 cần liên hệ oa@zaloapp.com  để tạo các mẫu này.
	 * https://developers.zalo.me/docs/api/open-api/tai-lieu/goi-tin-nhan-tu-official-account-post-1174
	 * @param context Context
	 * @param templateid Id của mẫu cần gử
	 * @param templatedata Chứa các giá trị sẽ được thay vào mẫu để tạo thành một tin nhắn dạng text. Ví dụ: {“DAY”:”20″,”TIME_24HR”:”17h”}
	 * @param callback ZaloOpenAPICallback
	 */
	public void broadcastViaOfficalAccount(Context context, String access_token, String templateid, String templatedata, ZaloOpenAPICallback callback){
		validateField(access_token, "access_token must be set.");
		HttpClientRequest request = new HttpClientRequest(Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_GRAPH, GRAPH_OA_MESSAGE_PATH));
		request.addParams("templateid", templateid);
		request.addParams("templatedata", templatedata);
		request.addHeader("access_token", access_token);
		new RequestAPITask(context, callback, EventType.SEND_OA_MSG).execute(request);
	}

	public void getAccessTokenByOAuthCode(Context context, String oauthCode, String codeVerifier, ZaloOpenAPICallback callback) {
		validateField(oauthCode, "oauthCode must be set.");
		validateField(codeVerifier, "codeVerifier must be set.");
		HttpClientRequest request = new HttpClientRequest(
				Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_ACCESS_TOKEN_PATH_V4));

		request.addParams("code", oauthCode);
		request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
		request.addParams("grant_type", ZaloSDK.Instance.getGrantType(true));
		request.addParams("code_verifier", codeVerifier);
		new GetTokenTask(context, callback).execute(request);
	}

	public void getAccessTokenByRefreshToken(Context context, String refresh_token, ZaloOpenAPICallback callback) {
		validateField(refresh_token, "refresh_token must be set.");
		HttpClientRequest request = new HttpClientRequest(
				Type.POST, ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_ACCESS_TOKEN_PATH_V4));

		request.addParams("refresh_token", refresh_token);
		request.addParams("app_id", ZaloSDK.Instance.getAppID() + "");
		request.addParams("grant_type", ZaloSDK.Instance.getGrantType(false));
		new GetTokenTask(context, callback).execute(request);
	}

	private void validateField(String value, String msg) {
		if (TextUtils.isEmpty(value)) {
			throw new IllegalArgumentException(msg);
		}
	}

	private void validateField(String value, ErrorResponse err, ZaloOpenAPICallback callback) {

		if (TextUtils.isEmpty(value)) {
			JSONObject jsonObject = new JSONObject();
			try {
				jsonObject.put("error", err.getErrorCode());
				jsonObject.put("errorMsg", err.getErrorMsg());
				callback.onResult(jsonObject);
			} catch (JSONException e) {
				e.printStackTrace();
			}
		}
	}

	//--new API
	private class GetTokenTask extends AsyncTask<HttpClientRequest, Void, JSONObject> {

		Context ctx;
		ZaloOpenAPICallback mOpenAPICallbackAsync;

		GetTokenTask(Context ctx, ZaloOpenAPICallback _mOpenAPICallbackAsync) {
			this.ctx = ctx;
			mOpenAPICallbackAsync = _mOpenAPICallbackAsync;
		}

		@Override
		protected void onPreExecute() {
			super.onPreExecute();
		}

		@Override
		protected JSONObject doInBackground(HttpClientRequest... requests) {
			JSONObject accessToken;
			HttpClientRequest request = requests[0];
			accessToken = request.getJSON();

			if (accessToken == null) {
				try {
					return new JSONObject("{\"error\":"+ ZaloOAuthResultCode.ERR_CREATE_ACCESS_TOKEN_FAILED+"}");
				} catch (JSONException e) {
					e.printStackTrace();
					return null;
				}
			} else {
				return accessToken;
			}
		}

		@Override
		protected void onPostExecute(JSONObject object) {
			Log.v("GetTokenTask: callback is Null?"+ (mOpenAPICallbackAsync == null));

			try {
				if (object != null) {
					if (mOpenAPICallbackAsync != null) {
						mOpenAPICallbackAsync.onResult(object);
					}
//					if (mOpenAPICallbackAsync != null && mOpenAPICallbackAsync.get() != null)
//						mOpenAPICallbackAsync.get().onResult(object);
				} else {
					if (mOpenAPICallbackAsync != null) {
						mOpenAPICallbackAsync.onResult(new JSONObject("{\"error\":" + ZaloOAuthResultCode.ERR_UNKNOWN_ERROR + "}"));
					}
//					if (mOpenAPICallbackAsync != null && mOpenAPICallbackAsync.get() != null)
//						mOpenAPICallbackAsync.get().onResult(new JSONObject("{\"error\":" + ZaloOAuthResultCode.ERR_UNKNOWN_ERROR + "}"));
				}
			} catch (Exception ex) {
			}
		}
	}

	private class RequestAPITask extends AsyncTask<HttpClientRequest, Void, JSONObject> {

		ZaloOpenAPICallback mOpenAPICallbackAsync;
		EventType eventType;
		RequestAPITask(Context ctx, ZaloOpenAPICallback _mOpenAPICallbackAsync, EventType eventType) {
			mOpenAPICallbackAsync = _mOpenAPICallbackAsync;
			this.eventType = eventType;
		}

		@Override
		protected void onPreExecute() {
			super.onPreExecute();
		}

		@Override
		protected JSONObject doInBackground(HttpClientRequest... requests) {
			HttpClientRequest request = requests[0];
			return request.getJSON();
		}

		@Override
		protected void onPostExecute(JSONObject object) {
			int result = 1;
			Log.v("RequestAPITask: callback is Null?"+ (mOpenAPICallbackAsync == null));
			try {
				if (object == null) {
					result = 0;
					object = new JSONObject("{\"error\":" + ZaloOAuthResultCode.ERR_UNKNOWN_ERROR + "}");
				}

				if (mOpenAPICallbackAsync != null) {
					mOpenAPICallbackAsync.onResult(object);
				}

//				if (mOpenAPICallbackAsync != null && mOpenAPICallbackAsync.get() != null) {
//					mOpenAPICallbackAsync.get().onResult(object);
//				}

			} catch (Exception ex) {
				result = 0;
//				if (mOpenAPICallbackAsync != null && mOpenAPICallbackAsync.get() != null) {
//					mOpenAPICallbackAsync.get().onResult(new JSONObject());
//				}

				if (mOpenAPICallbackAsync != null) {
					mOpenAPICallbackAsync.onResult(new JSONObject());
				}
			}

			try {
				Map<String, String> params = new HashMap<>();
				params.put("result", result+"");
				Utils.addEventZingAnalytics(eventType, params);
			} catch (Exception e) {
			}
		}
	}
}
