package com.zing.zalo.zalosdk.oauth.register;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.core.type.PlatformType;
import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.oauth.ZaloSDK;
import com.zing.zalo.zalosdk.oauth.model.LoginResponse;

import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class ZaloWebLoginFragment extends ZaloWebLoginBaseFragment {
    private static final String WEB_LOGIN_PATH = "/v4/permission?app_id=";

    public static final boolean USE_V3 = true;
    private static final Pattern WZUIN = Pattern.compile("(wzuin=[\\d\\w]*)");

    WebView webView;
    ProgressBar progressBar;
    CookieManager cookieManager;
    CookieSyncManager cookieSyncManager;
    String codeChallenge;
    String state;
    String extInfo;
    public static ZaloWebLoginFragment newInstance(String codeChallenge, String state, String extInfo) {
        ZaloWebLoginFragment fragment = new ZaloWebLoginFragment();
        fragment.codeChallenge = codeChallenge;
        fragment.state = state;
        fragment.extInfo = extInfo;
        Bundle args = new Bundle();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        cookieSyncManager = CookieSyncManager.createInstance(getActivity());
        cookieManager = CookieManager.getInstance();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        int layoutId = Utils.getResourceId(getContext(), "zalosdk_fragment_zalo_web_login", "layout");
        View view = inflater.inflate(layoutId, container, false);
        setupWebView(view);

        int id = Utils.getResourceId(getContext(), "zalosdk_progress", "id");
        progressBar = view.findViewById(id);
        progressBar.setVisibility(View.VISIBLE);//SOFT_INPUT_ADJUST_PAN

        if (getActivity() != null) {
            Window window = getActivity().getWindow();
            if (USE_V3) {
                window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE |
                    WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
            } else {
                window.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN |
                    WindowManager.LayoutParams.SOFT_INPUT_STATE_HIDDEN);
            }
        }

        return view;
    }

    private void setupCookie() {
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.setAcceptThirdPartyCookies(webView, true);
        } else {
            cookieManager.setAcceptCookie(true);
        }

        String[] domains = new String[]{"id.zaloapp.com", "id.zalo.me"};
        boolean found = false;
        for (String domain : domains) {
            String cookies = cookieManager.getCookie(domain);
            if (cookies == null || cookies.length() == 0) continue;
            Matcher matcher = WZUIN.matcher(cookies);
            if (matcher.find()) {
                found = true;
                String wzuin = matcher.group(1);
                cookieManager.removeAllCookie();
                cookieManager.setCookie(domain, wzuin);
                Log.i(">> wzuin: " + wzuin);
                break;
            }
        }

        if (!found) {
            cookieManager.removeAllCookie();
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            cookieManager.flush();
        } else {
            cookieSyncManager.sync();
        }
    }

    private void setupWebView(View parentView) {
        Context context = getContext();
        int id = Utils.getResourceId(context, "zalosdk_login_webview", "id");
        webView = parentView.findViewById(id);

//		setupCookie();
        String callbackUrl = "http://" + AppInfo.getPackageName(context);

        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.getSettings().setCacheMode(WebSettings.LOAD_NO_CACHE);
        webView.getSettings().setRenderPriority(WebSettings.RenderPriority.HIGH);
        webView.getSettings().setAllowContentAccess(true);

        LoginEventDispacher webClient = new LoginEventDispacher(this.getContext(), new WeakReference<>(this), callbackUrl);
        webView.setWebViewClient(webClient);

        try {
            String currentUserAgent = webView.getSettings().getUserAgentString();
            if (currentUserAgent != null && !TextUtils.isEmpty(currentUserAgent)) {
                currentUserAgent += "ZaloSDK";
            } else {
                currentUserAgent = "ZaloSDK";
            }

            currentUserAgent += " " + com.zing.zalo.zalosdk.Constant.VERSION;
            webView.getSettings().setUserAgentString(currentUserAgent);
        } catch (Exception ex) {
            Log.w(ex.getMessage());
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            // chromium, enable hardware acceleration
            webView.setLayerType(View.LAYER_TYPE_HARDWARE, null);
        } else {
            // older android version, disable hardware acceleration
            webView.setLayerType(View.LAYER_TYPE_SOFTWARE, null);
        }


        String url = generateLoginUrl(context);
        webView.loadUrl(url);
    }

    private String generateLoginUrl(Context ctx) {
        StringBuilder url = new StringBuilder();
        url.append(ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, WEB_LOGIN_PATH));
        try {
            url.append(ZaloSDK.Instance.getAppID())
                .append("&sign_key=").append(URLEncoder.encode(AppInfo.getApplicationHashKey(ctx), "UTF-8"))
                .append("&pkg_name=").append(URLEncoder.encode(AppInfo.getPackageName(ctx), "UTF-8"))
                .append("&os=").append(PlatformType.ANDROID.getCode())
                .append("&state=").append(state)
                .append("&lang=").append(com.zing.zalo.zalosdk.payment.direct.Utils.getLanguage(ctx))
                .append("&ext_info=").append(extInfo)
                .append("&code_challenge=").append(codeChallenge);

        } catch (UnsupportedEncodingException e) {
            Log.e(e);
        }
        return url.toString();
    }

    @Override
    public void onResume() {
        super.onResume();
        setTitle(getString(Utils.getResourceId(getActivity(), "txt_title_login_zalo", "string")));
        showBackButton();
    }

    @Override
    protected void onLoginCompleted(LoginResponse response) {
        super.onLoginCompleted(response);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeSessionCookies(null);
        } else {
            cookieManager.removeSessionCookie();
        }
    }

    @Override
    protected void onLoginFailed(LoginResponse response) {
        super.onLoginFailed(response);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeSessionCookies(null);
        } else {
            cookieManager.removeSessionCookie();
        }
    }

    private static class LoginEventDispacher extends WebViewClient {

        private Context context;
        private String callbackUrl;
        private WeakReference<ZaloWebLoginFragment> that;

        public LoginEventDispacher(
            Context context,
            WeakReference<ZaloWebLoginFragment> that,
            String callbackUrl) {
            this.that = that;
            this.callbackUrl = callbackUrl;
            this.context = context;
        }

        @Override
        public void onPageFinished(final WebView view, String url) {
            super.onPageFinished(view, url);
            if (that.get() != null) that.get().progressBar.setVisibility(View.GONE);
        }

        @Override
        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            if (that.get() != null) that.get().progressBar.setVisibility(View.VISIBLE);
            if (!(Build.VERSION.SDK_INT < Build.VERSION_CODES.HONEYCOMB && url.indexOf(callbackUrl) == 0)) {
                super.onPageStarted(view, url, favicon);
                return;
            }


            processCallbackUrl(url);
        }

        @Override
        public void onReceivedError(WebView view, int errorCode,
                                    String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            if (that.get() != null) {
                that.get().progressBar.setVisibility(View.GONE);
            }

            if (that.get() != null) {
                LoginResponse response = new LoginResponse();
                response
                    .setError(-1)
                    .setUid(0)
                    .setOauth("")
                    .setViewer("")
                    .setZprotect(0)
                    .setName("")
                    .setRegister(false);
                that.get().onLoginCompleted(response);
            }


        }

        @Override
        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (processCallbackUrl(url)) return true;
            return super.shouldOverrideUrlLoading(view, url);
        }

        private boolean processCallbackUrl(String url) {
            if (url.indexOf(callbackUrl) != 0) return false;

            Uri uri = Uri.parse(url);
            int error = Constant.RESULT_CODE_SUCCESSFUL;
            Boolean errorFlag = false;

            //response data for success
            long uid = 0;
            String code = "";
            String state = "";
            String name = "";
            String viewer="";
            int zprotect = 0;

            //response data for error
            String errorReason = "";
            String errorDescription = "";
            String errorMsg = "";
            String ext_info = null;
            try {
                if (uri.getQueryParameter("error") != null) {
                    error = Integer.parseInt(uri.getQueryParameter("error"));
                    errorReason = uri.getQueryParameter("error_reason");
                    errorDescription = uri.getQueryParameter("error_description");
                    errorMsg = ZaloOAuthResultCode.findErrorMessageByID(context, error);
                    errorFlag = true;
                } else {

                    code = uri.getQueryParameter("code");
                    state = uri.getQueryParameter("state");
                    ext_info = uri.getQueryParameter("ext_info");

                    if (!TextUtils.isEmpty(ext_info)) {
                        try {
                            JSONObject jsonObject = new JSONObject(ext_info);
                            viewer = jsonObject.getString("viewer");

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    String tmp = uri.getQueryParameter("uid");
                    if (tmp != null) {
                        uid = Long.parseLong(tmp);
                    }
                    name = uri.getQueryParameter("display_name");
                    tmp = uri.getQueryParameter("zprotect");
                    if (tmp != null) {
                        zprotect = Integer.parseInt(tmp);
                    }

                }
            } catch (Exception e) {
                Log.w("processCallbackUrl", e);
                error  =  ZaloOAuthResultCode.ERR_UNKNOWN_ERROR;
                errorMsg = e.toString();
                errorFlag = true;
            }

            if (that.get() != null) {
                LoginResponse response = new LoginResponse();
                if (errorFlag) {
                    String fromSource = "web_login";
                    response
                        .setError(error)
                        .setErrorMsg(errorMsg)
                        .setErrorReason(errorReason)
                        .setErrorDescription(errorDescription)
                        .setFromSource(fromSource);
                    that.get().onLoginFailed(response);
                } else {
                    response
                        .setError(error)
                        .setUid(uid)
                        .setOauth(code)
                        .setViewer(viewer)
                        .setState(state)
                        .setZprotect(zprotect)
                        .setName(name)
                        .setRegister(false);
                    if (!TextUtils.isEmpty(ext_info)) {
                        response.setExtInfo(ext_info);
                    }
                    that.get().onLoginCompleted(response);
                }
            }

            return true;
        }
    }
}