package com.zing.zalo.zalosdk.oauth;

import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_CANT_LOGIN_FACEBOOK;
import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_CANT_LOGIN_GOOGLE;
import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_INVALID_CODE_CHALLENGE;
import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_INVALID_STATE;
import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_NO_NETWORK;
import static com.zing.zalo.zalosdk.ZaloOAuthResultCode.ERR_UNKNOWN_ERROR;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.graphics.Typeface;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.PasswordTransformationMethod;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.TextView;

import com.google.android.gms.auth.api.Auth;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.GoogleSignInResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.zing.zalo.zalosdk.ZaloOAuthResultCode;
import com.zing.zalo.zalosdk.common.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.facebook.DialogError;
import com.zing.zalo.zalosdk.facebook.Facebook;
import com.zing.zalo.zalosdk.facebook.FacebookError;
import com.zing.zalo.zalosdk.facebook.SessionEvents;
import com.zing.zalo.zalosdk.facebook.SessionStore;
import com.zing.zalo.zalosdk.oauth.model.ErrorResponse;
import com.zing.zalo.zalosdk.oauth.AuthenExtTask;
import com.zing.zalo.zalosdk.payment.direct.PaymentProcessingDialog;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;

/**
 * Created by CPU10329-local on 6/28/2017.
 */

public class AuthenticateExtention {

    private Facebook mFacebook;
    private Context mContext;
    GoogleApiClient mGoogleApiClient;
    private String state = "";
    private String refreshToken = "";
    private String code_challenge;
    private JSONObject appExtInfo = null;
    private OauthStorage mStorage;

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setAppExtInfo(JSONObject appExtInfo) {
        this.appExtInfo = appExtInfo;
    }

    public void setCodeChallenge(String code_challenge) {
        this.code_challenge = code_challenge;
    }
    private static final String AUTH_MOBILE_GUEST_PATH = "/v4/mobile/guest";
    private static final String AUTH_MOBILE_ZING_PATH = "/v4/mobile/zing";
    private static final String AUTH_MOBILE_GOOGLE_PATH = "/v4/mobile/google";
    private static final String AUTH_MOBILE_FACEBOOK_PATH = "/v4/mobile/facebook";

    private final String AUTH_FORGOT_PASSWORD_GUEST_PATH = "/v4/mobile/forgot-passwd-guest";
    private final String AUTH_PROTECT_ACCOUNT_PATH = "/v4/mobile/protect-account";
    private final String AUTH_REQ_CERT_GUEST_PATH = "/v4/mobile/req-cert-guest";
    private final String AUTH_RECOVER_GUEST_PATH = "/v4/mobile/recover-guest";


//    private static final String AUTH_MOBILE_GUEST_PATH = "/v2/mobile/guest";
//    private static final String AUTH_MOBILE_ZING_PATH = "/v2/mobile/zing";
//    private static final String AUTH_MOBILE_GOOGLE_PATH = "/v3/mobile/google";
//    private static final String AUTH_MOBILE_FACEBOOK_PATH = "/v2/mobile/facebook";
    //***************Guest**************
    public void authenticateWithGuest(Context context, OAuthCompleteListener listener) {
        ZaloSDK.Instance.checkInitialize();
        _authenticateWithGuest(context, listener);
    }

    protected void requestCertificateGuest(Activity context, String email, String pass,  OAuthCompleteListener listener) {
        _requestCertificateGuest(context, email, pass, listener);
    }

    protected void protectAcc(Activity context, String cmnd, OAuthCompleteListener listener) {
        _protectAcc(context, cmnd, listener);
    }

    public void openProtectGuestDialog(Activity context, OAuthCompleteListener listener) {
        _openProtectGuestDialog(context, listener);
    }

    int w, mBoundedWidth = 900;int width, height;
    void _openProtectGuestDialog (final Activity activity, final OAuthCompleteListener listener) {
        String lastLogin = ZaloSDK.Instance.getLatestLoginChannel();
        if (TextUtils.isEmpty(lastLogin) || !LoginChannel.GUEST.toString().equals(lastLogin)) { return; }
        LayoutInflater inflater = activity.getLayoutInflater();
        View dialoglayout = inflater.inflate(com.zing.zalo.zalosdk.R.layout.protect_acc_guest, null);
        final Dialog dialog = new Dialog(activity, com.zing.zalo.zalosdk.R.style.ProtectAccDialogTheme);
        dialog.setContentView(dialoglayout);
        dialog.setCancelable(false);
        Window window = dialog.getWindow();
        WindowManager wm = (WindowManager) activity.getSystemService(Context.WINDOW_SERVICE);
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR2) {
            Point size = new Point();
            display.getSize(size);
            width = size.x;
            height = size.y;
        }else {
            width = display.getWidth();
            height = display.getHeight();
        }

        if (DeviceHelper.isTablet(activity)) {
            if (width > height) {
                mBoundedWidth = (int) (width * 0.8);
            }else {
                mBoundedWidth = (int) (height * 0.8);
            }
            if (mBoundedWidth>900){
                mBoundedWidth = 900;
            }
        }
        else {
            if (width > height) {
                mBoundedWidth = height + 50;
            } else {
                mBoundedWidth = width - 40;
            }
        }
        window.setLayout((int) (mBoundedWidth), WindowManager.LayoutParams.WRAP_CONTENT);
        final TextView email_guard = ((TextView)dialoglayout.findViewById(com.zing.zalo.zalosdk.R.id.email_guard));
        final TextView pass_guard = ((TextView)dialoglayout.findViewById(com.zing.zalo.zalosdk.R.id.emailPass));
        pass_guard.setTypeface(Typeface.DEFAULT);
        pass_guard.setTransformationMethod(new PasswordTransformationMethod());
        dialog.show();
        dialoglayout.findViewById(com.zing.zalo.zalosdk.R.id.tt_continue_login).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {
                if (listener != null)
                    listener.onSkipProtectAcc(dialog);
            }
        });
        dialoglayout.findViewById(com.zing.zalo.zalosdk.R.id.submit_email_guard).setOnClickListener(new View.OnClickListener() {

            @Override
            public void onClick(View v) {

                String email = email_guard.getText().toString().trim();
                String pass = pass_guard.getText().toString();

                if (TextUtils.isEmpty(email)) {
                    com.zing.zalo.zalosdk.common.Utils.showAlertDialog(activity, "Chưa nhập email", null);
                }
                else if (TextUtils.isEmpty(pass)) {
                    com.zing.zalo.zalosdk.common.Utils.showAlertDialog(activity, "Chưa nhập password", null);
                }
                else {
                    OAuthCompleteListener authCompleteListener = new OAuthCompleteListener() {

                        PaymentProcessingDialog progressDialog;

                        @Override
                        public void onAuthenError(ErrorResponse errorResponse) {
                            super.onAuthenError(errorResponse);
                            if (listener != null)
                                listener.onProtectAccComplete(errorResponse.getErrorCode()
                                    , errorResponse.getErrorMsg(), dialog);
                        }

                        @Override
                        public void onRequestAccountProtect(final int errorCode, final String errorMsg) {
                            if (listener != null)
                                listener.onProtectAccComplete(errorCode, errorMsg, dialog);
                        }

                        @Override
                        public void onStartLoading() {
                            try {

                                progressDialog = new PaymentProcessingDialog(activity, new PaymentProcessingDialog.OnCloseListener() {
                                    @Override
                                    public void onClose() {

                                    }
                                });
                                progressDialog.setTitle("");
                                progressDialog.setCancelable(false);
//								progressDialog.setMessage("Đang xử lý");

                                if (activity != null && !activity.isFinishing()) {
                                    progressDialog.show();
                                }

                            }catch (Exception e) {}

                        }

                        @Override
                        public void onFinishLoading() {
                            try {
                                if( activity != null && !activity.isFinishing() && progressDialog.isShowing()) {
                                    progressDialog.dismiss();
                                }
                            }catch (Exception e) {}

                        }
                    };

                    AuthenticateExtention.this.requestCertificateGuest(activity, email, pass, authCompleteListener);
                }
            }
        });
    }

//    public boolean isGuestAccProtected() {
//        int isGuestCert = getIsGuestCertificated();
//        String loginChannel = ZaloSDK.Instance.getLatestLoginChannel();
//
//        return LoginChannel.GUEST.toString().equals(loginChannel) && isGuestCert == 1;
//    }

    protected void recoveryGuest(Activity context, String email, String pass, OAuthCompleteListener listener) {
        _recoveryGuest(context, email, pass, listener);
    }

    protected void recoveryPassProtectAccountGuest(Activity context, String email, OAuthCompleteListener listener) {
        _recoveryPassGuest(context, email, listener);
    }

//    protected int getIsProtected() {
//        if (ZaloSDK.Instance != null &&
//                ZaloSDK.Instance.getBaseAppInfo() != null)
//            return ZaloSDK.Instance.getBaseAppInfo().getIsProtected();
//        return 0;
//    }

//    protected int getIsGuestCertificated() {
//        if (ZaloSDK.Instance != null)
//            return ZaloSDK.Instance.getIsGuestCertificated();
//        return 0;
//    }

    protected String getGuestDeviceId() {
        if (ZaloSDK.Instance != null)
            return ZaloSDK.Instance.getGuestDeviceId();
        return "";
    }

    void _requestCertificateGuest (Context context, String email, String pass,
                                   final OAuthCompleteListener listener) {
        ZaloSDK.Instance.getAuthenticator().setLoginFormOAuthCompleteListener(listener);
        Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK,
                    ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }

        String zgId = ZaloSDK.Instance.getAuthenticator().getStorage().getGuestDeviceId();
        RequestCertificateGuestTask task = new RequestCertificateGuestTask(ctx, email, pass , zgId);
        task.execute();
    }

    void _protectAcc (Context context, String cmnd,
                      final OAuthCompleteListener listener) {
        ZaloSDK.Instance.getAuthenticator().setLoginFormOAuthCompleteListener(listener);
        Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }
        ProtectAccTask task = new ProtectAccTask(ctx, cmnd);
        task.execute();

    }

    void _recoveryGuest (Context context, String email, String pass,
                         final OAuthCompleteListener listener) {
        ZaloSDK.Instance.getAuthenticator().setLoginFormOAuthCompleteListener(listener);
        Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }
        RecoveryGuestTask task = new RecoveryGuestTask(ctx, email, pass);
        task.execute();
    }

    void _recoveryPassGuest (Context context, String email,	final OAuthCompleteListener listener) {
        ZaloSDK.Instance.getAuthenticator().setLoginFormOAuthCompleteListener(listener);
        Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }
        RecoveryPassGuestTask task = new RecoveryPassGuestTask(ctx, email);
        task.execute();
    }

    void _authenticateWithGuest(Context context,
                               final OAuthCompleteListener listener) {
        validateRequireParams(listener);
        ZaloSDK.Instance.getAuthenticator().nameActivtyCheckAuthen = context.getClass().getSimpleName();
        ZaloSDK.Instance.getAuthenticator().setOAuthCompleteListener(listener);
        Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            listener.onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }
//        String deviceId = ZaloSDK.Instance.getGuestDeviceId();
//        Log.i("debuglog", "authenticate with guest deviceId: " + deviceId);
        AuthenticateWithGuestTask task = new AuthenticateWithGuestTask(ctx);
        task.execute();
    }

    private class AuthenticateWithGuestTask extends AuthenticateTask {

        public AuthenticateWithGuestTask(Context context) {
            super(context, LoginChannel.GUEST);
        }

        @Override
        protected String authenticateUrl() {
//            return Constant.IS_DEV ? "https://dev.oauth.zaloapp.com/v2/mobile/guest" : "https://oauth.zaloapp.com/v2/mobile/guest";
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_GUEST_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            Log.i("debuglog", "login with guest------rtoken: " + refreshToken);
//            request.addParams("zgId", deviceId);
            request.addParams("refresh_token", refreshToken);

        }
    }

    //****************
    public void authenticateWithZingMe(Context context, String username, String password, OAuthCompleteListener listener) {
        ZaloSDK.Instance.checkInitialize();
        _authenticateWithZingMe(context, username, password, listener);
    }

    void _authenticateWithZingMe(Context context, String username,
                                String password, OAuthCompleteListener listener) {
        validateRequireParams(listener);
        ZaloSDK.Instance.getAuthenticator().nameActivtyCheckAuthen = context.getClass().getSimpleName();
        ZaloSDK.Instance.getAuthenticator().setOAuthCompleteListener(listener);
        Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            listener.onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }

        AuthenticateWithZingMeTask task = new AuthenticateWithZingMeTask(
                ctx, username, password);
        task.execute();
    }

    private class AuthenticateWithZingMeTask extends AuthenticateTask {
        private String username;
        private String password;

        AuthenticateWithZingMeTask(Context context, String username,
                                   String password) {
            super(context, LoginChannel.ZINGME);
            this.username = username;
            this.password = password;
        }

        @Override
        protected String authenticateUrl() {
//            return Constant.IS_DEV ?"https://dev.oauth.zaloapp.com/v2/mobile/zing" : "https://oauth.zaloapp.com/v2/mobile/zing";
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_ZING_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("u", username);
            request.addParams("p", Utils.encryptRSA(password));
        }
    }

    public void authenticateWithGooglePlus(Activity context, OAuthCompleteListener listener) {
        mContext = context;
        ZaloSDK.Instance.checkInitialize();
        _authenticateWithGooglePlus(context, listener, 0);
    }

    void _authenticateWithGooglePlus(Activity activity,
                                    OAuthCompleteListener listener, int overrideTheme) {
       validateRequireParams(listener);
        ZaloSDK.Instance.getAuthenticator().nameActivtyCheckAuthen = activity.getClass().getSimpleName();
        ZaloSDK.Instance.getAuthenticator().setOAuthCompleteListener(listener);
        Context ctx = activity.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            listener.onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }
        //new
        GoogleSignInOptions gso = new GoogleSignInOptions.Builder(GoogleSignInOptions.DEFAULT_SIGN_IN)
                .requestIdToken(activity.getString(Utils.getResourceId(activity, "default_web_client_id", "string")))
                .requestEmail()
                .build();
        mGoogleApiClient = new GoogleApiClient.Builder(activity)
                .addApi(Auth.GOOGLE_SIGN_IN_API, gso)
                .build();
        Intent signInIntent = Auth.GoogleSignInApi.getSignInIntent(mGoogleApiClient);
        ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onStartLoading();
        activity.startActivityForResult(signInIntent, Constant.GOOGLE_AUTHENTICATE_REQUEST_CODE);
        Log.i("debuglog", "---_authenticateWithGooglePlus-----");
    }


    /**
     * Authenticate by using facebook account
     * @param context Activity the login activity
     * @param listener OAuthCompleteListener listener to receive authenticate event
     */
    public void authenticateWithFacebook(Activity context, OAuthCompleteListener listener) {
        mContext = context;
        ZaloSDK.Instance.checkInitialize();
        _authenticateWithFacebook(context, listener);
    }

    public boolean onActivityResult(Activity activity, int requestCode,
                             int resultCode, Intent data) {
        if (requestCode == Facebook.DEFAULT_AUTH_ACTIVITY_CODE) {
            if (mFacebook != null) {
                mFacebook.authorizeCallback(requestCode, resultCode, data);
            }
        }else if (requestCode == Constant.GOOGLE_AUTHENTICATE_REQUEST_CODE) {
            ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onFinishLoading();
            if (data != null) {
                Bundle bundle = data.getExtras();
                if (bundle != null) {
                    for (String key : bundle.keySet()) {
                        Log.e("TAG-data", key + " : " + (bundle.get(key) != null ? bundle.get(key) : "NULL"));
                    }
                }
                GoogleSignInResult result = Auth.GoogleSignInApi.getSignInResultFromIntent(data);
                if (result.isSuccess()) {
                    GoogleSignInAccount acct = result.getSignInAccount();
                    String idToken = acct.getIdToken();
                    Log.i("debuglog", "Authenticator.java-----378-----idToken: " + idToken);
                    AuthenticateWithGooglePlusTask task = new AuthenticateWithGooglePlusTask(activity, idToken);
                    task.execute();
                    return true;
                } else {
                    Log.i("debuglog", "Authenticator.java ----line 378 --- result.isSuccess() failed");
                    ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                        new ErrorResponse(ERR_CANT_LOGIN_GOOGLE,
                            ZaloOAuthResultCode.findErrorMessageByID(activity, ERR_CANT_LOGIN_GOOGLE)));
                }
            } else {
                if(resultCode == Activity.RESULT_CANCELED) {
                    ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                        new ErrorResponse(ZaloOAuthResultCode.ERR_USER_REJECT, ""));
                }
                else {
                    ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                        new ErrorResponse(ERR_CANT_LOGIN_GOOGLE,
                            ZaloOAuthResultCode.findErrorMessageByID(activity, ERR_CANT_LOGIN_GOOGLE)));
                }
            }
        }
        return false;
    }

    private class AuthenticateWithGooglePlusTask extends AuthenticateTask {
        private String accessToken;

        public AuthenticateWithGooglePlusTask(Context context,
                                              String accessToken) {
            super(context, LoginChannel.GOOGLE);
            this.accessToken = accessToken;
        }

        @Override
        protected String authenticateUrl() {
//            return Constant.IS_DEV ? "https://dev.oauth.zaloapp.com/v3/mobile/google" : "https://oauth.zaloapp.com/v3/mobile/google";
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_GOOGLE_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("id_token", accessToken);
        }

    }

    public void unauthenticateExtension(){
        //embed fb
        SessionStore.clear(mContext);
    }

    private void validateRequireParams(final OAuthCompleteListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(
                "OAuthCompleteListener must be set.");
        }
        if (TextUtils.isEmpty(code_challenge)) {
            listener.onAuthenError(
                new ErrorResponse(ERR_INVALID_CODE_CHALLENGE,
                    "code challenge must be set.(" + ERR_INVALID_CODE_CHALLENGE +")"));
            throw new IllegalArgumentException(
                "code challenge must be set.(" + ERR_INVALID_CODE_CHALLENGE +")");
        }
    }

    void _authenticateWithFacebook(Activity context,
                                  final OAuthCompleteListener listener) {
        validateRequireParams(listener);

        ZaloSDK.Instance.getAuthenticator().nameActivtyCheckAuthen = context.getClass().getSimpleName();
        ZaloSDK.Instance.getAuthenticator().setOAuthCompleteListener(listener);
        final Context ctx = context.getApplicationContext();
        if (!Utils.isOnline(ctx)) {
            listener.onAuthenError(
                new ErrorResponse(ERR_NO_NETWORK, ZaloOAuthResultCode.findErrorMessageByID(ctx , ERR_NO_NETWORK)));
            return;
        }

        if(ZaloSDKApplication.facebookAppID == null || ZaloSDKApplication.facebookAppID.length() == 0) {
            listener.onAuthenError(
                new ErrorResponse(ERR_CANT_LOGIN_FACEBOOK, "Không tìm thấy meta-data com.facebook.sdk.ApplicationId"));
        }

//		try {
//			Class.forName("com.facebook.Session");
//		} catch(Exception ex) {
//			this.listener.onAuthenError(ZaloOAuthResultCode.RESULTCODE_CANT_LOGIN_FACEBOOK, "Chưa cài đặt FacebookSDK!");
//			return;
//		}



        if(mFacebook == null) {
            mFacebook = new Facebook(context.getApplicationContext(), ZaloSDKApplication.facebookAppID);
            SessionStore.restore(mFacebook, context);
        }

        mFacebook.authorize(new WeakReference<Activity>(context), new String[] { "public_profile", "email"}, Facebook.DEFAULT_AUTH_ACTIVITY_CODE, new Facebook.DialogListener() {
//        mFacebook.authorize(new WeakReference<Activity>(context), new String[] { "public_profile", "email", "user_friends",
//                "user_birthday"}, Facebook.DEFAULT_AUTH_ACTIVITY_CODE, new Facebook.DialogListener() {

            @Override
            public void onFacebookError(FacebookError error) {
                SessionEvents.onLoginError(error.getMessage());
                ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                    new ErrorResponse(ERR_CANT_LOGIN_FACEBOOK,
                        ZaloOAuthResultCode.findErrorMessageByID(ctx, ERR_CANT_LOGIN_FACEBOOK)));
            }

            @Override
            public void onError(DialogError error) {
                SessionEvents.onLoginError(error.getMessage());
                ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                    new ErrorResponse(ERR_CANT_LOGIN_FACEBOOK,
                        ZaloOAuthResultCode.findErrorMessageByID(ctx, ERR_CANT_LOGIN_FACEBOOK)));
            }

            @Override
            public void onComplete(Bundle values) {
                SessionEvents.onLoginSuccess();
                Log.i("debuglog", "accessToken facebook: " + mFacebook.getAccessToken());
                AuthenticateWithFacebookTask task = new AuthenticateWithFacebookTask(
                        ctx, mFacebook.getAccessToken());
                task.execute();
            }

            @Override
            public void onCancel() {
                SessionEvents.onLoginError("Action Canceled");
                ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                    new ErrorResponse(ZaloOAuthResultCode.ERR_USER_REJECT, ""));
            }
        });
    }

    private class AuthenticateWithFacebookTask extends AuthenticateTask {
        private String accessToken;

        public AuthenticateWithFacebookTask(Context context, String accessToken) {
            super(context, LoginChannel.FACEBOOK);
            this.accessToken = accessToken;
        }

        @Override
        protected String authenticateUrl() {
//            return Constant.IS_DEV ? "https://dev.oauth.zaloapp.com/v2/mobile/facebook": "https://oauth.zaloapp.com/v2/mobile/facebook";
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_MOBILE_FACEBOOK_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("access_token", accessToken);
        }

        @Override
        protected void customizeResponse(OauthResponse response) {
            response.setFacebookAccessToken(mFacebook.getAccessToken());
            response.setFacebookExpireTime(mFacebook.getAccessExpires());
        }
    }

    protected abstract class AuthenticateTask extends AsyncTask<Void, Void, JSONObject> {
        protected Context context;
        protected LoginChannel channel;
        protected AuthenticateTask(Context context, LoginChannel channel) {
            this.context = context;
            this.channel = channel;
        }

        @Override
        protected void onPreExecute() {
            //super.onPreExecute();
            ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onStartLoading();
        }

        protected abstract String authenticateUrl();

        protected abstract void customizeParam(HttpClientRequest request);

        protected void customizeResponse(OauthResponse response) { }
        @Override
        protected JSONObject doInBackground(Void... params) {

            if (TextUtils.isEmpty(code_challenge)) {
                JSONObject result = new JSONObject();
                try {
                    result.put("error", ERR_INVALID_CODE_CHALLENGE);
                    result.put("errorMsg", ZaloOAuthResultCode.findErrorMessageByID(context, ERR_INVALID_CODE_CHALLENGE));
                    return result;
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            state = ""+System.currentTimeMillis();
//            Log.i("debuglog", "Authenticator.java-----1243----AuthenticateTask--->doInBackground---");
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.POST,
                    authenticateUrl());
            request.addParams(Constant.PARAM_APP_ID,
                    String.valueOf(ZaloSDKApplication.appID));
//            request.addParams("version", ZaloSDK.Instance.getVersion());
            request.addParams("sign_key",
                    AppInfo.getApplicationHashKey(context));
            request.addParams("pkg_name",
                    AppInfo.getPackageName(context));
//            request.addParams("frm", "sdk");
            try {
                request.addParams("ext_info", com.zing.zalo.zalosdk.payment.direct.Utils.getExtInfo(appExtInfo, false));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            } catch (JSONException e) {
                e.printStackTrace();
            }

            request.addParams("code_challenge", code_challenge);
            request.addParams("state", ""+state);
            customizeParam(request);

            Log.i("debuglog", "authenticateUrl(): " + authenticateUrl());
            try {
                Log.i("debuglog", getClass().getSimpleName() + ": " + request.getJSONString());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return request.getJSON();
        }

        @Override
        protected void onPostExecute(JSONObject object) {
            //super.onPostExecute(result);

            try {
                Log.i("debuglog" , getClass().getSimpleName()+ "-onPostResult: " + object.toString(4));
            } catch (JSONException e) {
                e.printStackTrace();
            }
            try {
                ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onFinishLoading();
            }catch (Exception ignored) {
            }

            try {
                int errorCode = object.getInt("error");
                String errorMsg = object.getString("errorMsg");
                if (errorCode == Constant.RESULT_CODE_SUCCESSFUL) {
                    String zgId = object.optString("zgId");
                    JSONObject data = object.getJSONObject("data");
                    String oauth = data.getString("code");
                    String stateReturn = data.optString("state");
                    JSONObject info = data.optJSONObject("ext_info");
                    if (info != null) {
                        String viewer = info.optString("viewer");
                        if (!TextUtils.isEmpty(viewer)) {
                            if (mStorage == null) {
                                mStorage = new OauthStorage(context);
                            }
                            mStorage.setViewer(viewer);
                        }
                    }
                    if (!AuthenticateExtention.this.state.equals(stateReturn)) {
                        ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                            new ErrorResponse(ERR_INVALID_STATE,
                                ZaloOAuthResultCode.findErrorMessageByID(context, ERR_UNKNOWN_ERROR)));
                        return;
                    }

                    long uid = data.optLong("uid");
                    String name = data.optString("display_name");
                    int zcert = object.optInt("zcert");
                    int zprotect = data.optInt("zprotect");
                    String socialId = data.optString("socialId");
                    String refresh_token = object.optString("refresh_token");

                    OauthStorage storage = ZaloSDK.Instance.getAuthenticator().getStorage();
                    storage.setLoginChannel(channel.toString());
//                    storage.setOAuthCode(channel.toString(), oauth);
//                    storage.setAccessToken("");
//                    storage.setAccessTokenNewAPI("");
//                    storage.setZaloId(uid);
                    storage.setZaloDisplayName(name);
                    storage.setIsProtected(zprotect);
                    storage.setSocialId(socialId);

                    if (this instanceof AuthenticateWithGuestTask) {
                        storage.setGuestDeviceId(zgId);
//                        storage.setIsGuestCertificated(zcert);
                    }

                    OauthResponse response = new OauthResponse();
                    response.raw = object.toString();
                    response.setZcert(zcert);
                    response.setuId(uid);
                    response.setOauthCode(oauth);
                    response.setChannel(channel);
                    response.setRefreshToken(refresh_token);
                    response.setSocialId(socialId);
                    customizeResponse(response);
                    ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onGetOAuthComplete(response);
                } else {
                    int e = ZaloOAuthResultCode.findById(errorCode);
                    ErrorResponse errorResponse = new ErrorResponse(e,errorMsg,"","","");
                    ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(errorResponse);
                }
            } catch (Exception ex) {
                ex.printStackTrace();
                ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                    new ErrorResponse(ERR_UNKNOWN_ERROR,
                        ZaloOAuthResultCode.findErrorMessageByID(context, ERR_UNKNOWN_ERROR)));
            }

            ZaloSDK.Instance.getAuthenticator().resetListener();
        }
    }

    //task for guest
    private class RecoveryPassGuestTask extends AuthenExtTask {
        String email;

        public RecoveryPassGuestTask(Context context, String email) {
            super(context, appExtInfo);
            this.email = email;
        }

        @Override
        protected void onPreExecute() {
            ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onStartLoading();
        }

        @Override
        protected String requestUrl() {
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_FORGOT_PASSWORD_GUEST_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("email", email);
        }

    }


    private class ProtectAccTask extends AuthenExtTask {
        String cmnd;

        public ProtectAccTask(Context context, String cmnd) {
            super(context, appExtInfo);
            this.cmnd = cmnd;
        }

        @Override
        protected String requestUrl() {
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_PROTECT_ACCOUNT_PATH );
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("govId", cmnd);
            request.addParams("refresh_token", refreshToken);
        }

    }
    private class RequestCertificateGuestTask extends AuthenExtTask {
        String email;
        String zgId;
        String pass;
        public RequestCertificateGuestTask(Context context, String email, String pass, String zgId) {
            super(context, appExtInfo);
            this.email = email;
            this.zgId = zgId;
            this.pass = pass;
        }

        @Override
        protected void onPreExecute() {
            ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onStartLoading();
        }

        @Override
        protected String requestUrl() {
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_REQ_CERT_GUEST_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            request.addParams("email", email);
            request.addParams("passwd", Utils.encryptRSA(pass));
            request.addParams("refresh_token", refreshToken);
        }

    }

    private class RecoveryGuestTask extends AuthenExtTask {
        String email;
        String pass;

        public RecoveryGuestTask(Context context, String email, String pass) {
            super(context, appExtInfo);
            this.email = email;
            this.pass = pass;
        }

        @Override
        protected void onPreExecute() {
            ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onStartLoading();
        }

        @Override
        protected String requestUrl() {
            return ServiceMapManager.getInstance().urlFor(ServiceMapManager.KEY_URL_OAUTH, AUTH_RECOVER_GUEST_PATH);
        }

        @Override
        protected void customizeParam(HttpClientRequest request) {
            state = ""+System.currentTimeMillis();
            request.addParams("email", email);
            request.addParams("passwd", Utils.encryptRSA(pass));
            request.addParams("code_challenge", code_challenge);
            request.addParams("state", ""+state);
        }

        @Override
        protected JSONObject doInBackground(Void... params) {

            if (TextUtils.isEmpty(code_challenge)) {
                JSONObject result = new JSONObject();
                try {
                    result.put("error", ERR_INVALID_CODE_CHALLENGE);
                    result.put("errorMsg", ZaloOAuthResultCode.findErrorMessageByID(context, ERR_INVALID_CODE_CHALLENGE));
                    return result;
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            return super.doInBackground(params);
        }

        @Override
        protected void onPostExecute(JSONObject object) {
            try {
                ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onFinishLoading();
            }catch (Exception e) {

            }

            try {
                int errorCode = object.getInt("error");
                String errorMsg = object.getString("errorMsg");
                if (errorCode == Constant.RESULT_CODE_SUCCESSFUL) {

                    String zgId = object.optString("zgId");
                    JSONObject data = object.getJSONObject("data");
                    String oauth = data.getString("code");
                    String stateReturn = data.optString("state");
                    JSONObject info = data.optJSONObject("ext_info");
                    if (info != null) {
                        String viewer = info.optString("viewer");
                        if (!TextUtils.isEmpty(viewer)) {
                            if (mStorage == null) {
                                mStorage = new OauthStorage(context);
                            }
                            mStorage.setViewer(viewer);
                        }
                    }

                    long uid = data.optLong("uid");
                    String name = data.optString("display_name");
                    int zcert = object.optInt("zcert");
                    int zprotect = data.optInt("zprotect");

                    if (!AuthenticateExtention.this.state.equals(stateReturn)) {
                        ZaloSDK.Instance.getAuthenticator().getOAuthCompleteListener().onAuthenError(
                            new ErrorResponse(ERR_INVALID_STATE,
                                ZaloOAuthResultCode.findErrorMessageByID(context, ERR_UNKNOWN_ERROR)));
                        return;
                    }

                    OauthStorage storage = ZaloSDK.Instance.getAuthenticator().getStorage();
                    storage.setLoginChannel(LoginChannel.GUEST.toString());
//                    storage.setOAuthCode(LoginChannel.GUEST.toString(), oauth);
//                    storage.setAccessToken("");
//                    storage.setAccessTokenNewAPI("");
//                    storage.setZaloId(uid);
                    storage.setZaloDisplayName(name);
                    storage.setIsProtected(zprotect);

                    storage.setGuestDeviceId(zgId);
//                    storage.setIsGuestCertificated(zcert);

                    ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().
                        onGetOAuthComplete(new OauthResponse(uid, oauth, LoginChannel.GUEST).setZcert(zcert));
                }else {
                    ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
                        new ErrorResponse(errorCode, errorMsg));
                }
            }catch (Exception ex) {
                ex.printStackTrace();
                ZaloSDK.Instance.getAuthenticator().getLoginFormOAuthCompleteListener().onAuthenError(
                    new ErrorResponse(ERR_UNKNOWN_ERROR,
                        ZaloOAuthResultCode.findErrorMessageByID(context, ERR_UNKNOWN_ERROR)));
            }
        }

    }

}
