package com.zing.zalo.zalosdk.common;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;

import com.zing.zalo.zalosdk.payment.direct.PaymentAlertDialog;
import com.zing.zalo.zalosdk.payment.direct.PaymentAlertDialog.OnOkListener;

public class Utils {

	public static void showAlertDialog(Context context, String mess, OnOkListener listener) {
		PaymentAlertDialog alertDlg = new PaymentAlertDialog(context, listener);
		alertDlg.showAlert(mess);

	}

	public static boolean isPermissionGranted(Context context, String permission) {
		int permissionCheck = -1;
		if (Build.VERSION.SDK_INT >= 23) {
			java.lang.reflect.Method method;
			try {
				method = context.getClass().getMethod("checkSelfPermission", String.class);
				if (method != null) {
					permissionCheck = (Integer) method.invoke(context, permission);
				} else {
					permissionCheck = context.getPackageManager().checkPermission(permission, context.getPackageName());
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			permissionCheck = context.getPackageManager().checkPermission(permission, context.getPackageName());
		}
		if (permissionCheck == PackageManager.PERMISSION_GRANTED) {
			return true;
		}
		return false;
	}

	public static void hideSoftKeyboard(Activity activity) {
		if (activity != null) {
			InputMethodManager inputMethodManager = (InputMethodManager) activity
					.getSystemService(Activity.INPUT_METHOD_SERVICE);
			if (inputMethodManager != null) {
				View focus = activity.getCurrentFocus();
				if (focus != null)
					inputMethodManager.hideSoftInputFromWindow(focus.getWindowToken(),
							InputMethodManager.HIDE_NOT_ALWAYS);
				else
					activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
			}

		}
	}

	public static void setupUIHideKeyBoard(final Activity activity, View view) {

		// Set up touch listener for non-text box views to hide keyboard.
		if (!(view instanceof EditText)) {

			view.setOnTouchListener(new OnTouchListener() {

				@SuppressLint("ClickableViewAccessibility")
				public boolean onTouch(View v, MotionEvent event) {
					Utils.hideSoftKeyboard(activity);
					return false;
				}

			});
		}

		// If a layout container, iterate over children and seed recursion.
		if (view instanceof ViewGroup) {

			for (int i = 0; i < ((ViewGroup) view).getChildCount(); i++) {

				View innerView = ((ViewGroup) view).getChildAt(i);

				setupUIHideKeyBoard(activity, innerView);
			}
		}
	}

	public static boolean isOnline(Context ctx) {
		try {
			if(!isPermissionGranted(ctx, Manifest.permission.ACCESS_WIFI_STATE)) return true;
			ConnectivityManager cm = (ConnectivityManager) ctx.getSystemService(Context.CONNECTIVITY_SERVICE);
			@SuppressLint("MissingPermission") NetworkInfo netInfo = cm.getActiveNetworkInfo();
			if (netInfo != null && netInfo.isConnectedOrConnecting()) {
				return true;
			}
		} catch (Exception e) {
			return true;
		}

		return false;
	}

}
