package com.zing.zalo.zalosdk.core.servicemap;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.GZIPInputStream;


class ServiceMapTools {
    private static String USER_NAME = "ZALO";
    private static String AES_KEY = "zalo@123";

    static String decryptString(String encryptString) throws IOException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
//        String encrypt = FileUtils.readFileToString(new File(fileName));
        byte[] decryptPass = decryptPass(encryptString, USER_NAME, AES_KEY);
        byte[] decompress = decompress(decryptPass);
        return new String(decompress);
//        return null;
    }

    private static byte[] decryptPass(String encrytedStr, String username, String aesKey) throws NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IllegalArgumentException {
        String key = aesKey + username;
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.update(key.getBytes());
        byte[] keyBytes = digest.digest();
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");

        byte[] rawByte = hexToByte(encrytedStr);
        javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance("AES/ECB/NoPadding");
        cipher.init(javax.crypto.Cipher.DECRYPT_MODE, keySpec);

        return cipher.doFinal(rawByte);
    }

    private static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex == null || (hex.length() % 2 != 0))
            throw new IllegalArgumentException("Invalid hex string :" + hex);

        ByteArrayOutputStream bb = new ByteArrayOutputStream();

        for (int i = 0; i < hex.length(); i += 2) {
            bb.write((byte) Integer.parseInt(hex.substring(i, i + 2), 16));
        }
        return bb.toByteArray();
    }

    private static byte[] decompress(byte[] contentBytes) throws IOException {
        ByteArrayOutputStream out = zipInputToByteArrayOutputStream(new GZIPInputStream(new ByteArrayInputStream(contentBytes)));
        return out.toByteArray();
    }

    private static ByteArrayOutputStream zipInputToByteArrayOutputStream(GZIPInputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();

        int len;

        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }

        in.close();
        out.close();
        return out;
    }
}