package com.zing.zalo.zalosdk.core.helper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Base64;

public class BitmapHelper {
	public static Bitmap b64ToImage(String encodedImage) {		
		byte[] decodedString = Base64.decode(encodedImage, Base64.DEFAULT);
		Bitmap decodedByte = BitmapFactory.decodeByteArray(decodedString, 0, decodedString.length);
		return decodedByte;
	}
	
	public static void deleteFilePhoto(String filePath) {
		try {
			File f = new File(filePath);
			if (f != null && f.exists()) {
				f.delete();
			}	
		}catch (Exception e) {
			
		}
		
	}
	
	public static Bitmap rotateImage(Bitmap source, float angle) {

	    Bitmap bitmap = null;
	    Matrix matrix = new Matrix();
	    matrix.postRotate(angle);
	    try {
	        bitmap = Bitmap.createBitmap(source, 0, 0, source.getWidth(), source.getHeight(),
	                matrix, true);
	    } catch (OutOfMemoryError err) {
	        err.printStackTrace();
	    }
	    return bitmap;
	}
	
	public static Bitmap getDownsampledBitmap(Bitmap image, int max_size) {
        if (image == null || image.getWidth() == 0 || image.getHeight() == 0 || max_size < 16) {
            return image;
        }
        int shifts = 0;
        int size = getBitmapSize(image);
        while (size > max_size) {
            shifts++;
            size /= 4;
        }
        Bitmap ret = Bitmap.createScaledBitmap(image, image.getWidth() >> shifts, image.getHeight() >> shifts, true);
        if (ret == null) {
            return null;
        }
        // Handle edge case for rounding.
        if (getBitmapSize(ret) > max_size) {
            return Bitmap.createScaledBitmap(ret, ret.getWidth() >> 1, ret.getHeight() >> 1, true);
        }
        return ret;
    }
	
	public static Bitmap getBitmapReSampleSize (byte[]data, int img_max_size) {
		try{
			BitmapFactory.Options options = new BitmapFactory.Options();
		    options.inJustDecodeBounds = true;
		    BitmapFactory.decodeByteArray(data, 0, data.length, options);
		    int scale = 1;
		    while ((options.outWidth * options.outHeight) * (1 / Math.pow(scale, 2)) > img_max_size) {
		    	scale++;
		    }
		    
		    Bitmap pic = null;
	        if (scale > 1) {
	            scale--;
	            // scale to max possible inSampleSize that still yields an image
	            // larger than target
	            options = new BitmapFactory.Options();
	            options.inSampleSize = scale;
	            pic =  BitmapFactory.decodeByteArray(data, 0, data.length, options);

	            // resize to desired dimensions

	            int width , height;
	            width = options.outWidth;
	            height = options.outHeight;
	            double y = Math.sqrt(img_max_size / (((double) width) / height));
	            double x = (y / height) * width;

	            Bitmap scaledBitmap = Bitmap.createScaledBitmap(pic, (int) x, (int) y, true);
	            pic.recycle();
	            pic = scaledBitmap;
	        } else {
	            pic = BitmapFactory.decodeByteArray(data, 0, data.length);
	        }

	        return pic;
		}catch (Exception e) {
			
		}
		return null;
	}
	
	public static int getBitmapSize(Bitmap bmap) {
        return bmap.getRowBytes() * bmap.getHeight();
    }
	
	public static Bitmap handleSamplingAndRotationBitmap(Context context, Uri selectedImage, int maxWidth, int maxHeight, String fullPath)
	        throws IOException {

	    // First decode with inJustDecodeBounds=true to check dimensions
	    final BitmapFactory.Options options = new BitmapFactory.Options();
	    options.inJustDecodeBounds = true;
	    InputStream imageStream = context.getContentResolver().openInputStream(selectedImage);
	    BitmapFactory.decodeStream(imageStream, null, options);
	    imageStream.close();
	
	    // Calculate inSampleSize
	    options.inSampleSize = calculateInSampleSize(options, maxWidth, maxHeight);
	
	    // Decode bitmap with inSampleSize set
	    options.inJustDecodeBounds = false;
	    imageStream = context.getContentResolver().openInputStream(selectedImage);
	    Bitmap img = BitmapFactory.decodeStream(imageStream, null, options);
	
//	    img = rotateImageIfRequired(img, getRealPathFromURI(context, selectedImage));
		img = rotateImageIfRequired(img, fullPath);
		return img;
	}
	
	static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
		// Raw height and width of image
		final int height = options.outHeight;
		final int width = options.outWidth;
		int inSampleSize = 1;
		
		if (height > reqHeight || width > reqWidth) {
		
			// Calculate ratios of height and width to requested height and width
			final int heightRatio = Math.round((float) height / (float) reqHeight);
			final int widthRatio = Math.round((float) width / (float) reqWidth);
			
			// Choose the smallest ratio as inSampleSize value, this will guarantee a final image
			// with both dimensions larger than or equal to the requested height and width.
			inSampleSize = heightRatio < widthRatio ? heightRatio : widthRatio;
			
			// This offers some additional logic in case the image has a strange
			// aspect ratio. For example, a panorama may have a much larger
			// width than height. In these cases the total pixels might still
			// end up being too large to fit comfortably in memory, so we should
			// be more aggressive with sample down the image (=larger inSampleSize).
			
			final float totalPixels = width * height;
			
			// Anything more than 2x the requested pixels we'll sample down further
			final float totalReqPixelsCap = reqWidth * reqHeight * 2;
			
			while (totalPixels / (inSampleSize * inSampleSize) > totalReqPixelsCap) {
				inSampleSize++;
			}
		}
		return inSampleSize;
	}
	
	static Bitmap rotateImageIfRequired(Bitmap img, String path) throws IOException {

	    ExifInterface ei = new ExifInterface(path);
	    int orientation = ei.getAttributeInt(ExifInterface.TAG_ORIENTATION, ExifInterface.ORIENTATION_NORMAL);

	    switch (orientation) {
	        case ExifInterface.ORIENTATION_ROTATE_90:
	            return rotateImage(img, 90);
	        case ExifInterface.ORIENTATION_ROTATE_180:
	            return rotateImage(img, 180);
	        case ExifInterface.ORIENTATION_ROTATE_270:
	            return rotateImage(img, 270);
	        default:
	            return img;
	    }
	}
	
	private static Bitmap rotateImage(Bitmap img, int degree) {
	    Matrix matrix = new Matrix();
	    matrix.postRotate(degree);
	    Bitmap rotatedImg = Bitmap.createBitmap(img, 0, 0, img.getWidth(), img.getHeight(), matrix, true);
	    img.recycle();
	    return rotatedImg;
	}
	

	public static String getRealPathFromURI(Context ctx, Uri contentURI) {
		String result;
		Cursor cursor = ctx.getContentResolver().query(contentURI, null, null, null, null);
		if (cursor == null) {
			result = contentURI.getPath();
		} else {
			cursor.moveToFirst();
			int idx = cursor.getColumnIndex(MediaStore.Images.ImageColumns.DATA);
			result = cursor.getString(idx);
			cursor.close();
		}
		return result;
	}

	public static byte[] toByteArray(Bitmap bitmap) {
		if(bitmap == null) return new byte[0];
		ByteArrayOutputStream stream = new ByteArrayOutputStream();
		bitmap.compress(Bitmap.CompressFormat.JPEG, 80, stream);
		return stream.toByteArray();
	}
}
