package com.zing.zalo.devicetrackingsdk;

import static com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager.KEY_URL_CENTRALIZED;

import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.text.TextUtils;

import com.zing.zalo.devicetrackingsdk.model.PreloadInfo;
import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientFactory;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.log.Log;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;
import com.zing.zalo.zalosdk.core.type.FromSourceType;
import com.zing.zalo.zalosdk.core.type.PlatformType;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;

class Api {
    String appId;
    String viewer;
    String sdkId;
    boolean isPreInstalled;
    HttpClientFactory requestFactory;

    Api() {
        requestFactory = new HttpClientFactory();
    }

    Api(HttpClientFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public JSONObject prepareExtraInfo(int source){
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("from_source", ""+source);
            jsonObject.put("sdk_ver", ""+Utils.getSDKVersionCode());
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    JSONObject prepareCommonHeaderData(Context context) {
        JSONObject data = new JSONObject();

        try {
            data.put("fs", ""+FromSourceType.SDK.getCode());
            data.put("sdkv", ""+Utils.getSDKVersionCode());
            data.put("av", AppInfo.getVersionName(context));
            data.put("an", AppInfo.getAppName(context));
            data.put("plf", ""+PlatformType.ANDROID.getCode());
            data.put("osv", DeviceHelper.getOSVersion());
            data.put("conn", DeviceHelper.getNetworkType(context));
            data.put("mno", DeviceHelper.getMobileNetworkCode(context));
            data.put("mod", DeviceHelper.getModel());
            data.put("dId", DeviceHelper.getAdvertiseID(context));
        } catch (Exception e) {
            e.printStackTrace();
        }
//        Log.d("DUNGNN1", "common header: " + data.toString());
        return data;
    }


    JSONObject prepareDeviceIdData(Context context) {
        JSONObject data = new JSONObject();

        try {
            data.put("dId", DeviceHelper.getAdvertiseID(context));
            data.put("aId", DeviceHelper.getAndroidId(context));
            data.put("ser", DeviceHelper.getSerial());
            data.put("mod", DeviceHelper.getModel());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return data;
    }

    JSONObject prepareTrackingData(Context context, String currentDeviceId, long ts) {
        JSONObject data = new JSONObject();
        try {
            data.put("pkg", AppInfo.getPackageName(context));
            data.put("pl", "android");
            data.put("osv", DeviceHelper.getOSVersion());
            data.put("sdkv", Utils.getSDKVersion());
            data.put("an", AppInfo.getAppName(context));
            data.put("av", AppInfo.getVersionName(context));
            data.put("dId", DeviceHelper.getAdvertiseID(context));
            data.put("aId", DeviceHelper.getAndroidId(context));
            data.put("ser", DeviceHelper.getSerial());
            data.put("mod", DeviceHelper.getModel());
            data.put("ss", DeviceHelper.getScreenSize(context));
            data.put("mac", DeviceHelper.getWLANMACAddress(context));
            data.put("conn", DeviceHelper.getConnectionType(context));
            data.put("mno", DeviceHelper.getMobileNetworkCode(context));
            if (!TextUtils.isEmpty(currentDeviceId)) {
                data.put("sId", currentDeviceId);
            }
            data.put("adId", DeviceHelper.getAdvertiseID(context));
            data.put("ins_pkg", AppInfo.getInstallerPackageName(context));
            if (!TextUtils.isEmpty(AppInfo.getReferrer(context))) {
                data.put("ref", AppInfo.getReferrer(context));
            }
            data.put("ins_dte", AppInfo.getInstallDate(context));
            data.put("fst_ins_dte", AppInfo.getFirstInstallDate(context));
            data.put("lst_ins_dte", AppInfo.getLastUpdateDate(context));
            data.put("fst_run_dte", AppInfo.getFirstRunDate(context));
            data.put("ts",String.valueOf(ts));
            data.put("brd", DeviceHelper.getBrand());
            data.put("dev", Build.DEVICE);
            data.put("prd", DeviceHelper.getProduct());
            data.put("adk_ver", Build.VERSION.SDK_INT);
            data.put("mnft", DeviceHelper.getManufacturer());
            data.put("dev_type", Build.TYPE);
            data.put("avc", AppInfo.getVersionCode(context));
            data.put("was_ins", String.valueOf(isPreInstalled));
            data.put("lang", Locale.getDefault().toString());
            data.put("dpi", context.getResources().getDisplayMetrics().density);
            PreloadInfo preloadInfo = DeviceHelper.getPreloadInfo(context);
            data.put("preload", preloadInfo.preload);
            data.put("preloadDefault", AppInfo.getPreloadChannel(context));
            if (!preloadInfo.isPreloaded()){
                data.put("preloadFailed", preloadInfo.error);
            }

            Location loc = DeviceHelper.getLocation(context);
            if(loc != null) {
                data.put("lat", String.valueOf(loc.getLatitude()));
                data.put("lng", String.valueOf(loc.getLongitude()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    DeviceIdResponse getDeviceId(Context context, String currentDeviceId) throws JSONException {
        return getDeviceId(context, currentDeviceId, System.currentTimeMillis());
    }


    DeviceIdResponse getDeviceId(Context context, String currentDeviceId, long timestamp) throws JSONException {
        JSONObject deviceIdData = prepareDeviceIdData(context);
        JSONObject trackingData = prepareTrackingData(context, currentDeviceId, timestamp);

        if (sdkId == null) {
            sdkId = "";
        }

        String[]params = {"pl", "appId", "viewer", "device", "data", "ts", "sdkId"};
        String[]values = {"android", appId, viewer,
                deviceIdData.toString(),trackingData.toString(), ""+ timestamp, sdkId};

        String sig = Utils.getSignature(params, values, Constant.TRK_SECRECT_KEY);
        String url = ServiceMapManager.getInstance().urlFor(KEY_URL_CENTRALIZED, Constant.API_HARDWARE_ID_URL);
        HttpClientRequest request = requestFactory.newRequest(HttpClientRequest.Type.POST, url);
        request.addParams("pl", "android");
        request.addParams("appId", appId);
        request.addParams("viewer", viewer);
        request.addParams("device", deviceIdData.toString());
        request.addParams("data", trackingData.toString());
        request.addParams("ts", ""+timestamp);
        request.addParams("sig", sig);
        request.addParams("sdkId", sdkId);


        JSONObject jsonObject = request.getJSON();
        String deviceId;
        long expiredTime;
        if (jsonObject != null) {
            int errorCode = jsonObject.getInt("error");
            if (errorCode == 0) {
                JSONObject data = jsonObject.getJSONObject("data");
                deviceId = data.optString("deviceId");
                expiredTime = data.optLong("expiredTime") + System.currentTimeMillis();

                return new DeviceIdResponse(deviceId, expiredTime);
            }
        }

        return null;
    }

    SDKIdResponse getSdkId(Context context) throws JSONException {
        JSONObject deviceIdData = prepareDeviceIdData(context);

        String url = ServiceMapManager.getInstance().urlFor(KEY_URL_CENTRALIZED, Constant.API_SDK_ID_URL);
        HttpClientRequest request = requestFactory.newRequest(HttpClientRequest.Type.POST, url);
        request.addParams("appId", appId);
        request.addParams("sdkv", Utils.getSDKVersion());
        request.addParams("pl", "android");
        request.addParams("osv", DeviceHelper.getOSVersion());
        request.addParams("model", DeviceHelper.getModel());
        request.addParams("screenSize", DeviceHelper.getScreenSize(context));
        request.addParams("device", deviceIdData.toString());
        request.addParams("ref", AppInfo.getReferrer(context));

        JSONObject jsonObject = request.getJSON();
        String sdkId;
        String privateKey ;
        if (jsonObject != null) {
            int errorCode = jsonObject.getInt("error");
            if (errorCode == 0) {
                JSONObject data = jsonObject.getJSONObject("data");
                sdkId = data.optString("sdkId");
                privateKey = data.optString("privateKey");

                return new SDKIdResponse(sdkId, privateKey);
            }
        }

        return null;
    }

    static class DeviceIdResponse {
        String deviceId;
        long expireTime;

        DeviceIdResponse(String deviceId, long expireTime) {
            this.deviceId = deviceId;
            this.expireTime = expireTime;
        }
    }

    static class SDKIdResponse {
        String sdkId;
        String privateKey;

        SDKIdResponse(String sdkId, String privateKey) {
            this.sdkId = sdkId;
            this.privateKey = privateKey;
        }
    }
}
