package com.zing.zalo.zalosdk;


import android.content.Context;

import com.zing.zalo.zalosdk.core.R;


public class ZaloOAuthResultCode {

    public static final int RESULTCODE_REGIS_IDENTIFY_CARD_NUMBER_SUCCESS = 8000;
    public static final int RESULTCODE_REGIS_CERTIFICATE_GUEST_SUCCESS = 8001;

    public static final int RESULTCODE_NO_ERROR = 0;
//    public static final int RESULTCODE_PERMISSION_DENIED = -201;//
//    public static final int RESULTCODE_USER_BACK = -1111; //
//    public static final int RESULTCODE_USER_REJECT = -1114;//
//    public static final int RESULTCODE_ZALO_UNKNOWN_ERROR = -1112;//
//    public static final int RESULTCODE_ZALO_WEB_VIEW_LOGIN_NOT_ALLOWED = -1118;//
//    public static final int RESULTCODE_UNEXPECTED_ERROR = -1000;//
//    public static final int RESULTCODE_INVALID_APP_ID = -1001;//
//    public static final int RESULTCODE_INVALID_PARAM = -1002;//
//    public static final int RESULTCODE_INVALID_SECRET_KEY = -1003;//
//    public static final int RESULTCODE_INVALID_OAUTH_CODE = -1004;//
//    public static final int RESULTCODE_ACCESS_DENIED = -1005;//
//    public static final int RESULTCODE_INVALID_SESSION = -1006;//
//    public static final int RESULTCODE_CREATE_OAUTH_FAILED = -1007;//
//    public static final int RESULTCODE_CREATE_ACCESS_TOKEN_FAILED = -1008;//
//    public static final int RESULTCODE_USER_CONSENT_FAILED = -1009;//
//    public static final int RESULTCODE_APPLICATION_IS_NOT_APPROVED = -1014;//
//    public static final int RESULTCODE_ZALO_OAUTH_INVALID = -1019;//
//    public static final int RESULTCODE_ZALO_WEBVIEW_COOKIE_ERROR = -1020;//
//    public static final int RESULTCODE_ZALO_WEBVIEW_NO_NETWORK = -1021;//
//    public static final int RESULTCODE_ZALO_SDK_NO_INTERNET_ACCESS = -1022;//
//
//    public static final int RESULTCODE_ZALO_APPLICATION_NOT_INSTALLED = -1024;
//    public static final int RESULTCODE_ZALO_OUT_OF_DATE = -1025;
//
//    public static final int RESULTCODE_CANT_LOGIN_ZINGME = -1023;
//    public static final int RESULTCODE_CANT_LOGIN_FACEBOOK = -1105;
//    public static final int RESULTCODE_CANT_LOGIN_GOOGLE = -1205;

    //v4
    public static final int ERR_APP_ID_IS_INVALID = -5000;
    public static final int ERR_INVALID_CALLBACK_URL = -5001;
    public static final int ERR_INVALID_CLIENT_SECRET = -5002;
    public static final int ERR_INVALID_OAUTHORIZED_CODE = -5003;
    public static final int ERR_INVALID_ACCESS_TOKEN = -5004;
    public static final int ERR_INVALID_IOS_BUNDLE_ID = -5005;
    public static final int ERR_INVALID_ANDROID_PACKAGE = -5006;
    public static final int ERR_INVALID_SESSION = -5007;
    public static final int ERR_INVALID_ANDROID_SIGN_KEY = -5008;
    public static final int ERR_INVALID_CODE_CHALLENGE = -5009;
    public static final int ERR_INVALID_CODE_VERIFIER = -5010;
    public static final int ERR_INVALID_REFRESH_TOKEN = -5011;
    public static final int ERR_INVALID_OA_ID = -5012;
    public static final int ERR_INVALID_BODY_DATA = -5013;
    public static final int ERR_INVALID_REQUIRED_PARAMS = -5014;
    public static final int ERR_INVALID_GRANT_TYPE = -5015;
    public static final int ERR_AUTHORIZED_CODE_EXPIRED = -5016;
    public static final int ERR_REFRESH_TOKEN_EXPIRED = -5017;
    public static final int ERR_INVALID_STATE = -5018;
    public static final int ERR_REFRESH_TOKEN_NOT_GUEST_CHANNEL = -5019;

    public static final int ERR_USER_IS_INVALID = -6000;
    public static final int ERR_INVALID_PERMISSION = -6001;
    public static final int ERR_USER_NOT_LOGIN = -6002;
    public static final int ERR_USER_NOT_CONSENT = -6003;
    public static final int ERR_USER_NOT_OWN_OA = -6004;
    public static final int ERR_USER_BANNED = -6005;

    public static final int ERR_INVALID_CSRF_TOKEN = -7000;
    public static final int ERR_CREATE_ACCESS_TOKEN_FAILED = -7001;
    public static final int ERR_CREATE_OAUTH_FAILED = -7002;
    public static final int ERR_VERIFY_SESSION_USER_FAIL = -7003;
    public static final int ERR_APPLICATION_IS_NOT_APPROVED = -7004;
    public static final int ERR_FORGOT_PASSWD_GUEST_ACC_FAILED = -7005;
    public static final int ERR_BUILD_REDIRECT_URI_FAILED = -7006;
    public static final int ERR_WEB_VIEW_LOGIN_NOT_ALLOWED = -7007;
    public static final int ERR_USER_BACK = -7008;
    public static final int ERR_USER_REJECT = -7009;
    public static final int ERR_ZALO_WEBVIEW_COOKIE_ERROR = -7010;
    public static final int ERR_CANT_LOGIN_GOOGLE = -7011;
    public static final int ERR_CANT_LOGIN_FACEBOOK = -7012;
    public static final int ERR_CANT_LOGIN_ZINGME = -7013;
    public static final int ERR_ZALO_APP_NOT_INSTALLED = -7014;
    public static final int ERR_ZALO_OUT_OF_DATE = -7015;

    public static final int ERR_UNKNOWN_ERROR = -8000;
    public static final int ERR_NO_NETWORK = -8001;

    public static final int ERR_INVALID_PARAMETER = -9000;
    public static final int ERR_INVALID_USER_ID = -9001;
    public static final int ERR_CANT_RESOLVE_TO_A_VALID_USER_ID = -9002;
    public static final int ERR_YOUR_APP_DONT_LINK_WITH_ANY_OFFICIAL_ACCOUNT = -9003;
    public static final int ERR_USER_NOT_VISIBLE = -9004;
    public static final int ERR_REQUIRES_THE_EXTENDED_PERMISSION = -9005;
    public static final int ERR_SESSION_KEY_INVALID = -9006;
    public static final int ERR_REQUESTS_DISABLED_FOR_THIS_APP = -9007;
    public static final int ERR_SYNTAX_ERROR = -9008;
    public static final int ERR_CALL_FAIL = -9009;
    public static final int ERR_METHOD_IS_NOT_SUPPORT_FOR_THIS_API = -9010;
    public static final int ERR_UNKOWN_EXCEPTION = -9011;
    public static final int ERR_ITEM_NOT_EXITS = -9012;
    public static final int ERR_APP_ID_IN_USE_IS_DISABLED_OR_BANDED = -9013;
    public static final int ERR_QUOTA_FOR_YOUR_APP_IS_LIMITED = -9014;
    public static final int ERR_LIMIT_OF_FRIENDS_LIST_IS_TOO_LARGE = -9015;
    public static final int ERR_QUOTA_DAILY_FOR_YOUR_APP_IS_LIMITED = -9016;
    public static final int ERR_QUOTA_WEEKY_FOR_YOUR_APP_IS_LIMITED = -9017;
    public static final int ERR_QUOTA_MONTHLY_FOR_YOUR_APP_IS_LIMITED = -9018;
    public static final int ERR_QUOTA_MONTHLY_FOR_YOUR_APP_IS_LIMITED2 = -9019;
    public static final int ERR_USER_HAS_NOT_PLAYED_GAME_FOR_30_DAYS_AGO = -9020;
    public static final int ERR_DO_NOT_DISTURB_USER = -9021;
    public static final int ERR_RECIPIENT_WAS_REACHED_QUOTA_MESSAGE_RECIEVE = -9022;
    public static final int ERR_SENDER_AND_RECIPIENT_IS_NOT_FRIEND = -9023;
    public static final int ERR_QUOTA_DAILY_PER_USER_FOR_YOUR_APP_IS_LIMITED = -9024;
    public static final int ERR_YOUR_FRIEND_IS_NOT_USING_APP = -9025;
    public static final int ERR_YOUR_FRIEND_IS_USING_APP = -9026;

    public static int findById(int rawCode) {
        switch (rawCode) {
            case 0:
                return RESULTCODE_NO_ERROR;
            case -14048:
                return ERR_REFRESH_TOKEN_NOT_GUEST_CHANNEL;
            case -14002:
            case -1001:
                return ERR_APP_ID_IS_INVALID;
            case -14003:
                return ERR_INVALID_CALLBACK_URL;
            case -14004:
            case -1003:
                return ERR_INVALID_CLIENT_SECRET;
            case -14005:
            case -1004:
            case -1019:
                return ERR_INVALID_OAUTHORIZED_CODE;
            case -14009:
                return ERR_INVALID_ANDROID_PACKAGE;
            case -14010:
                return ERR_INVALID_SESSION;
            case -14011:
                return ERR_INVALID_ANDROID_SIGN_KEY;
            case -14012:
                return ERR_INVALID_CODE_CHALLENGE;
            case -14013:
                return ERR_INVALID_CODE_VERIFIER;
            case -14014:
                return ERR_INVALID_REFRESH_TOKEN;
            case -14015:
                return ERR_INVALID_OA_ID;
            case -14016:
                return ERR_INVALID_BODY_DATA;
            case -14017:
            case -1002:
                return ERR_INVALID_REQUIRED_PARAMS;
            case -14018:
                return ERR_INVALID_GRANT_TYPE;
            case -14019:
                return ERR_AUTHORIZED_CODE_EXPIRED;
            case -14020:
                return ERR_REFRESH_TOKEN_EXPIRED;
            case -14006:
            case -1005:
            case -201:
                return ERR_USER_IS_INVALID;
            case -14021:
                return ERR_INVALID_PERMISSION;
            case -14022:
            case 4:
                return ERR_USER_NOT_LOGIN;
            case -14023:
            case -1009:
                return ERR_USER_NOT_CONSENT;
            case -14024:
                return ERR_USER_NOT_OWN_OA;
            case -14025:
                return ERR_USER_BANNED;
            case -14007:
                return ERR_INVALID_CSRF_TOKEN;
            case -14026:
            case -1008:
                return ERR_CREATE_ACCESS_TOKEN_FAILED;
            case -14027:
            case -1007:
                return ERR_CREATE_OAUTH_FAILED;
            case -14028:
            case -1006:
                return ERR_VERIFY_SESSION_USER_FAIL;
            case -14029:
            case -1014:
                return ERR_APPLICATION_IS_NOT_APPROVED;
            case -14030:
                return ERR_FORGOT_PASSWD_GUEST_ACC_FAILED;
            case -14031:
                return ERR_BUILD_REDIRECT_URI_FAILED;
            case -1118:
                return ERR_WEB_VIEW_LOGIN_NOT_ALLOWED;
            case -1111:
            case 2:
                return ERR_USER_BACK;
            case -1114:
            case 3:
                return ERR_USER_REJECT;
            case -1020:
                return ERR_ZALO_WEBVIEW_COOKIE_ERROR;
            case -1205:
                return ERR_CANT_LOGIN_GOOGLE;
            case -1105:
                return ERR_CANT_LOGIN_FACEBOOK;
            case -1023:
                return ERR_CANT_LOGIN_ZINGME;
            case -1024:
                return ERR_ZALO_APP_NOT_INSTALLED;
            case -1025:
                return ERR_ZALO_OUT_OF_DATE;
            case -14001:
            case -1112:
            case -1000:
            case 1:
                return ERR_UNKNOWN_ERROR;
            case -1021:
            case -1022:
                return ERR_NO_NETWORK;
            case 100:
                return ERR_INVALID_PARAMETER;
            case 110:
                return ERR_INVALID_USER_ID;
            case 111:
                return ERR_CANT_RESOLVE_TO_A_VALID_USER_ID;
            case 112:
                return ERR_YOUR_APP_DONT_LINK_WITH_ANY_OFFICIAL_ACCOUNT;
            case 210:
                return ERR_USER_NOT_VISIBLE;
            case 289:
                return ERR_REQUIRES_THE_EXTENDED_PERMISSION;
            case 452:
                return ERR_SESSION_KEY_INVALID;
            case 2004:
                return ERR_REQUESTS_DISABLED_FOR_THIS_APP;
            case 2500:
                return ERR_SYNTAX_ERROR;
            case 10000:
                return ERR_CALL_FAIL;
            case 10001:
                return ERR_METHOD_IS_NOT_SUPPORT_FOR_THIS_API;
            case 10002:
                return ERR_UNKOWN_EXCEPTION;
            case 10003:
                return ERR_ITEM_NOT_EXITS;
            case 11004:
                return ERR_APP_ID_IN_USE_IS_DISABLED_OR_BANDED;
            case 12000:
                return ERR_QUOTA_FOR_YOUR_APP_IS_LIMITED;
            case 12001:
                return ERR_LIMIT_OF_FRIENDS_LIST_IS_TOO_LARGE;
            case 12002:
                return ERR_QUOTA_DAILY_FOR_YOUR_APP_IS_LIMITED;
            case 12003:
                return ERR_QUOTA_WEEKY_FOR_YOUR_APP_IS_LIMITED;
            case 12004:
                return ERR_QUOTA_MONTHLY_FOR_YOUR_APP_IS_LIMITED;
            case 12005:
                return ERR_QUOTA_MONTHLY_FOR_YOUR_APP_IS_LIMITED2;
            case 12006:
                return ERR_USER_HAS_NOT_PLAYED_GAME_FOR_30_DAYS_AGO;
            case 12007:
                return ERR_DO_NOT_DISTURB_USER;
            case 12008:
                return ERR_RECIPIENT_WAS_REACHED_QUOTA_MESSAGE_RECIEVE;
            case 12009:
                return ERR_SENDER_AND_RECIPIENT_IS_NOT_FRIEND;
            case 12010:
                return ERR_QUOTA_DAILY_PER_USER_FOR_YOUR_APP_IS_LIMITED;
            case 12011:
                return ERR_YOUR_FRIEND_IS_NOT_USING_APP;
            case 12012:
                return ERR_YOUR_FRIEND_IS_USING_APP;
            default:
                return rawCode;
        }
    }

    public static String findErrorMessageByID(Context context, int rawCode) {
        String msg;
        int errorCode = findById(rawCode);
        switch (errorCode) {
            case ERR_UNKNOWN_ERROR:
                msg = context.getString(R.string.unknown_error);
                break;
            case ERR_USER_BACK:
            case ERR_USER_IS_INVALID:
            case ERR_USER_REJECT:
                msg = "";
                break;
            case ERR_NO_NETWORK:
                msg = context.getString(R.string.no_network);
                break;
            case ERR_ZALO_APP_NOT_INSTALLED:
                msg = context.getString(R.string.zalo_app_not_installed);
                break;
            case ERR_ZALO_OUT_OF_DATE:
                msg = context.getString(R.string.zalo_app_out_of_date);
                break;
            case ERR_CANT_LOGIN_GOOGLE:
                msg = context.getString(R.string.cant_login_gg);
                break;
            case ERR_CANT_LOGIN_FACEBOOK:
                msg = context.getString(R.string.cant_login_fb);
                break;
            case ERR_REFRESH_TOKEN_NOT_GUEST_CHANNEL:
                msg = context.getString(R.string.refresh_token_not_guest_channel);
                break;
            default:
                msg = context.getString(R.string.cant_login_zalo);
        }
        return msg;
    }
}

//    public static final ErrorObject SUCCESS = new ErrorObject("Success", 0, "Action had been proceed successfully", "");
//    public static final ErrorObject ERROR_DEFAULT = new ErrorObject("Error occured", -64536, "There was an unknown error", "");
//    public static final ErrorObject CLIENT_ID_INVALID = new ErrorObject("Invalid Parameter", -64535, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_REDIRECT_URI = new ErrorObject("Invalid Parameter", -64534, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_CLIENT_SECRET = new ErrorObject("Invalid Parameter", -64533, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_AUTHORIZED_CODE = new ErrorObject("Invalid Parameter", -64532, "Invalid Parameter", "");
//    public static final ErrorObject USER_DENIED = new ErrorObject("access_denied", -64531, "permission_error", "");
//    public static final ErrorObject INVALID_CSRF_TOKEN = new ErrorObject("Invalid Parameter", -64526, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_IOS_BUNDLE_ID = new ErrorObject("Invalid Parameter", -64524, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_ANDROID_PACKAGE = new ErrorObject("Invalid Parameter", -64523, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_SESSION = new ErrorObject("Invalid Session", -64522, "Invalid Session", "");
//    public static final ErrorObject INVALID_ANDROID_SIGN_KEY = new ErrorObject("Invalid Parameter", -64498, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_CODE_CHALLENGE = new ErrorObject("Invalid Parameter", -64500, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_CODE_VERIFIER = new ErrorObject("Invalid Parameter", -64499, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_REFRESH_TOKEN = new ErrorObject("Invalid Parameter", -64495, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_OA_ID = new ErrorObject("Invalid OAId", -64493, "OAId is incorrect.", "");
//    public static final ErrorObject INVALID_BODY_DATA = new ErrorObject("Invalid body data", -64492, "Invalid body data", "");
//    public static final ErrorObject INVALID_REQUIRED_PARAMS = new ErrorObject("Invalid Parameter", -64519, "Invalid Parameter", "");
//    public static final ErrorObject INVALID_GRANT_TYPE = new ErrorObject("Invalid Parameter", -64496, "Invalid Parameter", "");
//    public static final ErrorObject AUTHORIZED_CODE_EXPIRED = new ErrorObject("Authorizad code expired", -64504, "Authorized code expired", "");
//    public static final ErrorObject REFRESH_TOKEN_EXPIRED = new ErrorObject("Refresh token expired", -64491, "Refresh token expired", "");
//    public static final ErrorObject USER_NOT_IN_WHITE_LIST = new ErrorObject("Invalid Permission", -64521, "Invalid Permission", "");
//    public static final ErrorObject USER_NOT_LOGIN = new ErrorObject("User not login", -64509, "User not login", "");
//    public static final ErrorObject USER_NOT_CONSENT = new ErrorObject("Invalid Permission", -64508, "Invalid Permission", "");
//    public static final ErrorObject USER_NOT_OWN_OA = new ErrorObject("User not own OA", -64503, "User not own OA", "");
//    public static final ErrorObject USER_BANNED = new ErrorObject("User banned", -64497, "User banned", "");
//    public static final ErrorObject CANNOT_CREATE_ACCESS_TOKEN = new ErrorObject("Cannot create access token", -64501, "Cannot create access token", "");
//    public static final ErrorObject CANNOT_CREATE_CODE = new ErrorObject("Authorization failed", -64529, "Could not create Authorized code.", "");
//    public static final ErrorObject OAUTH_FAILED = new ErrorObject("Authorization failed", -64527, "Had an error when requesting authorized code", "");
//    public static final ErrorObject APPLICATION_NOT_APPROVED = new ErrorObject("The application is not approved", -64522, "Your application might be not approve or disable by admin", "");
//    public static final ErrorObject REQ_FORGOT_PASSWD_GUEST_FAIL = new ErrorObject("Forgot passwd guest account failed", -64510, "L���i trong qu�� tr��nh y��u c���u thay �����i m���t kh���u. Vui l��ng th��� l���i sau.", "");
//    public static final ErrorObject BUILD_REDIRECT_URI_FAILED = new ErrorObject("Build redirect uri failed", -64494, "Error Occur", "");
//
//public static final ErrorObject ERROR_DEFAULT = new ErrorObject("Error occured", -1000, "There was an unknown error", "");
//public static final ErrorObject CLIENT_ID_INVALID = new ErrorObject(INVALID_PARAMETER, -1001, INVALID_PARAMETER, "");
//public static final ErrorObject REDIRECT_URI_INVALID = new ErrorObject(INVALID_PARAMETER, -1002, INVALID_PARAMETER, "");
//public static final ErrorObject CLIENT_SECRET_INVALID = new ErrorObject(INVALID_PARAMETER, -1003, INVALID_PARAMETER, "");
//public static final ErrorObject AUTHORIZED_CODE_INVALID = new ErrorObject(INVALID_PARAMETER, -1004, INVALID_PARAMETER, "");
//public static final ErrorObject USER_DENIED = new ErrorObject("access_denied", -1005, "permission_error", "");
//public static final ErrorObject SESSION_INVALID = new ErrorObject(INVALID_SESSION, -1006, INVALID_SESSION, "");
//public static final ErrorObject CANNOT_CREATE_CODE = new ErrorObject("Authorization failed", -1007, "Could not create Authorized code.", "");
//public static final ErrorObject CANNOT_GET_PROFILE = new ErrorObject("Get profile user failed", -1008, "Could not create Authorized code because cant get profile.", "");
//public static final ErrorObject OAUTH_FAILED = new ErrorObject("Authorization failed", -1009, "Had an error when requesting authorized code", "");
//public static final ErrorObject REQUEST_INVALID = new ErrorObject(INVALID_PARAMETER, -1010, INVALID_PARAMETER, "");
//public static final ErrorObject CANCEL_LOGIN = new ErrorObject("Cancel login", -1011, "User has been canceled the process", "");
//public static final ErrorObject IOS_BUNDLE_ID_INVALID = new ErrorObject(INVALID_PARAMETER, -1012, INVALID_PARAMETER, "");
//public static final ErrorObject ANDROID_PACKAGE_INVALID = new ErrorObject(INVALID_PARAMETER, -1013, INVALID_PARAMETER, "");
//public static final ErrorObject APPLICATION_NOT_APPROVED = new ErrorObject("The application is not approved", -1014, "Your application might be not approve or disable by admin", "");
//public static final ErrorObject USER_NOT_IN_WHITE_LIST = new ErrorObject(INVALID_PERMISSION, -1015, INVALID_PERMISSION, "");
//public static final ErrorObject WPHONE_GUID_INVALID = new ErrorObject(INVALID_PARAMETER, -1016, INVALID_PARAMETER, "");
//public static final ErrorObject REQUIRED_PARAMS_INVALID = new ErrorObject(INVALID_PARAMETER, -1017, INVALID_PARAMETER, "");
//public static final ErrorObject AUTHORIZED_APP_FAILED = new ErrorObject(INVALID_PERMISSION, -1018, INVALID_PERMISSION, "");
//public static final ErrorObject NOT_MATCH_USER = new ErrorObject(INVALID_PERMISSION, -1019, INVALID_PERMISSION, "");
//public static final ErrorObject UPDATE_PERMISSION_FAIL = new ErrorObject(INVALID_PERMISSION, -1020, INVALID_PERMISSION, "");
//public static final ErrorObject CANNOT_GET_OPENPROFILE = new ErrorObject(INVALID_PERMISSION, -1021, INVALID_PERMISSION, "");
//public static final ErrorObject CANNOT_CREATE_OPENPROFILE = new ErrorObject(INVALID_PERMISSION, -1022, INVALID_PERMISSION, "");
//public static final ErrorObject LOGIN_ZINGME_FAIL = new ErrorObject(INVALID_PARAMETER, -1023, INVALID_PARAMETER, "");
//public static final ErrorObject REQ_CERT_GUEST_FAIL = new ErrorObject("Certificate guest account failed", -1024, "Lỗi trong quá trình bảo vệ tài khoản. Vui lòng thử lại sau.", "");
//public static final ErrorObject RECOVER_GUEST_FAIL = new ErrorObject("Certificate guest account failed", -1025, "Thông tin email hoặc mật khẩu không đúng.", "");
//public static final ErrorObject REQ_FORGOT_PASSWD_GUEST_FAIL = new ErrorObject("Forgot passwd guest account failed", -1026, "Lỗi trong quá trình yêu cầu thay đổi mật khẩu. Vui lòng thử lại sau.", "");
//public static final ErrorObject USER_NOT_LOGIN = new ErrorObject(INVALID_SESSION, -1027, INVALID_SESSION, "");
//public static final ErrorObject USER_NOT_CONSENT = new ErrorObject(INVALID_PERMISSION, -1028, INVALID_PERMISSION, "");
//public static final ErrorObject IS_DEVELOP = new ErrorObject("App is develop", -1029, "App đang develop", "");
//public static final ErrorObject APP_NOT_LINKED_OA = new ErrorObject(INVALID_PERMISSION, -1030, INVALID_PERMISSION, "");
//public static final ErrorObject CANT_SEND_EMAIL = new ErrorObject("Cant send email", -1031, "Lỗi trong quá trình bảo vệ tài khoản. Vui lòng thử lại sau.", "");
//public static final ErrorObject AUTHORIZED_CODE_EXPIRED = new ErrorObject(INVALID_PARAMETER, -1032, INVALID_PARAMETER, "");
//public static final ErrorObject USER_NOT_OWN_OA = new ErrorObject(INVALID_PERMISSION, -1033, INVALID_PERMISSION, "");
//public static final ErrorObject ZID_TOKEN_INVALID = new ErrorObject(INVALID_PARAMETER, -1034, INVALID_PARAMETER, "");
//public static final ErrorObject CANNOT_CREATE_ACCESS_TOKEN = new ErrorObject(ERROR_OCCUR, -1035, ERROR_OCCUR, "");
//public static final ErrorObject REQUIRED_CODE_CHALLENGE = new ErrorObject(INVALID_PARAMETER, -1036, INVALID_PARAMETER, "");
//public static final ErrorObject REQUIRED_CODE_VERIFIER = new ErrorObject(INVALID_PARAMETER, -1037, INVALID_PARAMETER, "");
//public static final ErrorObject REQUIRED_OAUTH_CODE = new ErrorObject(INVALID_PARAMETER, -1038, INVALID_PARAMETER, "");
//public static final ErrorObject CODE_VERIFIER_INVALID = new ErrorObject(INVALID_PARAMETER, -1039, INVALID_PARAMETER, "");