package com.zing.zalo.devicetrackingsdk;

import android.Manifest;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;

import com.zing.zalo.devicetrackingsdk.model.DeviceIdInfo;
import com.zing.zalo.devicetrackingsdk.model.SDKIDInfo;
import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.helper.Storage;
import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class BaseAppInfoStorage extends Storage{
	private final String PREF_OAUTH_CODE = "PREFERECE_ZALO_SDK_OAUTH_CODE";
	private final String PREF_SDK_ID = "PREF_SDK_ID";
	private final String PREF_PRIVATE_KEY = "PREF_PRIVATE_KEY";

	private final String PREF_TRACKING_APP_INSTALL_EXP_TIME = "PREF_TRACKING_APP_INSTALL_EXP_TIME";

	private static final String DID_FILE_NAME = "ddinfo2";

	private DeviceIdInfo deviceIdInfo;
	private SDKIDInfo sdkIdInfo;

	public BaseAppInfoStorage(Context c) {
		super(c);
		deviceIdInfo = new DeviceIdInfo();
		sdkIdInfo = new SDKIDInfo();
	}
	
	public void loadDeviceId() {
//		deviceIdInfo = new DeviceIdInfo();//thuannm 18 April: unit test: already new object deviceIdInfo in constructor
		String obj = readFromFile(context, DID_FILE_NAME);
		if(TextUtils.isEmpty(obj) == false) {
			JSONObject data;
			try {
				data = new JSONObject(obj);
				deviceIdInfo.setDeviceId(data.optString("deviceId"));
				deviceIdInfo.setDeviceIdExpiredTime(data.optLong("expiredTime"));
			} catch (JSONException e) {
			}
		}
		
		Log.v("Loaded device info: " + deviceIdInfo.toString());
	}
	
	public void loadSDKId() {
		if (sdkIdInfo == null) 
			sdkIdInfo = new SDKIDInfo();
		sdkIdInfo.setSdkId(localPref.getString(PREF_SDK_ID, ""));
		sdkIdInfo.setPrivateKey(localPref.getString(PREF_PRIVATE_KEY, ""));
		
		Log.v("Loaded sdk info: " + sdkIdInfo.toString());
	}
	
	public String getSDKId() {
		return sdkIdInfo.getSdkId();
	}
	
	public String getPrivateKey() {
		return sdkIdInfo.getPrivateKey();
	}
	
	public String getDeviceId() {
		return deviceIdInfo.getDeviceId();
	}

	public long getDeviceIdExpiredTime() {
		return deviceIdInfo.getDeviceIdExpiredTime();
	}
	
	public void setDeviceId(String deviceId, long expiredTime) {
		deviceIdInfo.setDeviceId(deviceId);
		deviceIdInfo.setDeviceIdExpiredTime(expiredTime);
		
		writeToFile(context, 
					"{\"deviceId\":\"" +deviceId+"\",\"expiredTime\":\""+expiredTime+"\"}",
					DID_FILE_NAME);
		Log.v("write device info: " + deviceIdInfo.toString());
	}

	public void setSDKId(String sdkId, String privateKey) {
		setString(PREF_SDK_ID, sdkId);
		setString(PREF_PRIVATE_KEY, privateKey);
		loadSDKId();
		Log.v("write sdkid info: " + sdkIdInfo.toString());
	}

	public long getTrackingAppInstallExpireTime() {
		return getLong(PREF_TRACKING_APP_INSTALL_EXP_TIME);
	}

	public void setTrackingAppInstallExpireTime(long expiredTime) {
		setLong(PREF_TRACKING_APP_INSTALL_EXP_TIME, expiredTime);
	}

	private File prepareFileInExternalStore(String fileName, boolean clearIfExists) {
		String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/Android/data/com.google.android.zdt.data/" + fileName;
		File f = new File(path);
		f.getParentFile().mkdirs();
		
		if(clearIfExists && f.exists()) {
			f.delete();
		}
		
		return f;
	}

	private void writeToFile(Context context, String content, String filename) {
		// write external storage
		File f;
		try {
			if (isExternalStorageWritable()) {
				f = prepareFileInExternalStore(filename, true);
				f.createNewFile();
				writeFileData(content, f);
				return;
			}
		} catch (Exception e) {
			Log.e(e);
		}

		// external storage not available, write internal storage
		try {
			f = new File(Build.VERSION.SDK_INT>=21 ? context.getNoBackupFilesDir() : context.getFilesDir(), filename);
			writeFileData(content, f);
			return;
		} catch (Exception e) {
			Log.e(e);
		}

		Log.v("can't write file " + filename);
	}

	private void writeFileData(String content, File f) throws IOException {
		FileOutputStream fos = new FileOutputStream(f);
		OutputStreamWriter streamWriter = new OutputStreamWriter(fos);
		streamWriter.write(content);
		streamWriter.close();
		fos.flush();
		fos.close();
	}


	public boolean ispreInstalled(){
		try {
			if (isExternalStorageReadable()) {
				File file = prepareFileInExternalStore(context.getPackageName(), false);
				if (file.exists()) {
					return true;
				} else {
					file.createNewFile();
					return false;
				}
			} 
		} catch (Exception e) {
			return false;
		}
		return false;
	}



	private String readFromFile(Context context, String filename) {
		File file;
		try {
			if (isExternalStorageReadable()) {
				file = prepareFileInExternalStore(filename, false);
				if (file.exists()) {
					StringBuilder stringBuilder = readFileData(file);
					return stringBuilder.toString();
				}
			}
		} catch (Exception e) {
			Log.e(e);
		}

		// external storage not exists, read from internal storage
		try {
			file = new File(Build.VERSION.SDK_INT>=21 ? context.getNoBackupFilesDir() : context.getFilesDir(), filename);
			StringBuilder stringBuilder = readFileData(file);
			return stringBuilder.toString();
		} catch (FileNotFoundException ex) {
			Log.v(Constant.LOG_TAG, "file %s not found in internal storage",
					filename);
		} catch (Exception e) {
			Log.e(e);
		}

		Log.v("can't read file " + filename);
		return null;
	}

	private StringBuilder readFileData(File file) throws IOException {
		FileInputStream fis = new FileInputStream(file);
		InputStreamReader inputStreamReader = new InputStreamReader(fis);
		BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
		String receiveString = "";
		StringBuilder stringBuilder = new StringBuilder(256);

		while ((receiveString = bufferedReader.readLine()) != null) {
			stringBuilder.append(receiveString);
		}

		fis.close();
		return stringBuilder;
	}


	/* Checks if external storage is available for read and write */
	public boolean isExternalStorageWritable() {
		boolean hasPermission = ZPermissionManager.isPermissionGranted(context, Manifest.permission.WRITE_EXTERNAL_STORAGE);
		if(!hasPermission) return false;
	    String state = Environment.getExternalStorageState();
	    if (Environment.MEDIA_MOUNTED.equals(state)) {
	        return true;
	    }
	    return false;
	}

	/* Checks if external storage is available to at least read */
	public boolean isExternalStorageReadable() {
		boolean hasPermission = ZPermissionManager.isPermissionGranted(context, Manifest.permission.WRITE_EXTERNAL_STORAGE);
		if(!hasPermission) return false;
		
	    String state = Environment.getExternalStorageState();
	    if (Environment.MEDIA_MOUNTED.equals(state) ||
	        Environment.MEDIA_MOUNTED_READ_ONLY.equals(state)) {
	        return true;
	    }
	    return false;
	}
	
	public String getOAuthCode() {
		return getString(PREF_OAUTH_CODE);
	}
}