package com.zing.zalo.zalosdk.core.helper;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.res.Configuration;
import android.graphics.Point;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;

import com.zing.zalo.devicetrackingsdk.DeviceTracking;
import com.zing.zalo.devicetrackingsdk.GetPreloadSettingAsyncTask;
import com.zing.zalo.devicetrackingsdk.GetSDKSettingAsyncTask;
import com.zing.zalo.devicetrackingsdk.ZPermissionManager;
import com.zing.zalo.devicetrackingsdk.model.PreloadInfo;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.exception.PreloadException;
import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class DeviceHelper {


   static String MNO;
   static String screenSize;
   static Location location;
   static String WLANMacAddress;

   public static boolean isTablet(final Context context) {
      return (context.getResources().getConfiguration().screenLayout
            & Configuration.SCREENLAYOUT_SIZE_MASK)
            >= Configuration.SCREENLAYOUT_SIZE_LARGE;
   }

   public static float pxFromDp(final Context context, final float dp) {
      return dp * context.getResources().getDisplayMetrics().density;
   }

   public static String getOSVersion() {
      return Build.VERSION.RELEASE;
   }

   public static String getBrand() {
      return Build.BRAND;
   }

   public static String getManufacturer() {
      return Build.MANUFACTURER;
   }

   public static String getProduct() {
      return Build.PRODUCT;
   }

   public static String getMobileNetworkCode(Context context) {
      if (MNO != null) return MNO;

      try {
         if (ZPermissionManager.isPermissionGranted(context, Manifest.permission.READ_PHONE_STATE)) {
            TelephonyManager tel = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
            MNO = tel.getSimOperator();
         } else {
            MNO = "unknown";
         }
      } catch (Exception ex) {
         MNO = "unknown";
      }
      return MNO;
   }

   public static String getSerial() {
      return "unknown";
   }

   public static String getModel() {
      return Build.MODEL;
   }

   public static String getScreenSize(Context context) {
      if (screenSize != null) return screenSize;

      try {
         WindowManager wm = (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);
         Display display = wm.getDefaultDisplay();
         Point point = new Point();
         display.getSize(point);
         screenSize = point.x + "x" + point.y;
      } catch (Exception ex) {
         screenSize = "unknown";
      }

      return screenSize;
   }

   @SuppressLint("MissingPermission")
   public static Location getLocation(Context context) {
      if (location != null) return location;

      try {
         if (ZPermissionManager.isPermissionGranted(context, Manifest.permission.ACCESS_FINE_LOCATION) ||
               ZPermissionManager.isPermissionGranted(context, Manifest.permission.ACCESS_COARSE_LOCATION)) {
            LocationManager locationManager = (LocationManager) context
                  .getSystemService(Context.LOCATION_SERVICE);
            if (locationManager != null) {
               location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
            }
         }
      } catch (Exception ex) {
      }
      return location;
   }


   public static String getConnectionType(Context context) {
      try {
         ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
         @SuppressLint("MissingPermission") NetworkInfo info = cm.getActiveNetworkInfo();
         if (info != null && info.isConnected()) {
            if (info.getType() == ConnectivityManager.TYPE_WIFI)
               return "wifi";
            else if (info.getType() == ConnectivityManager.TYPE_MOBILE)
               return "mobile";

         }
      } catch (Error ignored) {
      } catch (Exception ignored) {
      }

      return "";
   }


   /**
    * Returns wlan MAC address of the given interface name.
    *
    * @return mac address or empty string
    */
   public static String getWLANMACAddress(Context context) {
      if (WLANMacAddress != null) return WLANMacAddress;

      WLANMacAddress = getMACAddress(context, "wlan0");
      return WLANMacAddress;
   }

   @SuppressLint("NewApi")
   private static String getMACAddress(Context context, String interfaceName) {
      return "";
   }

   public static String getAndroidId(Context context) {
      return "unknown";
   }

   static String advertiserId;

   //do not call this on main thread
   public static String getAdvertiseID(Context context) {
      if (advertiserId != null) return advertiserId;

      SharedPreferences pref = context.getSharedPreferences("adsid", 0);
      try {
         advertiserId = pref.getString("adsidstr", null);
         if (advertiserId != null) {
            return advertiserId;
         }

         if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new Exception("DeviceHelper.getAdvertiseID call on main thread!!");
         }

         Method getAdvertisingIdInfo = getMethodQuietly(
               "com.google.android.gms.ads.identifier.AdvertisingIdClient",
               "getAdvertisingIdInfo",
               Context.class
         );
         if (getAdvertisingIdInfo != null) {
            Object advertisingInfo = invokeMethodQuietly(null, getAdvertisingIdInfo, context);
            if (advertisingInfo != null) {
               Method getId = getMethodQuietly(advertisingInfo.getClass(), "getId");
               Method isLimitAdTrackingEnabled = getMethodQuietly(advertisingInfo.getClass(), "isLimitAdTrackingEnabled");
               if (getId != null && isLimitAdTrackingEnabled != null) {
                  String result = (String) invokeMethodQuietly(advertisingInfo, getId);
                  if (result != null && result.length() > 0) {
                     advertiserId = result;
                  }
               }
            }
         }
      } catch (Exception ex) {
         Log.e("getAdvertiseID",ex);
      }

      //save to share pref
      if (advertiserId != null && advertiserId.length() > 0) {
         Editor editor = pref.edit();
         editor.putString("adsidstr", advertiserId);
         editor.commit();
      }


      return advertiserId;
   }


   private static Method getMethodQuietly(Class<?> clazz, String methodName, Class<?>... parameterTypes) {
      try {
         return clazz.getMethod(methodName, parameterTypes);
      } catch (NoSuchMethodException ex) {
         return null;
      }
   }

   private static Method getMethodQuietly(String className, String methodName, Class<?>... parameterTypes) {
      try {
         Class<?> clazz = Class.forName(className);
         return getMethodQuietly(clazz, methodName, parameterTypes);
      } catch (ClassNotFoundException ex) {
         return null;
      }
   }

   private static Object invokeMethodQuietly(Object receiver, Method method, Object... args) {
      try {
         return method.invoke(receiver, args);
      } catch (IllegalAccessException ex) {
         return null;
      } catch (InvocationTargetException ex) {
         return null;
      }
   }


   private static String processName;

   public static String getCurrentProcessName(Context context) {
      if (processName != null) return processName;
      try {
         int pid = android.os.Process.myPid();
         ActivityManager manager = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
         for (ActivityManager.RunningAppProcessInfo processInfo : manager.getRunningAppProcesses()) {
            if (processInfo.pid == pid) {
               processName = processInfo.processName;
            }
         }
      } catch (Exception ex) {
         Log.e(ex);
         processName = "";
      }

      return processName;
   }

   public static PreloadInfo preloadInfo;
   private static final Object lock = new Object();

   public static PreloadInfo getPreloadInfo(Context context) {
      synchronized (lock) {
         if (preloadInfo != null) {
            return preloadInfo;
         }


         //load from cache
         String preload = Utils.getSavedPreloadValue(context);
         String error = Utils.getExceptionFilePreload(context);
         if (preloadInfo != null || !TextUtils.isEmpty(error)/*error != null*/) {
            preloadInfo = new PreloadInfo(context, preload, error);
            return preloadInfo;
         }

          try {
              readingPreloadNewMethod(context);
          } catch (Throwable throwable) {
              readingPreloadOldMethod(context);
          }


         //cache it
         Utils.savePreloadValue(context, preloadInfo.preload);
         Utils.saveExceptionFilePreload(context, preloadInfo.error);
      }
      return preloadInfo;
   }

   public static void getPreloadInfo(final Context context, final PreloadReadListener preloadReadListener) {
      synchronized (lock) {
         //Read preload from file first
         //If true then callback intermediate
         //If false will get Preload Setting from server => checking isApkPreload => callback
         getPreloadInfo(context);
         if ( !preloadInfo.isPreloaded() && SettingsManager.getInstance().isExpiredPreloadSetting(context)) {
            DeviceTracking.getInstance().getDeviceId(new DeviceTracking.GetInfoListener() {
               @Override
               public void onGetDeviceIdComplete(String deviceId) {

                  GetPreloadSettingAsyncTask task = new GetPreloadSettingAsyncTask(context, new GetPreloadSettingAsyncTask.Callback() {
                     @Override
                     public void onSuccess() {
                        if (preloadReadListener != null && preloadInfo != null) {
                           preloadReadListener.onResult(preloadInfo.isPreloaded(), preloadInfo.preload);
                        }
                     }

                     @Override
                     public void onFailed(int errorCode, String errorMsg) {
                        Log.e("getPreloadInfo", "Error message: " + errorMsg);
                         if (preloadReadListener != null) {
                             preloadReadListener.onResult(preloadInfo.isPreloaded(), preloadInfo.preload);
                         }
                     }
                  }, deviceId);
                  task.execute();
               }
            });
         }
         else {
            preloadReadListener.onResult(preloadInfo.isPreloaded(), preloadInfo.preload);
         }

      }
   }

   public interface PreloadReadListener {
      void onResult(boolean isPreload, String preloadValue);
   }


   private static void readingPreloadOldMethod(Context context) {
      int count = 0;
      //load from file

      ArrayList<String> preloadPath = new ArrayList<>();

      String vivoNewPath = getVivoPreloadPath("ro.preinstall.path", "") + "zalo_appchannel.in";

      preloadPath.add(vivoNewPath);  //vivo new
      preloadPath.add("/data/etc/appchannel/zalo_appchannel.in"); //oppo new
      preloadPath.add("/data/etc/appchannel"); //oppo old
      preloadPath.add("/system/etc/zalo_appchannel.in"); //vivo old
      preloadPath.add("/my_preload/etc/appchannel/zalo_appchannel.in"); // //oppo new for R

      try {
         preloadInfo = new PreloadInfo(context);
         JSONArray preloadJSonFailed = new JSONArray();
         for (String filePath : preloadPath) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("fileCode", preloadPath.indexOf(filePath));
            jsonObject.put("filePath", filePath);

            try {
               String data = Utils.readTextFile(filePath);
               if (!TextUtils.isEmpty(data)) {
                  if (data.contains(":")) {
                     String[] preloadData = data.split(":");
                     if (preloadData.length == 2) {
                        preloadInfo.preload = preloadData[1].trim();
                        preloadJSonFailed.put(jsonObject);
                        break;
                     }
                  } else {
                     jsonObject.put("err", "-3");
                  }
               } else {
                  jsonObject.put("err", "-4");
               }

            } catch (FileNotFoundException ex) {
               jsonObject.put("err", "-2");
               count++;
            } catch (Exception ex) {
               jsonObject.put("err", "-1: " + ex.getMessage());
            }

            preloadJSonFailed.put(jsonObject);
         }

         preloadInfo.error = preloadJSonFailed.toString();
      } catch (JSONException ex) {
         Log.e("readingPreloadOldMethod",ex);
      }
      if (count == preloadPath.size()) {
         preloadInfo.preload = "";
         preloadInfo.error = "";//all files not found, if another exception will submit to server
      }
   }

   public static void readingPreloadNewMethod(Context context) throws Throwable {
      //new preload on Device SAMSUNG
       preloadInfo = new PreloadInfo(context);
       JSONArray preloadJSonFailed = new JSONArray();
       JSONObject jsonObject = new JSONObject();
       boolean tryOldPreloadCheckingMethod = false;
      try {
         @SuppressLint("PrivateApi")
         Class<?> sp = Class.forName("android.os.SystemProperties");
         Method getMethod = sp.getMethod("get", String.class, String.class);
         String trackingId = (String) getMethod.invoke(null, "ro.trackingId." + AppInfo.getPackageName(context), "");// The value when  Partner  read  System Property(ro.trackingId.com.abcd.app)
//         String channelId = (String) getMethod.invoke(null, "ro.channelId." + AppInfo.getPackageName(context), ""); // The value when  Partner  read  System Property(ro.channelId.com.abcd.app)

          if (!TextUtils.isEmpty(trackingId)) {
              preloadInfo.preload = trackingId;
          }
          else {
              jsonObject.put("err", "-2");
              tryOldPreloadCheckingMethod = true;
          }
      } catch (Throwable ex) {
          tryOldPreloadCheckingMethod = true;
          jsonObject.put("err", "-1: " + ex.getMessage());
      }

       preloadJSonFailed.put(jsonObject);
       preloadInfo.error = preloadJSonFailed.toString();

       if ( tryOldPreloadCheckingMethod ) {
           throw new PreloadException("Failed to get preload while using new method !");
       }
   }

   private static String getVivoPreloadPath (String key, String defaultValue) {
      String value = defaultValue;
      try {
         Class<?> c = Class.forName("android.os.SystemProperties");
         Method get = c.getMethod("get",String.class,String.class);
         value = (String) (get.invoke(c,key,"null"));
      }
      catch (Exception e){
         e.printStackTrace();
      }
      return value;
   }

}
