package com.zing.zalo.zalosdk.core.helper;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;

public class Storage {
	protected SharedPreferences localPref;
	protected Context context;
	
	public Storage(Context c) {
		context = c;
		localPref = PreferenceManager.getDefaultSharedPreferences(c);
	}
	
	
	protected String getString(String key) {
		return localPref.getString(key, "");
	}
	
	protected void setString(String key, String value) {
		Editor edit = localPref.edit();
		edit.putString(key, value);
		edit.apply();
	}
	
	protected int getInt(String key) {
		return localPref.getInt(key, 0);
	}
	
	protected void setInt(String key, int value) {
		Editor edit = localPref.edit();
		edit.putInt(key, value);
		edit.apply();
	}
	
	protected long getLong(String key) {
		return localPref.getLong(key,0);
	}
	
	protected void setLong(String key, long value) {
		Editor edit = localPref.edit();
		edit.putLong(key, value);
		edit.apply();
	}

	public static void setBoolean(Context context, String key, boolean value) {
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
		Editor editor = sp.edit();
		editor.putBoolean(key, value);
		editor.apply();
	}

	public static boolean getBoolean(Context context, String key) {
		SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
		return sp.getBoolean(key, false);
	}
}