package com.zing.zalo.devicetrackingsdk;

import android.content.Context;
import android.os.AsyncTask;

import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.SettingsManager;
import com.zing.zalo.zalosdk.core.helper.AppInfo;
import com.zing.zalo.zalosdk.core.helper.DeviceHelper;
import com.zing.zalo.zalosdk.core.helper.Utils;
import com.zing.zalo.zalosdk.core.http.HttpClientRequest;
import com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager;

import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.ref.WeakReference;

import static com.zing.zalo.zalosdk.core.servicemap.ServiceMapManager.KEY_URL_CENTRALIZED;

public class GetSDKSettingAsyncTask extends AsyncTask<Context, Void, String> {

    /**
     * pkg  (packageName )
     * appId
     * sdkv (sdk version)
     * pl (platform)
     * zdId (global id)
     */
    WeakReference<Context> weakContext;
    String zdId;
    Callback callback;
    long wakeup_interval, expiredTime;
    boolean wakeup_interval_enable;

    public interface Callback {
        void onSucc(long wakeup_interval);

        void onFailed(int errorCode, String errorMsg);
    }

    public GetSDKSettingAsyncTask(Context _context, Callback _callback, String _zdId) {
        weakContext = new WeakReference<>(_context);
        callback = _callback;
        zdId = _zdId;
    }

    @Override
    protected String doInBackground(Context... contexts) {
        try {
            Context context = weakContext.get();

            if (context == null) return "";

            SettingsManager settingsMgr = SettingsManager.getInstance();
            final String requestUrl = ServiceMapManager.getInstance().urlFor(KEY_URL_CENTRALIZED, Constant.API_GET_SETTING_URL);
            HttpClientRequest request = new HttpClientRequest(HttpClientRequest.Type.GET, requestUrl);
            request.addParams("pl", "android");
            request.addParams("appId", AppInfo.getAppId(context));
            request.addParams("sdkv", DeviceTracking.getInstance().getVersion());
            request.addParams("pkg", context.getPackageName());
            request.addParams("adid", DeviceHelper.getAdvertiseID(context));
            request.addParams("zdId", zdId);

            try {
                JSONObject object = request.getJSON();
                int errorCode = object.getInt("error");
                if (errorCode == 0) {
                    JSONObject data = object.getJSONObject("data");
                    if (data == null || !data.has("setting")) {
                        if (callback != null)
                            callback.onFailed(errorCode, "");
                    } else {
                        settingsMgr.setUseWebViewUnLoginZalo(context, Utils.getBoolean(data, "webview_login"));
                        settingsMgr.setLoginViaBrowser(context, Utils.getBoolean(data, "isOutAppLogin"));

                        data = data.getJSONObject("setting");

                        if(data.has("model_preload")) {
                            JSONArray modelPreloadArray = data.getJSONArray("model_preload");
                            settingsMgr.setModelPreloadSetting(context, modelPreloadArray.toString());
                        }

                        if(data.has("brand_preload")) {
                            JSONArray brandPreloadArray = data.getJSONArray("brand_preload");
                            settingsMgr.setBrandPreloadSetting(context, brandPreloadArray.toString());
                        }

                        if(data.has("preload_default")) {
                            JSONArray preloadDefaultArray = data.getJSONArray("preload_default");
                            settingsMgr.setPreloadDefaultSetting(context, preloadDefaultArray.toString());
                        }


                        if (data.has("wakeup_interval")) {
                            wakeup_interval = data.getLong("wakeup_interval");
                            settingsMgr.saveWakeUpInterval(context, wakeup_interval);
                            if (data.has("expiredTime")) {
                                expiredTime = data.getLong("expiredTime");
                                settingsMgr.saveExpiredSetting(context, expiredTime + System.currentTimeMillis());
                            }

                            if (data.has("wakeup_interval_enable")) {
                                wakeup_interval_enable = data.getBoolean("wakeup_interval_enable");
                                settingsMgr.saveWakeUpSetting(context, wakeup_interval_enable);//default will be False
                            }



                            if (callback != null) {
                                callback.onSucc(wakeup_interval);
                            }
                        } else {
                            if (callback != null)
                                callback.onFailed(errorCode, "");
                        }
                    }
                } else {
                    if (callback != null)
                        callback.onFailed(errorCode, "");
                }
            } catch (Exception ex) {
                if (callback != null)
                    callback.onFailed(-108, "Exception error " + ex.getMessage());
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }

}
