package com.zing.zalo.zalosdk.core.helper;

import static com.zing.zalo.zalosdk.Constant.PREFS_NAME_WAKEUP;

import android.Manifest;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.util.Base64;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

import com.zing.zalo.zalosdk.Constant;
import com.zing.zalo.zalosdk.core.log.Log;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import javax.crypto.Cipher;


public class Utils {


  private static final String KEY_PRELOAD = "com.zing.zalo.sdk.preloadkey";
  private static final String KEY_EXCEPTION_FILE_PRELOAD = "com.zing.zalo.sdk.preloadkey.exception";

  /**
   * Java Reflection to init ZingAnalytics incase remove ZingAnalytics package
   */
  public static void initZingAnalytics(Application _app, String _appId) {
    try {
      Class c = Class.forName("com.zing.zalo.devicetrackingsdk.ZingAnalyticsManager");
      if (c != null) {
        Method method = c.getMethod("getInstance", null);
        if (method != null) {
          Object o = method.invoke(null, null);
          if (o != null) {
            Method methodAdd = c.getMethod("init", Application.class, String.class);
            if (methodAdd != null) {
              methodAdd.invoke(o, _app, _appId);
            }
          }
        }
      }
    } catch (Exception ignored) {
    }
  }

  /**
   * Java Reflection to init ZaloSDK
   */
  public static boolean initZaloSDK(Application app) {
    try {
      Class c = Class.forName("com.zing.zalo.zalosdk.oauth.ZaloSDKApplication");
      if (c != null) {
        Method method = c.getMethod("wrap", Application.class);
        if (method != null) {
          method.invoke(null, app);
        }
      }
    } catch (Exception e) {
      return false;
    }

    return true;
  }

  public static String getSignature(String[] params, String[] values, String secretKey) {
    StringBuilder builder = new StringBuilder();
    ArrayList<String> list = new ArrayList<String>();
    try {
      list.clear();
      int len = params.length;
      for (int i = 0; i < len; ++i) {
        list.add(params[i] + "=" + values[i]);
      }

      Collections.sort(list);
      for (String str : list) {
        builder.append(str);
      }
      builder.append(secretKey);
      Log.v("bsig: " + builder.toString());
      return md5(builder.toString());
    } catch (Exception ex) {
      ex.printStackTrace();
    }

    return "";

  }

  public static String md5(String input) {
    String res = "";
    try {
      MessageDigest algorithm = MessageDigest.getInstance("MD5");
      algorithm.reset();
      algorithm.update(input.getBytes());
      byte[] md5 = algorithm.digest();
      String tmp = "";
      for (int i = 0; i < md5.length; i++) {
        tmp = (Integer.toHexString(0xFF & md5[i]));
        if (tmp.length() == 1) {
          res += "0" + tmp;
        } else {
          res += tmp;
        }
      }
    } catch (NoSuchAlgorithmException ex) {
    }
    return res;
  }

  public static boolean isPackageExisted(Context context, String targetPackage) {
    PackageManager pm = context.getPackageManager();
    try {
      pm.getPackageInfo(targetPackage, PackageManager.GET_META_DATA);
    } catch (NameNotFoundException e) {
      return false;
    }
    return true;
  }

  public static JSONArray listToJSONObject(List<String> array) {
    JSONArray object = new JSONArray();

    for (String str : array) {
      object.put(str);
    }

    return object;
  }

  public static JSONObject mapToJSONObject(Map<String, String> map) {
    return addMapToJSONObject(null, map);
  }

  public static JSONObject addMapToJSONObject(JSONObject object, Map<String, String> map) {
    if (object == null) {
      object = new JSONObject();
    }

    if (map == null) {
      return object;
    }

    for (String key : map.keySet()) {
      try {
        object.put(key, map.get(key));
      } catch (JSONException e) {
        //Log.e(e);
      }
    }

    return object;
  }

  public static boolean belowSandwich() {
    return Build.VERSION.SDK_INT < Build.VERSION_CODES.ICE_CREAM_SANDWICH;
  }


  public static boolean isPermissionGranted(Context context, String permission) {
    int permissionCheck = -1;
    if (android.os.Build.VERSION.SDK_INT >= 23) {
      java.lang.reflect.Method method;
      try {
        method = context.getClass().getMethod("checkSelfPermission", String.class);
        if (method != null) {
          permissionCheck = (Integer) method.invoke(context, permission);
        } else {
          permissionCheck = context.getPackageManager().checkPermission(permission, context.getPackageName());
        }
      } catch (Exception e) {
        e.printStackTrace();
      }
    } else {
      permissionCheck = context.getPackageManager().checkPermission(permission, context.getPackageName());
    }
		return permissionCheck == PackageManager.PERMISSION_GRANTED;
	}


  public static void hideSoftKeyboard(Activity activity) {
    if (activity != null) {
      InputMethodManager inputMethodManager = (InputMethodManager) activity
            .getSystemService(Activity.INPUT_METHOD_SERVICE);
      if (inputMethodManager != null) {
        View focus = activity.getCurrentFocus();
        if (focus != null)
          inputMethodManager.hideSoftInputFromWindow(focus.getWindowToken(),
                InputMethodManager.HIDE_NOT_ALWAYS);
        else
          activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
      }

    }
  }

  public static boolean isOnline(Context ctx) {
    try {
      if (!isPermissionGranted(ctx, Manifest.permission.ACCESS_WIFI_STATE)) return true;
      ConnectivityManager cm = (ConnectivityManager) ctx.getSystemService(Context.CONNECTIVITY_SERVICE);
      @SuppressLint("MissingPermission") NetworkInfo netInfo = cm.getActiveNetworkInfo();
      if (netInfo != null && netInfo.isConnectedOrConnecting()) {
        return true;
      }
    } catch (Exception e) {
      return true;
    }

    return false;
  }


  /**
   * Utils.getResourceId(this, "zalosdk_activity_zalo_web_login", "layout")
   *
   * @param context
   * @param variableName
   * @param resourcename
   * @return
   */

  public static int getResourceId(Context context, String variableName, String resourcename) {
    try {
      return context.getResources().getIdentifier(variableName, resourcename, context.getPackageName());
    } catch (Exception e) {
      e.printStackTrace();
      return -1;
    }
  }

  public static void saveExceptionFilePreload(Context context, String json) {
    saveString(context, Constant.PREFS_NAME_PRELOAD, KEY_EXCEPTION_FILE_PRELOAD, json);
  }

  public static String getExceptionFilePreload(Context context) {
    return getSavedString(context, Constant.PREFS_NAME_PRELOAD, KEY_EXCEPTION_FILE_PRELOAD);
  }

  public static void savePreloadValue(Context context, String preloadValue) {
    saveString(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD, preloadValue);
  }

  public static String getSavedPreloadValue(Context context) {
    return getSavedString(context, Constant.PREFS_NAME_PRELOAD, KEY_PRELOAD);
  }

  public static String loadListDeviceIDWakeUp(Context context) {
    return getSavedString(context, PREFS_NAME_WAKEUP, Constant.KEY_LIST_DEVICEID_WAKE_UP);
  }

  public static void saveString(Context context, String prefName, String key, String value) {
    if (context != null) {
      try {
        SharedPreferences.Editor prefEditor = context.getSharedPreferences(prefName, Context.MODE_PRIVATE).edit();
        prefEditor.putString(key, value);
        prefEditor.apply();
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }

  public static String getSavedString(Context context, String prefName, String key) {
    String value = "";
    if (context != null) {
      try {
        SharedPreferences settings = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        value = settings.getString(key, "");
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
    return value;
  }

  public static void saveInt(Context context, String prefName, String key, int value) {
    if (context != null) {
      try {
        SharedPreferences.Editor prefEditor = context.getSharedPreferences(prefName, Context.MODE_PRIVATE).edit();
        prefEditor.putInt(key, value);
        prefEditor.apply();
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }

  public static int getSavedInt(Context context, String prefName, String key) {
    int value = 0;
    if (context != null) {
      try {
        SharedPreferences settings = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        value = settings.getInt(key, -1);
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
    return value;
  }

  public static void saveLong(Context context, String prefName, String key, long value) {
    if (context != null) {
      try {
        SharedPreferences.Editor prefEditor = context.getSharedPreferences(prefName, Context.MODE_PRIVATE).edit();
        prefEditor.putLong(key, value);
        prefEditor.apply();
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }

  public static long getSavedLong(Context context, String prefName, String key) {
    long value = 0;
    if (context != null) {
      try {
        SharedPreferences settings = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        value = settings.getLong(key, -1);
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
    return value;
  }

  public static void saveBoolean(Context context, String prefName, String key, boolean value) {
    if (context != null) {
      try {
        SharedPreferences.Editor prefEditor = context.getSharedPreferences(prefName, Context.MODE_PRIVATE).edit();
        prefEditor.putBoolean(key, value);
        prefEditor.apply();
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
  }

  public static boolean getSavedBoolean(Context context, String prefName, String key) {
    boolean value = false;
    if (context != null) {
      try {
        SharedPreferences settings = context.getSharedPreferences(prefName, Context.MODE_PRIVATE);
        value = settings.getBoolean(key, false);
      } catch (Exception ex) {
        ex.printStackTrace();
      }
    }
    return value;
  }

  public static String readTextFile(String filePath) throws IOException {
    File file = new File(filePath);
    FileInputStream fis = new FileInputStream(file);
    InputStreamReader inputStreamReader = new InputStreamReader(fis);
    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
    String receiveString = "";

    StringBuilder stringBuilder = new StringBuilder(256);

    while ((receiveString = bufferedReader.readLine()) != null) {
      stringBuilder.append(receiveString);
    }

    fis.close();
    return stringBuilder.toString();
  }

  public static String getSDKVersion() {
    return Constant.VERSION;
  }

  public static int getSDKVersionCode() {
    return Constant.VERSION_CODE;
  }

  public static String getWLANMACAddress(Context context) {
    return DeviceHelper.getWLANMACAddress(context);
  }

  public static String getConnectionType(Context context) {
    return DeviceHelper.getConnectionType(context);
  }

  public static String getAdvertiseID(Context context) {
    return DeviceHelper.getAdvertiseID(context);
  }

  public static boolean getBoolean(JSONObject obj, String key) {
    if (obj.has(key)) {
      try {
        return obj.getBoolean(key);
      } catch (JSONException e) {
        try {
          return obj.getInt(key) != 0;
        } catch (JSONException ignored) {
        }
      }
    }
    return false;
  }

  public static byte[] gzipCompress(String string) throws IOException {
    ByteArrayOutputStream os = new ByteArrayOutputStream(string.length());
    GZIPOutputStream gos = new GZIPOutputStream(os);
    gos.write(string.getBytes());
    gos.close();
    byte[] compressed = os.toByteArray();
    os.close();
    return compressed;
  }

  public static String gzipDecompress(byte[] compressed) throws IOException {
    final int BUFFER_SIZE = 32;
    ByteArrayInputStream is = new ByteArrayInputStream(compressed);
    GZIPInputStream gis = new GZIPInputStream(is, BUFFER_SIZE);
    StringBuilder string = new StringBuilder();
    byte[] data = new byte[BUFFER_SIZE];
    int bytesRead;
    while ((bytesRead = gis.read(data)) != -1) {
      string.append(new String(data, 0, bytesRead));
    }
    gis.close();
    is.close();
    return string.toString();
  }

  public static String genCodeVerifier() {
    SecureRandom sr = new SecureRandom();
    byte[] code = new byte[32];
    sr.nextBytes(code);
    return Base64.encodeToString(code, Base64.URL_SAFE | Base64.NO_WRAP | Base64.NO_PADDING);
  }

  public static String genCodeChallenge(String codeVerifier) {
    String result = null;
    try {
      byte[] bytes = codeVerifier.getBytes("US-ASCII");
      MessageDigest md = MessageDigest.getInstance("SHA-256");
      md.update(bytes, 0, bytes.length);
      byte[] digest = md.digest();
      result = Base64.encodeToString(digest, Base64.URL_SAFE | Base64.NO_WRAP | Base64.NO_PADDING);

    } catch (Exception ex) {
    }
    return result;
  }

  public static String encryptRSA(String text) {
    String result = null;
    try {
      byte[] encoded = Base64.decode(Constant.PUBLIC_RSA, Base64.DEFAULT);
      KeyFactory kf = KeyFactory.getInstance("RSA");
      PublicKey pubKey = kf.generatePublic(new X509EncodedKeySpec(encoded));
      Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
      cipher.init(Cipher.ENCRYPT_MODE, pubKey);
      byte[] encrypted = cipher.doFinal(text.getBytes());
      result = Base64.encodeToString(encrypted, Base64.DEFAULT);
    } catch (Exception e) {

    }
    return result;

  }
}
